%--------------------------------------------------------------------------
% File     : NUM003=GodelNum1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Axioms   : Substitution axioms for number theory axioms
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   27 (   0 non-Horn)(   0 units)
%            Number of literals          :   55 (  53 equality)
%            Number of predicate symbols :    2 (   0 propositions)
%            Number of function symbols  :   17 (   0 constants)
%            Number of variables         :   72 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : These should be in the Boyer paper, but they use 
%            paramodulation, and hence omit them.
%          : Based on Godel's set theory axioms, and hence require that 
%            Godel's set theory and abstract algebra axioms also be used.
%--------------------------------------------------------------------------
input_clause(f43_substitution1,axiom,
    [--equal(A,B),
     ++equal(f43(A,C),f43(B,C))]).

input_clause(f43_substitution2,axiom,
    [--equal(D,E),
     ++equal(f43(F,D),f43(F,E))]).

input_clause(f44_substitution1,axiom,
    [--equal(G,H),
     ++equal(f44(G),f44(H))]).

input_clause(f45_substitution1,axiom,
    [--equal(I,J),
     ++equal(f45(I,K),f45(J,K))]).

input_clause(f45_substitution2,axiom,
    [--equal(L,M),
     ++equal(f45(N,L),f45(N,M))]).

input_clause(f46_substitution1,axiom,
    [--equal(O,P),
     ++equal(f46(O,Q),f46(P,Q))]).

input_clause(f46_substitution2,axiom,
    [--equal(R,S),
     ++equal(f46(T,R),f46(T,S))]).

input_clause(f47_substitution1,axiom,
    [--equal(U,V),
     ++equal(f47(U,W),f47(V,W))]).

input_clause(f47_substitution2,axiom,
    [--equal(X,Y),
     ++equal(f47(Z,X),f47(Z,Y))]).

input_clause(f48_substitution1,axiom,
    [--equal(A1,B1),
     ++equal(f48(A1,C1),f48(B1,C1))]).

input_clause(f48_substitution2,axiom,
    [--equal(D1,E1),
     ++equal(f48(F1,D1),f48(F1,E1))]).

input_clause(f49_substitution1,axiom,
    [--equal(G1,H1),
     ++equal(f49(G1),f49(H1))]).

input_clause(f50_substitution1,axiom,
    [--equal(I1,J1),
     ++equal(f50(I1,K1),f50(J1,K1))]).

input_clause(f50_substitution2,axiom,
    [--equal(L1,M1),
     ++equal(f50(N1,L1),f50(N1,M1))]).

input_clause(f51_substitution1,axiom,
    [--equal(O1,P1),
     ++equal(f51(O1,Q1),f51(P1,Q1))]).

input_clause(f51_substitution2,axiom,
    [--equal(R1,S1),
     ++equal(f51(T1,R1),f51(T1,S1))]).

input_clause(f52_substitution1,axiom,
    [--equal(U1,V1),
     ++equal(f52(U1,W1),f52(V1,W1))]).

input_clause(f52_substitution2,axiom,
    [--equal(X1,Y1),
     ++equal(f52(Z1,X1),f52(Z1,Y1))]).

input_clause(f53_substitution1,axiom,
    [--equal(A2,B2),
     ++equal(f53(A2,C2),f53(B2,C2))]).

input_clause(f53_substitution2,axiom,
    [--equal(D2,E2),
     ++equal(f53(F2,D2),f53(F2,E2))]).

input_clause(f54_substitution1,axiom,
    [--equal(G2,H2),
     ++equal(f54(G2),f54(H2))]).

input_clause(f55_substitution1,axiom,
    [--equal(I2,J2),
     ++equal(f55(I2),f55(J2))]).

input_clause(f56_substitution1,axiom,
    [--equal(K2,L2),
     ++equal(f56(K2),f56(L2))]).

input_clause(f57_substitution1,axiom,
    [--equal(M2,N2),
     ++equal(f57(M2),f57(N2))]).

input_clause(f58_substitution1,axiom,
    [--equal(O2,P2),
     ++equal(f58(O2),f58(P2))]).

input_clause(f59_substitution1,axiom,
    [--equal(Q2,R2),
     ++equal(f59(Q2),f59(R2))]).

input_clause(finite_substitution1,axiom,
    [--equal(M14,N14),
     --finite(M14),
     ++finite(N14)]).
%--------------------------------------------------------------------------
