%--------------------------------------------------------------------------
% File     : LAT002=Latt1-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Lattice Theory
% Axioms   : Substitution axioms for the lattice theory axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [McCharen, et al., 1976]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   0 units)
%            Number of literals          :   26 (  14 equality)
%            Number of predicate symbols :    3 (   0 propositions)
%            Number of function symbols  :    2 (   0 constants)
%            Number of variables         :   36 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : These axioms are used in [Wos, 1988, p. 215].
%--------------------------------------------------------------------------
input_clause(join_of_substitution1,axiom,
    [--equal(D,E),
     ++equal(join_of(D,F),join_of(E,F))]).

input_clause(join_of_substitution2,axiom,
    [--equal(G,H),
     ++equal(join_of(I,G),join_of(I,H))]).

input_clause(meet_of_substitution1,axiom,
    [--equal(J,K),
     ++equal(meet_of(J,L),meet_of(K,L))]).

input_clause(meet_of_substitution2,axiom,
    [--equal(M,N),
     ++equal(meet_of(O,M),meet_of(O,N))]).

input_clause(join_substitution1,axiom,
    [--equal(P,Q),
     --join(P,R,S),
     ++join(Q,R,S)]).

input_clause(join_substitution2,axiom,
    [--equal(T,U),
     --join(V,T,W),
     ++join(V,U,W)]).

input_clause(join_substitution3,axiom,
    [--equal(X,Y),
     --join(Z,A1,X),
     ++join(Z,A1,Y)]).

input_clause(meet_substitution1,axiom,
    [--equal(B1,C1),
     --meet(B1,D1,E1),
     ++meet(C1,D1,E1)]).

input_clause(meet_substitution2,axiom,
    [--equal(F1,G1),
     --meet(H1,F1,I1),
     ++meet(H1,G1,I1)]).

input_clause(meet_substitution3,axiom,
    [--equal(J1,K1),
     --meet(L1,M1,J1),
     ++meet(L1,M1,K1)]).
%--------------------------------------------------------------------------
