%--------------------------------------------------------------------------
% File     : HEN002=Henkin2Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Axioms   : Substitution axioms for Henkin model axioms
% Version  : [McCharen, et al., 1976] (equality) axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   0 units)
%            Number of literals          :   10 (   6 equality)
%            Number of predicate symbols :    2 (   0 propositions)
%            Number of function symbols  :    1 (   0 constants)
%            Number of variables         :   12 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Substitution axioms 
input_clause(divide_substitution1,axiom,
    [--equal(A,B),
     ++equal(divide(A,C),divide(B,C))]).

input_clause(divide_substitution2,axiom,
    [--equal(D,E),
     ++equal(divide(F,D),divide(F,E))]).

input_clause(less_equal_substitution1,axiom,
    [--equal(G,H),
     --less_equal(G,I),
     ++less_equal(H,I)]).

input_clause(less_equal_substitution2,axiom,
    [--equal(J,K),
     --less_equal(L,J),
     ++less_equal(L,K)]).
%--------------------------------------------------------------------------
