%--------------------------------------------------------------------------
% File     : HEN001=Henkin1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Axioms   : Substitution axioms for Henkin model axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   0 units)
%            Number of literals          :   19 (   9 equality)
%            Number of predicate symbols :    3 (   0 propositions)
%            Number of function symbols  :    1 (   0 constants)
%            Number of variables         :   24 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Equality substitution axioms 
input_clause(quotient_substitution1,axiom,
    [--equal(X,Y),
     --quotient(X,W,Z),
     ++quotient(Y,W,Z)]).

input_clause(quotient_substitution2,axiom,
    [--equal(X,Y),
     --quotient(W,X,Z),
     ++quotient(W,Y,Z)]).

input_clause(quotient_substitution3,axiom,
    [--equal(X,Y),
     --quotient(W,Z,X),
     ++quotient(W,Z,Y)]).

input_clause(less_equal_substitution1,axiom,
    [--equal(X,Y),
     --less_equal(Z,X),
     ++less_equal(Z,Y)]).

input_clause(less_equal_substitution2,axiom,
    [--equal(X,Y),
     --less_equal(X,Z),
     ++less_equal(Y,Z)]).

input_clause(divide_substitution1,axiom,
    [--equal(X,Y),
     ++equal(divide(X,W),divide(Y,W))]).

input_clause(divide_substitution2,axiom,
    [--equal(X,Y),
     ++equal(divide(W,X),divide(W,Y))]).
%--------------------------------------------------------------------------
