%--------------------------------------------------------------------------
% File     : GRP006=NamedGr1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Named groups)
% Axioms   : Substitution axioms for group theory axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   0 units)
%            Number of literals          :   30 (  18 equality)
%            Number of predicate symbols :    3 (   0 propositions)
%            Number of function symbols  :    3 (   0 constants)
%            Number of variables         :   46 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(product_substitution1,axiom,
    [--equal(Xg,Yg),
     --product(Xg,X,Y,Z),
     ++product(Yg,X,Y,Z)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(Xg,X,Z,W),
     ++product(Xg,Y,Z,W)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(Xg,W,X,Z),
     ++product(Xg,W,Y,Z)]).

input_clause(product_substitution4,axiom,
    [--equal(X,Y),
     --product(Xg,W,Z,X),
     ++product(Xg,W,Z,Y)]).

input_clause(multiply_substitution1,axiom,
    [--equal(Xg,Yg),
     ++equal(multiply(Xg,X,Y),multiply(Yg,X,Y))]).

input_clause(multiply_substitution2,axiom,
    [--equal(X,Y),
     ++equal(multiply(Xg,X,Z),multiply(Xg,Y,Z))]).

input_clause(multiply_substitution3,axiom,
    [--equal(X,Y),
     ++equal(multiply(Xg,Z,X),multiply(Xg,Z,Y))]).

input_clause(inverse_substitution1,axiom,
    [--equal(Xg,Yg),
     ++equal(inverse(Xg,X),inverse(Yg,X))]).

input_clause(inverse_substitution2,axiom,
    [--equal(X,Y),
     ++equal(inverse(Xg,X),inverse(Xg,Y))]).

input_clause(group_member_substitution1,axiom,
    [--equal(Xg,Yg),
     --group_member(X,Xg),
     ++group_member(X,Yg)]).

input_clause(group_member_substitution2,axiom,
    [--equal(X,Y),
     --group_member(X,Xg),
     ++group_member(Y,Xg)]).

input_clause(identity_substitution,axiom,
    [--equal(Xg,Yg),
     ++equal(identity_for(Xg),identity_for(Yg))]).
%--------------------------------------------------------------------------
