%--------------------------------------------------------------------------
% File     : GRP002=SemiGr1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group theory (Monoids and Semigroups)
% Axioms   : Substitution axioms for semigroup axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    5 (   0 non-Horn)(   0 units)
%            Number of literals          :   13 (   7 equality)
%            Number of predicate symbols :    2 (   0 propositions)
%            Number of function symbols  :    1 (   0 constants)
%            Number of variables         :   18 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : I cut down the [McCharen, et al., 1976] group axioms for 
%            this.
%--------------------------------------------------------------------------
input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

input_clause(multiply_substitution2,axiom,
    [--equal(X,Y),
     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(product_substitution1,axiom,
    [--equal(X,Y),
     --product(X,W,Z),
     ++product(Y,W,Z)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(W,X,Z),
     ++product(W,Y,Z)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(W,Z,X),
     ++product(W,Z,Y)]).
%--------------------------------------------------------------------------
