%--------------------------------------------------------------------------
% File     : GEO003=Hilbert1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry (Hilbert)
% Axioms   : Substitution axioms for geometry axioms
% Version  : [Benanav, 1992] axioms.
% English  : 

% Refs     : Benanav D. (1992), Recognising Unnecessary Clauses 
%            in Resolution Based Systems, In Journal of Automated 
%            Reasoning 9(1), 43-76.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   24 (   0 non-Horn)(   0 units)
%            Number of literals          :   56 (  40 equality)
%            Number of predicate symbols :    6 (   0 propositions)
%            Number of function symbols  :    9 (   0 constants)
%            Number of variables         :   76 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(common_point_on_planes_substitution1,axiom,
    [--equal(D,E),
     ++equal(common_point_on_planes(D,F,G),
common_point_on_planes(E,F,G))]).

input_clause(common_point_on_planes_substitution2,axiom,
    [--equal(H,I),
     ++equal(common_point_on_planes(J,H,K),
common_point_on_planes(J,I,K))]).

input_clause(common_point_on_planes_substitution3,axiom,
    [--equal(L,M),
     ++equal(common_point_on_planes(N,O,L),
common_point_on_planes(N,O,M))]).

input_clause(line_from_to_substitution1,axiom,
    [--equal(P,Q),
     ++equal(line_from_to(P,R),line_from_to(Q,R))]).

input_clause(line_from_to_substitution2,axiom,
    [--equal(S,T),
     ++equal(line_from_to(U,S),line_from_to(U,T))]).

input_clause(line_through_3_points_substitution1,axiom,
    [--equal(V,W),
     ++equal(line_through_3_points(V,X,Y),
line_through_3_points(W,X,Y))]).

input_clause(line_through_3_points_substitution2,axiom,
    [--equal(Z,A1),
     ++equal(line_through_3_points(B1,Z,C1),
line_through_3_points(B1,A1,C1))]).

input_clause(line_through_3_points_substitution3,axiom,
    [--equal(D1,E1),
     ++equal(line_through_3_points(F1,G1,D1),
line_through_3_points(F1,G1,E1))]).

input_clause(plane_for_points_substitution1,axiom,
    [--equal(H1,I1),
     ++equal(plane_for_points(H1,J1,K1),
plane_for_points(I1,J1,K1))]).

input_clause(plane_for_points_substitution2,axiom,
    [--equal(L1,M1),
     ++equal(plane_for_points(N1,L1,O1),
plane_for_points(N1,M1,O1))]).

input_clause(plane_for_points_substitution3,axiom,
    [--equal(P1,Q1),
     ++equal(plane_for_points(R1,S1,P1),
plane_for_points(R1,S1,Q1))]).

input_clause(point_1_on_line_substitution1,axiom,
    [--equal(T1,U1),
     ++equal(point_1_on_line(T1),point_1_on_line(U1))]).

input_clause(point_2_on_line_substitution1,axiom,
    [--equal(V1,W1),
     ++equal(point_2_on_line(V1),point_2_on_line(W1))]).

input_clause(point_not_on_line_substitution1,axiom,
    [--equal(X1,Y1),
     ++equal(point_not_on_line(X1),point_not_on_line(Y1))]).

input_clause(point_not_on_plane_substitution1,axiom,
    [--equal(Z1,A2),
     ++equal(point_not_on_plane(Z1),point_not_on_plane(A2))]).

input_clause(point_on_plane_substitution1,axiom,
    [--equal(B2,C2),
     ++equal(point_on_plane(B2),point_on_plane(C2))]).

input_clause(collinear_substitution1,axiom,
    [--equal(D2,E2),
     --collinear(D2,F2,G2),
     ++collinear(E2,F2,G2)]).

input_clause(collinear_substitution2,axiom,
    [--equal(H2,I2),
     --collinear(J2,H2,K2),
     ++collinear(J2,I2,K2)]).

input_clause(collinear_substitution3,axiom,
    [--equal(L2,M2),
     --collinear(N2,O2,L2),
     ++collinear(N2,O2,M2)]).

input_clause(line_substitution1,axiom,
    [--equal(P2,Q2),
     --line(P2),
     ++line(Q2)]).

input_clause(on_substitution1,axiom,
    [--equal(R2,S2),
     --on(R2,T2),
     ++on(S2,T2)]).

input_clause(on_substitution2,axiom,
    [--equal(U2,V2),
     --on(W2,U2),
     ++on(W2,V2)]).

input_clause(plane_substitution1,axiom,
    [--equal(X2,Y2),
     --plane(X2),
     ++plane(Y2)]).

input_clause(point_substitution1,axiom,
    [--equal(Z2,A3),
     --point(Z2),
     ++point(A3)]).
%--------------------------------------------------------------------------
