%--------------------------------------------------------------------------
% File     : GEO002=Tarski2.3Subs-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry (Tarskian)
% Axioms   : Substitution axioms for insertion axiom
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Tarski A. (1959), What is Elementary Geometry?, 
%            In Henkin L. (Ed), Proceedings of an International Symposium: 
%            The axiomatic method with special reference to geometry and 
%            physics, (University of California, Berkeley, 1957),a 
%            (Studies in logic and the foundations of mathematics, Volume 
%            ??), North-Holland, The Netherlands.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   0 units)
%            Number of literals          :    8 (   8 equality)
%            Number of predicate symbols :    1 (   0 propositions)
%            Number of function symbols  :    1 (   0 constants)
%            Number of variables         :   20 (   0 singletons)
%            Maximal clause size         :    2
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(insertion_substitution1,axiom,
    [--equal(X,Y),
     ++equal(insertion(X,Z,A1,B1),insertion(Y,Z,A1,B1))]).

input_clause(insertion_substitution2,axiom,
    [--equal(C1,D1),
     ++equal(insertion(E1,C1,F1,G1),insertion(E1,D1,F1,G1))]).

input_clause(insertion_substitution3,axiom,
    [--equal(H1,I1),
     ++equal(insertion(J1,K1,H1,L1),insertion(J1,K1,I1,L1))]).

input_clause(insertion_substitution4,axiom,
    [--equal(M1,N1),
     ++equal(insertion(O1,P1,Q1,M1),insertion(O1,P1,Q1,N1))]).
%--------------------------------------------------------------------------
