%--------------------------------------------------------------------------
% File     : GEO002=Tarski2Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry (Tarskian)
% Axioms   : Substitution axioms for geometry axioms
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Tarski A. (1959), What is Elementary Geometry?, 
%            In Henkin L. (Ed), Proceedings of an International Symposium: 
%            The axiomatic method with special reference to geometry and 
%            physics, (University of California, Berkeley, 1957),a 
%            (Studies in logic and the foundations of mathematics, Volume 
%            ??), North-Holland, The Netherlands.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   32 (   0 non-Horn)(   0 units)
%            Number of literals          :   71 (  57 equality)
%            Number of predicate symbols :    3 (   0 propositions)
%            Number of function symbols  :    5 (   0 constants)
%            Number of variables         :  184 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : See [Quaife, 1989, p. 100], for details of the differences 
%            from the [McCharen, et al., 1976] axioms.
%--------------------------------------------------------------------------
% inner_pasch   : Skolem function arising from Inner Pasch Axiom (A7)
% euclid1 : Skolem function arising from Euclid's Axiom (A8)
% euclid2 : Skolem function arising from Euclid's Axiom (A8)
% extend  : Skolem function arising from the Segment Construction Axiom (A10)
% continuous : Skolem function arising from the Weakened form of the Elementary
%       Continuity Axiom (A13')
%--------------------------------------------------------------------------
%----Equality substitution axioms 
input_clause(between_substitution1,axiom,
    [--equal(X,Y),
     --between(X,W,Z),
     ++between(Y,W,Z)]).

input_clause(between_substitution2,axiom,
    [--equal(X,Y),
     --between(W,X,Z),
     ++between(W,Y,Z)]).

input_clause(between_substitution3,axiom,
    [--equal(X,Y),
     --between(W,Z,X),
     ++between(W,Z,Y)]).

input_clause(equidistant_substitution1,axiom,
    [--equal(X,Y),
     --equidistant(X,V,W,Z),
     ++equidistant(Y,V,W,Z)]).

input_clause(equidistant_substitution2,axiom,
    [--equal(X,Y),
     --equidistant(V,X,W,Z),
     ++equidistant(V,Y,W,Z)]).

input_clause(equidistant_substitution3,axiom,
    [--equal(X,Y),
     --equidistant(V,W,X,Z),
     ++equidistant(V,W,Y,Z)]).

input_clause(equidistant_substitution4,axiom,
    [--equal(X,Y),
     --equidistant(V,W,Z,X),
     ++equidistant(V,W,Z,Y)]).

input_clause(inner_pasch_substitution1,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(X,V1,V2,V3,V4),inner_pasch(Y,V1,V2,V3,V4))]).

input_clause(inner_pasch_substitution2,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,X,V2,V3,V4),inner_pasch(V1,Y,V2,V3,V4))]).

input_clause(inner_pasch_substitution3,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,X,V3,V4),inner_pasch(V1,V2,Y,V3,V4))]).

input_clause(inner_pasch_substitution4,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,V3,X,V4),inner_pasch(V1,V2,V3,Y,V4))]).

input_clause(inner_pasch_substitution5,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,V3,V4,X),inner_pasch(V1,V2,V3,V4,Y))]).

input_clause(euclid1_substitution1,axiom,
    [--equal(A,B),
     ++equal(euclid1(A,C,D,E,F),euclid1(B,C,D,E,F))]).

input_clause(euclid1_substitution2,axiom,
    [--equal(G,H),
     ++equal(euclid1(I,G,J,K,L),euclid1(I,H,J,K,L))]).

input_clause(euclid1_substitution3,axiom,
    [--equal(M,N),
     ++equal(euclid1(O,P,M,Q,R),euclid1(O,P,N,Q,R))]).

input_clause(euclid1_substitution4,axiom,
    [--equal(S,T),
     ++equal(euclid1(U,V,W,S,X),euclid1(U,V,W,T,X))]).

input_clause(euclid1_substitution5,axiom,
    [--equal(Y,Z),
     ++equal(euclid1(A1,B1,C1,D1,Y),euclid1(A1,B1,C1,D1,Z))]).

input_clause(euclid2_substitution1,axiom,
    [--equal(E1,F1),
     ++equal(euclid2(E1,G1,H1,I1,J1),euclid2(F1,G1,H1,I1,J1))]).

input_clause(euclid2_substitution2,axiom,
    [--equal(K1,L1),
     ++equal(euclid2(M1,K1,N1,O1,P1),euclid2(M1,L1,N1,O1,P1))]).

input_clause(euclid2_substitution3,axiom,
    [--equal(Q1,R1),
     ++equal(euclid2(S1,T1,Q1,U1,V1),euclid2(S1,T1,R1,U1,V1))]).

input_clause(euclid2_substitution4,axiom,
    [--equal(W1,X1),
     ++equal(euclid2(Y1,Z1,A2,W1,B2),euclid2(Y1,Z1,A2,X1,B2))]).

input_clause(euclid2_substitution5,axiom,
    [--equal(C2,D2),
     ++equal(euclid2(E2,F2,G2,H2,C2),euclid2(E2,F2,G2,H2,D2))]).

input_clause(extend_substitution1,axiom,
    [--equal(X,Y),
     ++equal(extension(X,V1,V2,V3),extension(Y,V1,V2,V3))]).

input_clause(extend_substitution2,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,X,V2,V3),extension(V1,Y,V2,V3))]).

input_clause(extend_substitution3,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,V2,X,V3),extension(V1,V2,Y,V3))]).

input_clause(extend_substitution4,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,V2,V3,X),extension(V1,V2,V3,Y))]).

input_clause(continuity_substitution1,axiom,
    [--equal(X,Y),
     ++equal(continuous(X,V1,V2,V3,V4,V5),
continuous(Y,V1,V2,V3,V4,V5))]).

input_clause(continuity_substitution2,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,X,V2,V3,V4,V5),
continuous(V1,Y,V2,V3,V4,V5))]).

input_clause(continuity_substitution3,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,X,V3,V4,V5),
continuous(V1,V2,Y,V3,V4,V5))]).

input_clause(continuity_substitution4,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,X,V4,V5),
continuous(V1,V2,V3,Y,V4,V5))]).

input_clause(continuity_substitution5,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,V4,X,V5),
continuous(V1,V2,V3,V4,Y,V5))]).

input_clause(continuity_substitution6,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,V4,V5,X),
continuous(V1,V2,V3,V4,V5,Y))]).
%--------------------------------------------------------------------------
