%--------------------------------------------------------------------------
% File     : GEO001=Tarski1.1Subs-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry (Tarskian)
% Axioms   : Substitution axioms for colinearity axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : Tarski A. (1959), What is Elementary Geometry?, 
%            In Henkin L. (Ed), Proceedings of an International Symposium: 
%            The axiomatic method with special reference to geometry and 
%            physics, (University of California, Berkeley, 1957),a 
%            (Studies in logic and the foundations of mathematics, Volume 
%            ??), North-Holland, The Netherlands.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   0 units)
%            Number of literals          :    9 (   3 equality)
%            Number of predicate symbols :    2 (   0 propositions)
%            Number of function symbols  :    0 (   0 constants)
%            Number of variables         :   12 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(colinear_substitution1,axiom,
    [--equal(A,B),
     --colinear(A,C,D),
     ++colinear(B,C,D)]).

input_clause(colinear_substitution2,axiom,
    [--equal(E,F),
     --colinear(G,E,H),
     ++colinear(G,F,H)]).

input_clause(colinear_substitution3,axiom,
    [--equal(I,J),
     --colinear(K,L,I),
     ++colinear(K,L,J)]).
%--------------------------------------------------------------------------
