%--------------------------------------------------------------------------
% File     : CAT003=Catgry2Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Axioms   : Substitution axioms for category theory axioms
% Version  : [Scott, 1979] axioms.
% English  : 

% Refs     : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings, Applications 
%            of Sheaves, (Lecture Notes in Mathematics, Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   0 units)
%            Number of literals          :   21 (  15 equality)
%            Number of predicate symbols :    3 (   0 propositions)
%            Number of function symbols  :    4 (   0 constants)
%            Number of variables         :   24 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : Axioms simplified by Art Quaife.
%--------------------------------------------------------------------------
%-----Equality substitution axioms (Quaife uses paramodulation) 
input_clause(there_exists_substitution,axiom,
    [--equal(X,Y),
     --there_exists(X),
     ++there_exists(Y)]).

input_clause(equivalent_substitution1,axiom,
    [--equal(X,Y),
     --equivalent(X,Z),
     ++equivalent(Y,Z)]).

input_clause(equivalent_substitution2,axiom,
    [--equal(X,Y),
     --equivalent(Z,X),
     ++equivalent(Z,Y)]).

input_clause(domain_substitution,axiom,
    [--equal(X,Y),
     ++equal(domain(X),domain(Y))]).

input_clause(codomain_substitution,axiom,
    [--equal(X,Y),
     ++equal(codomain(X),codomain(Y))]).

input_clause(compose_substitution1,axiom,
    [--equal(X,Y),
     ++equal(compose(X,Z),compose(Y,Z))]).

input_clause(compose_substitution2,axiom,
    [--equal(X,Y),
     ++equal(compose(Z,X),compose(Z,Y))]).

input_clause(f1_substitution1,axiom,
    [--equal(A,B),
     ++equal(f1(A,C),f1(B,C))]).

input_clause(f1_substitution2,axiom,
    [--equal(D,E),
     ++equal(f1(F,D),f1(F,E))]).
%--------------------------------------------------------------------------
