%--------------------------------------------------------------------------
% File     : CAT001=Catgry1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category theory
% Axioms   : Substitution axioms for category theory axioms
% Version  : [Mitchell, 1967] axioms.
% English  : 

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   0 units)
%            Number of literals          :   26 (  14 equality)
%            Number of predicate symbols :    4 (   0 propositions)
%            Number of function symbols  :    3 (   0 constants)
%            Number of variables         :   30 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%-----Equality substitution axioms 
input_clause(product_substitution1,axiom,
    [--equal(X,Y),
     --product(X,Z,W),
     ++product(Y,Z,W)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(Z,X,W),
     ++product(Z,Y,W)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(Z,W,X),
     ++product(Z,W,Y)]).

input_clause(domain_substitution,axiom,
    [--equal(X,Y),
     ++equal(domain(X),domain(Y))]).

input_clause(codomain_substitution,axiom,
    [--equal(X,Y),
     ++equal(codomain(X),codomain(Y))]).

input_clause(identity_map_substitution,axiom,
    [--equal(X,Y),
     --identity_map(X),
     ++identity_map(Y)]).

input_clause(defined_substitution1,axiom,
    [--equal(X,Y),
     --defined(X,Z),
     ++defined(Y,Z)]).

input_clause(defined_substitution2,axiom,
    [--equal(X,Y),
     --defined(Z,X),
     ++defined(Z,Y)]).

input_clause(star_substitution1,axiom,
    [--equal(X,Y),
     ++equal(compose(Z,X),compose(Z,Y))]).

input_clause(star_substitution2,axiom,
    [--equal(X,Y),
     ++equal(compose(X,Z),compose(Y,Z))]).
%--------------------------------------------------------------------------
