%--------------------------------------------------------------------------
% File     : ANA002=Limits2Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis (Limits)
% Axioms   : Substitution axioms for analysis (limits) axioms
% Version  : [Bledsoe, 1990] axioms :
%            Incomplete > Augmented > Complete.
% English  : 

% Refs     : Bledsoe W.W (1990), Challenge Problems in Elementary 
%            Calculus, Journal of Automated Reasoning 6(3), 341-359.
% Source   : [Bledsoe, 1990]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   14 (   0 non-Horn)(   0 units)
%            Number of literals          :   30 (  26 equality)
%            Number of predicate symbols :    2 (   0 propositions)
%            Number of function symbols  :   10 (   0 constants)
%            Number of variables         :   34 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Clause 19 = reflexivity.
%----Clause 20 = symmetry.
%----Clause 21 = transitivity 

%----Clause 22 
input_clause(less_or_equal_substitution1,axiom,
    [--equal(X,Z),
     --less_or_equal(X,Y),
     ++less_or_equal(Z,Y)]).

%----Clause 23 
input_clause(less_or_equal_substitution2,axiom,
    [--equal(Y,Z),
     --less_or_equal(X,Y),
     ++less_or_equal(X,Z)]).

%----Clause 24 
input_clause(absolute_substitution,axiom,
    [--equal(X,Z),
     ++equal(absolute(X),absolute(Z))]).

%----Clause 25 
input_clause(add_substitution1,axiom,
    [--equal(X,Z),
     ++equal(add(X,Y),add(Z,Y))]).

%----Clause 26 
input_clause(add_substitution2,axiom,
    [--equal(Y,Z),
     ++equal(add(X,Y),add(X,Z))]).

%----Clause 27 
input_clause(minimum_substitution1,axiom,
    [--equal(X,Z),
     ++equal(minimum(X,Y),minimum(Z,Y))]).

%----Clause 28 
input_clause(minimum_substitution2,axiom,
    [--equal(Y,Z),
     ++equal(minimum(X,Y),minimum(X,Z))]).

%----Clause 29 
input_clause(half_substitution,axiom,
    [--equal(X,Z),
     ++equal(half(X),half(Z))]).

%----The following are missing from Bledsoe's axioms 
input_clause(delta_1_substitution1,axiom,
    [--equal(A,B),
     ++equal(delta_1(A),delta_1(B))]).

input_clause(delta_2_substitution1,axiom,
    [--equal(C,D),
     ++equal(delta_2(C),delta_2(D))]).

input_clause(f_substitution1,axiom,
    [--equal(E,F),
     ++equal(f(E),f(F))]).

input_clause(g_substitution1,axiom,
    [--equal(G,H),
     ++equal(g(G),g(H))]).

input_clause(negate_substitution1,axiom,
    [--equal(I,J),
     ++equal(negate(I),negate(J))]).

input_clause(xs_substitution1,axiom,
    [--equal(K,L),
     ++equal(xs(K),xs(L))]).
%--------------------------------------------------------------------------
