%--------------------------------------------------------------------------
% File     : ANA001=Limits1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis (Limits)
% Axioms   : Substitution axioms for analysis (limits) axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   0 units)
%            Number of literals          :   18 (  14 equality)
%            Number of predicate symbols :    2 (   0 propositions)
%            Number of function symbols  :    4 (   0 constants)
%            Number of variables         :   22 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : No natural language descriptions are available.
%          : "Contributed by W.W. Bledsoe in a private correspondence", 
%            [McCharen, et al., 1976].
%--------------------------------------------------------------------------
input_clause(less_than_substitution1,axiom,
    [--equal(X,Y),
     --less_than(X,Z),
     ++less_than(Y,Z)]).

input_clause(less_than_substitution2,axiom,
    [--equal(X,Y),
     --less_than(Z,X),
     ++less_than(Z,Y)]).

input_clause(add_substitution1,axiom,
    [--equal(X,Y),
     ++equal(add(X,Z),add(Y,Z))]).

input_clause(add_substitution2,axiom,
    [--equal(X,Y),
     ++equal(add(Z,X),add(Z,Y))]).

input_clause(minus_substitution1,axiom,
    [--equal(X,Y),
     ++equal(minus(X),minus(Y))]).

input_clause(half_substitution1,axiom,
    [--equal(X,Y),
     ++equal(half(X),half(Y))]).

input_clause(minimum_substitution1,axiom,
    [--equal(X,Y),
     ++equal(minimum(X,Z),minimum(Y,Z))]).

input_clause(minimum_substitution2,axiom,
    [--equal(X,Y),
     ++equal(minimum(Z,X),minimum(Z,Y))]).
%--------------------------------------------------------------------------
