%--------------------------------------------------------------------------
% File     : ALG001=GodelAlg1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Algebra (Abstract)
% Axioms   : Substitution axioms for abstract algebra axioms
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(   0 units)
%            Number of literals          :   81 (  55 equality)
%            Number of predicate symbols :    6 (   0 propositions)
%            Number of function symbols  :    9 (   0 constants)
%            Number of variables         :  124 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : These should be in the Boyer paper, but they use 
%            paramodulation, and hence omit them.
%          : Based on Godel's set theory axioms, and hence require that 
%            Godel's set theory axioms also be used.
%--------------------------------------------------------------------------
input_clause(f34_substitution1,axiom,
    [--equal(A,B),
     ++equal(f34(A,C),f34(B,C))]).

input_clause(f34_substitution2,axiom,
    [--equal(D,E),
     ++equal(f34(F,D),f34(F,E))]).

input_clause(f35_substitution1,axiom,
    [--equal(G,H),
     ++equal(f35(G,I),f35(H,I))]).

input_clause(f35_substitution2,axiom,
    [--equal(J,K),
     ++equal(f35(L,J),f35(L,K))]).

input_clause(f36_substitution1,axiom,
    [--equal(M,N),
     ++equal(f36(M,O),f36(N,O))]).

input_clause(f36_substitution2,axiom,
    [--equal(P,Q),
     ++equal(f36(R,P),f36(R,Q))]).

input_clause(f37_substitution1,axiom,
    [--equal(S,T),
     ++equal(f37(S,U,V),f37(T,U,V))]).

input_clause(f37_substitution2,axiom,
    [--equal(W,X),
     ++equal(f37(Y,W,Z),f37(Y,X,Z))]).

input_clause(f37_substitution3,axiom,
    [--equal(A1,B1),
     ++equal(f37(C1,D1,A1),f37(C1,D1,B1))]).

input_clause(f38_substitution1,axiom,
    [--equal(E1,F1),
     ++equal(f38(E1,G1,H1,I1),f38(F1,G1,H1,I1))]).

input_clause(f38_substitution2,axiom,
    [--equal(J1,K1),
     ++equal(f38(L1,J1,M1,N1),f38(L1,K1,M1,N1))]).

input_clause(f38_substitution3,axiom,
    [--equal(O1,P1),
     ++equal(f38(Q1,R1,O1,S1),f38(Q1,R1,P1,S1))]).

input_clause(f38_substitution4,axiom,
    [--equal(T1,U1),
     ++equal(f38(V1,W1,X1,T1),f38(V1,W1,X1,U1))]).

input_clause(f39_substitution1,axiom,
    [--equal(Y1,Z1),
     ++equal(f39(Y1,A2),f39(Z1,A2))]).

input_clause(f39_substitution2,axiom,
    [--equal(B2,C2),
     ++equal(f39(D2,B2),f39(D2,C2))]).

input_clause(f40_substitution1,axiom,
    [--equal(E2,F2),
     ++equal(f40(E2,G2),f40(F2,G2))]).

input_clause(f40_substitution2,axiom,
    [--equal(H2,I2),
     ++equal(f40(J2,H2),f40(J2,I2))]).

input_clause(f41_substitution1,axiom,
    [--equal(K2,L2),
     ++equal(f41(K2,M2),f41(L2,M2))]).

input_clause(f41_substitution2,axiom,
    [--equal(N2,O2),
     ++equal(f41(P2,N2),f41(P2,O2))]).

input_clause(f42_substitution1,axiom,
    [--equal(Q2,R2),
     ++equal(f42(Q2,S2),f42(R2,S2))]).

input_clause(f42_substitution2,axiom,
    [--equal(T2,U2),
     ++equal(f42(V2,T2),f42(V2,U2))]).

input_clause(associative_substitution1,axiom,
    [--equal(W2,X2),
     --associative(W2,Y2),
     ++associative(X2,Y2)]).

input_clause(associative_substitution2,axiom,
    [--equal(Z2,A3),
     --associative(B3,Z2),
     ++associative(B3,A3)]).

input_clause(commutes_substitution1,axiom,
    [--equal(C3,D3),
     --commutes(C3,E3),
     ++commutes(D3,E3)]).

input_clause(commutes_substitution2,axiom,
    [--equal(F3,G3),
     --commutes(H3,F3),
     ++commutes(H3,G3)]).

input_clause(group_substitution1,axiom,
    [--equal(I3,J3),
     --group(I3,K3),
     ++group(J3,K3)]).

input_clause(group_substitution2,axiom,
    [--equal(L3,M3),
     --group(N3,L3),
     ++group(N3,M3)]).

input_clause(identity_substitution1,axiom,
    [--equal(O3,P3),
     --identity(O3,Q3,R3),
     ++identity(P3,Q3,R3)]).

input_clause(identity_substitution2,axiom,
    [--equal(S3,T3),
     --identity(U3,S3,V3),
     ++identity(U3,T3,V3)]).

input_clause(identity_substitution3,axiom,
    [--equal(W3,X3),
     --identity(Y3,Z3,W3),
     ++identity(Y3,Z3,X3)]).

input_clause(inverse_substitution1,axiom,
    [--equal(A4,B4),
     --inverse(A4,C4,D4,E4),
     ++inverse(B4,C4,D4,E4)]).

input_clause(inverse_substitution2,axiom,
    [--equal(F4,G4),
     --inverse(H4,F4,I4,J4),
     ++inverse(H4,G4,I4,J4)]).

input_clause(inverse_substitution3,axiom,
    [--equal(K4,L4),
     --inverse(M4,N4,K4,O4),
     ++inverse(M4,N4,L4,O4)]).

input_clause(inverse_substitution4,axiom,
    [--equal(P4,Q4),
     --inverse(R4,S4,T4,P4),
     ++inverse(R4,S4,T4,Q4)]).
%--------------------------------------------------------------------------
