;;;-*- Mode:LISP; Package:USER; Base:10. -*- 


(defpackage sme
  (:use common-lisp))

(defsystem sme
  (:name "Structure Mapping Engine")
  (:short-name "sme")
  (:package "sme")
  (:pathname-default "pooh://pooh//falkenhainer//SME//")

  (:module configuration  "config")		;site specific pathname information
  (:module globals  ("defs" "bits"))		;globals and bit vectors
  (:module bms "bms")
  (:module bms-tre "bms-tre")
  (:module main  ("sme" "match" "match-rules-support"))
  (:module IO "display")
  (:module flavors "windowing")
  (:module add-ons ("batch" "generalize"))

  (:compile-load configuration)
  (:compile-load globals (:fasload configuration))
  (:compile-load bms (:fasload globals))
  (:compile-load bms-tre (:fasload globals bms))
  (:compile-load main    (:fasload globals bms bms-tre))
  (:compile-load IO (:fasload globals bms bms-tre main))
  (:compile-load flavors (:fasload globals IO))
  (:compile-load add-ons (:fasload globals main IO)))


(defun load-sme (&optional (zgraph? t))
  (when zgraph?
    (load "swift:>hogge>zg>defsystem")
    (make-system 'zgraph :noconfirm))
  (make-system 'sme :noconfirm))
