;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: mf; -*-

;;;; Instrument panel for MACFAC

;; Idea is to show memory, MAC output, and FAC output as it operates.
;; When finished, should be able to enter a mode where cursor keys can
;; be used to scroll around and probe for more information.

;; Really should re-organize around CLOS, and flush globals.  Someday...

(defflavor macfac-panel ((probe nil)
			 (memory nil)

			 (mac-matcher nil)
			 (fac-matcher nil)
			 (mac-selector nil)
			 (fac-selector nil)
			 (mem-indicators nil)
			 (mac-indicators nil)
			 (fac-indicators nil)
			  ;; 1D indicator panels
			 (mem-panel nil)
			 (mac-panel nil)
			 (fac-panel nil)
			 ;; Status indicators
			 (status-indicators nil))
  :settable-instance-variables
  :gettable-instance-variables
  :initable-instance-variables)

(defvar *macfac-ipanel-width* 300.)
(defvar *macfac-ipanel-height* 500.)

(defmethod (macfac-panel :reset)
  ;; Initializes the parts
  (send self :set-mem-panel (make-instance '1d-indicator-panel :))
  (send self :set-mac-panel (make-instance '1d-indicator-panel))
  (send self :set-fac-panel (make-instance '1d-indicator-panel))
  (send self :set-mem-indicators nil)
  (send self :set-mac-indicators nil)
  (send self :set-fac-indicators nil)
  (send self :set-mac-matcher mf::*mac-matcher*)
  (send self :set-fac-matcher mf::*fac-matcher*)
  (send self :set-mac-selector mf::*mac-selector*)
  (send self :set-fac-selector mf::*fac-selector*))

(defvar *MPanel-Width* 300) ;; Width of each panel
(defvar *MPanel-Height* 500) ;; Height of each panel (excluding top indicators)
(defvar *Mpanel-status-font* "ROMAN")
(defvar *Mpanel-font* "ROMAN")

;;;; Creating parts and layout

(defmethod (macfac-panel :get-status-indicator) (name)
  (cdr (assoc name (send self :status-indicators))))

(defmethod (macfac-panel :set-status-indicator) (name ind)
  (let ((entry (assoc name (send self :status-indicators))))
    (unless entry (setq entry (cons name nil))
	    (send self :set-status-indicators
		  (cons entry (send self :status-indicators))))
    (setf (cdr entry) ind)))

(defmethod (macfac-panel :compute-layout)
  ;; Each 1D indicator panel has two status indicators above it.
  ;; The MEMORY panel has the probe and the PC above it.
  ;; The MAC and FAC panels show their respective matchers and
  ;; selectors.
  ;; First make the status indicators
  (send self :set-status-indicator :PROBE 
	(make-instance 'indicator :char-width <string width of panel width>
		       :height (font-height *mpanel-status-font*)
		       :font *mpanel-status-font*
		       :label "Probe: Undefined."
		       :name :PROBE
		       :updater #'(lambda () mf::*probe*)))
  (send self :set-status-indicator :PC 
	(make-instance 'indicator :char-width <string width of panel width>
		       :height (font-height *mpanel-status-font*)
		       :font *mpanel-status-font*
		       :label "Undefined."
		       :name :PC
		       :updater #'(lambda ())))
  (send self :set-status-indicator :MAC-MATCHER 
	(make-instance 'indicator :char-width <string width of panel width>
		       :height (font-height *mpanel-status-font*)
		       :font *mpanel-status-font*
		       :label "Matcher: Undefined."
		       :name :MAC-MATCHER
		       :updater #'(lambda () (mf::matcher-name mf::*mac-matcher*))))
  (send self :set-status-indicator :MAC-SELECTOR 
	(make-instance 'indicator :char-width <string width of panel width>
		       :height (font-height *mpanel-status-font*)
		       :font *mpanel-status-font*
		       :label "Selector: Undefined."
		       :name :MAC-SELECTOR
		       :updater #'(lambda () (mf::selector-name mf::*mac-selector*))))  
  (send self :set-status-indicator :FAC-MATCHER 
	(make-instance 'indicator :char-width <string width of panel width>
		       :height (font-height *mpanel-status-font*)
		       :font *mpanel-status-font*
		       :label "Matcher: Undefined."
		       :name :FAC-MATCHER
		       :updater #'(lambda () (mf::matcher-name mf::*fac-matcher*))))
  (send self :set-status-indicator :FAC-SELECTOR 
	(make-instance 'indicator :char-width <string width of panel width>
		       :height (font-height *mpanel-status-font*)
		       :font *mpanel-status-font*
		       :label "Selector: Undefined."
		       :name :FAC-SELECTOR
		       :updater #'(lambda () (mf::selector-name mf::*fac-selector*))))
  ;; YOU ARE HERE  

  ;; Put it at the upper left corner of the screen.










;;;; Building indicators involving dgroups


(defmethod (macfac-panel :init-memory) ()
  (send self :set-mem-indicators
	(mapcar #'(lambda (item)
		    (user::make-instance 'user::indicator
					 :name (sme::dgroup-name item)
					 :updater #'(lambda ()
						      (let ((entry (assoc item mf::*mac-results*)))
							(cond (entry ;; show the score
							       (format nil "~A = ~A"
								       (sme::dgroup-name item)
								       (fourth entry)))
							      (t (sme::dgroup-name item)))))))
		mf::*memory*)))


  