;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10 -*-
#-Symbolics
(in-package sme::*the-user-package*)		;defPackage

;;;; Predicate language definition file


(sme:defPredicate Equal-To (linear linear) relation :expression-type boolean :commutative? t)
(sme:defPredicate At (physob time) function :expression-type physob
    :documentation "(physob time): represents an object during a specified period of time.")
(sme:defPredicate Situation (time) Attribute
	      :documentation "the given token denotes a period of stime called a situation")
(sme:defPredicate Meets (time time) Relation)
(sme:defPredicate Decreasing (linear) Relation)
(sme:defPredicate Increasing (linear) Relation)
(sme:defPredicate Constant (linear) Relation)
(sme:defPredicate Function-Of (linear linear) Relation)


;;; Predicates

(sme:defPredicate cause ((antecedent event) (consequent event)) relation)
(sme:defPredicate revolve-around ((moving entity)(stationary entity)) relation
   :documentation "(moving-object stationary-object): moving is revolving around stationary")
(sme:defPredicate attracts ((attractor entity) (attractee entity)) relation)
(sme:defPredicate greater ((num1 number) (num2 number)) relation)
(sme:defPredicate and ((conjunct boolean) (conjunct boolean)) logical
		  :n-ary? t :commutative? t)
(sme:defPredicate mass (entity) function :expression-type number)
(sme:defPredicate charge (entity) function :expression-type number)
(sme:defPredicate opposite-sign (number number) relation)
(sme:defPredicate temperature (entity) function :expression-type number)
(sme:defPredicate gravity (entity entity) relation)

;;; water-heat analogy
(sme:defPredicate implies ((condition predicate) (implication predicate)) relation)
(sme:defPredicate flow ((source entity)(destination entity)(substance entity)(path entity))
                   relation)
(sme:defPredicate pressure (entity) function :expression-type number)
(sme:defPredicate diameter (entity) function :expression-type number)
(sme:defPredicate cylindrical (entity) attribute)
(sme:defPredicate clear (entity) attribute)
(sme:defPredicate dark (entity) attribute)
(sme:defPredicate glass (entity) attribute)
(sme:defPredicate flat-top (entity) attribute)
(sme:defPredicate liquid (entity) attribute)
(sme:defPredicate shiny (entity) attribute)
(sme:defPredicate c-s (entity entity) function :expression-type physob)
(sme:defPredicate active (entity) attribute)
(sme:defPredicate amount-of ((object physob)) function :expression-type number)
(sme:defPredicate fluid-path ((path physob)) attribute)
(sme:defPredicate aligned (entity) attribute)
(sme:defPredicate sub (number number number) relation)
(sme:defPredicate diff (entity) function :expression-type number)
(sme:defPredicate prop (predicate predicate) relation)
(sme:defPredicate flow-rate ((entity quantity??)) function :expression-type number)
(sme:defPredicate I- (predicate predicate) relation)
(sme:defPredicate I+ (predicate predicate) relation)
(sme:defPredicate process-instance (entity) attribute)
(sme:defPredicate process (entity) attribute)
(sme:defPredicate equal (t t) relation)
(sme:defPredicate heat ((object physob)) function :expression-type number)
(sme:defPredicate heat-path ((path physob)) attribute)

;;; sciq-problems
(sme:defPredicate particulate (entity) attribute)
(sme:defPredicate upright (entity) attribute)
(sme:defPredicate exists (entity) attribute)
(sme:defPredicate flux (entity) attribute)
(sme:defPredicate speed (entity) attribute)
(sme:defPredicate * (entity entity) relation)
(sme:defPredicate opaque (entity) attribute)

;;; Sys-Lit story #21
(sme:defPredicate company (entity) attribute)
(sme:defPredicate crime (entity) attribute)
(sme:defPredicate thanks (entity) attribute)
(sme:defPredicate commit ((doer entity) (action entity)) relation)
(sme:defPredicate believe ((entity) predicate) relation)
(sme:defPredicate pursue (entity entity) relation)
(sme:defPredicate request (entity entity predicate) relation)
(sme:defPredicate find (entity entity) relation)
(sme:defPredicate show (entity entity predicate) relation)
(sme:defPredicate suspect (entity entity predicate) relation)
(sme:defPredicate prevent21 (entity predicate) relation)     ;;*****
(sme:defPredicate request (entity entity predicate) relation)
(sme:defPredicate flee (entity entity) relation)
(sme:defPredicate give (entity entity entity) relation)
(sme:defPredicate arrive (entity entity) relation :n-ary? t)
(sme:defPredicate ask (entity entity predicate) relation)
(sme:defPredicate abandon (entity predicate) relation)
(sme:defPredicate realize (animate sentence) relation)
(sme:defPredicate trust (entity entity) relation)
(sme:defPredicate not (sentence) logical)

;;; Sys-Lit story #5
(sme:defPredicate bird (entity) attribute)
(sme:defPredicate warlike (entity) attribute)
(sme:defPredicate country (entity) attribute)
(sme:defPredicate weapon (entity) attribute)
(sme:defPredicate Karlas-asset (entity) attribute)
(sme:defPredicate Zerdias-asset (entity) attribute)
(sme:defPredicate see (entity entity) relation :n-ary? t) 
(sme:defPredicate success (entity) function :expression-type logical)
(sme:defPredicate happiness (entity) function :expression-type ordinal)
(sme:defPredicate offer (entity entity entity) relation)
(sme:defPredicate obtain (entity entity) relation)
(sme:defPredicate promise ((from entity) (to entity) (thing sentence)) relation)
(sme:defPredicate used-for (entity entity) relation)
(sme:defPredicate equals (function entity) relation)
(sme:defPredicate same-as (entity entity) relation :n-ary? t)

;;;#9
(sme:defPredicate dog (entity) attribute)
(sme:defPredicate object (entity) attribute)
(sme:defPredicate meat (entity) attribute)
(sme:defPredicate bigger (entity entity) attribute)
(sme:defPredicate expensive (entity) attribute)
(sme:defPredicate hard-surface (entity) attribute)
(sme:defPredicate water (entity) attribute)
(sme:defPredicate move-along (entity entity) relation)
(sme:defPredicate hold (entity entity entity) relation)
(sme:defPredicate drop (entity entity entity) relation)
(sme:defPredicate break (entity entity) relation)
(sme:defPredicate lose (entity entity) relation)
(sme:defPredicate make (entity entity) relation)
(sme:defPredicate leave (entity entity) relation)
(sme:defPredicate eat (entity entity) relation)
(sme:defPredicate hunger ((animal animate)) function :expression-type ordinal)
(sme:defPredicate take (entity entity entity) relation :n-ary? t)
(sme:defPredicate try (entity predicate) relation)
 

;;; Carnot's heat-water analogy
(sme:defPredicate amount ((source physob) (object physob))  function :expression-type number)
(sme:defPredicate heat-capacity (physob) function :expression-type number)
(sme:defPredicate conductivity (physob) function :expression-type number)
(sme:defPredicate difference (predicate predicate) relation)
(sme:defPredicate power (entity entity) relation)
(sme:defPredicate max-power (entity entity) relation)
(sme:defPredicate qual-prop (predicate predicate) relation) 
(sme:defPredicate water-level (physob) function :expression-type number)
(sme:defPredicate area (entity) function :expression-type number)

(sme:defPredicate less-than (linear linear) relation)
(sme:defPredicate adult (entity) attribute)
(sme:defPredicate health (animal) function :expression-type ordinal)
(sme:defPredicate operation (physob) function :expression-type ordinal)
(sme:defPredicate job-of (entity relation) relation)
(sme:defPredicate flies (entity) attribute)
(sme:defPredicate attached (entity entity) relation)
(sme:defPredicate altitude (entity) function :expression-type linear)
(sme:defPredicate net-force (entity) function :expression-type linear)
(sme:defPredicate held-by (entity entity) relation)
(sme:defPredicate force (entity entity) function :expression-type linear)
(sme:defPredicate add (linear linear) function :expression-type linear)

;#17
(sme:defPredicate pioneer (entity) attribute)
(sme:defPredicate settler (entity) attribute)
(sme:defPredicate authority (entity) attribute)
(sme:defPredicate sheriff (entity) attribute)
(sme:defPredicate constable (entity) attribute)
(sme:defPredicate land (entity) attribute)
(sme:defPredicate cash (entity) attribute)
(sme:defPredicate person (entity) attribute)
(sme:defPredicate student (entity) attribute)
(sme:defPredicate teacher (entity) attribute)
(sme:defPredicate location (entity) attribute)

(sme:defPredicate discover (entity entity) relation)
(sme:defPredicate fight (entity entity) relation)
(sme:defPredicate between (entity entity) relation)
(sme:defPredicate divide (entity entity relation) relation)
(sme:defPredicate take17 (entity relation) relation :n-ary? t)
(sme:defPredicate build-houses (entity entity) relation)
(sme:defPredicate change ((from relation)(to relation)) relation)
(sme:defPredicate poss ((experiencer object) object) relation)
(sme:defPredicate desire ((experiencer object)(object event)) relation)
(sme:defPredicate greater-than (linear linear) relation)
(sme:defPredicate do (entity state) relation)
(sme:defPredicate friends (entity entity) relation)
(sme:defPredicate mstate (entity state) relation)
(sme:defPredicate confrontation (entity entity) relation)

(sme:defPredicate locate (entity entity) relation)
(sme:defPredicate radiate (entity entity) relation)
(sme:defPredicate attack (entity entity) relation)
(sme:defPredicate capture1 (entity entity) relation)
(sme:defPredicate capture2 (entity) relation)
(sme:defPredicate require (relation entity) relation)
(sme:defPredicate divide2 (entity entity entity entity) relation)
(sme:defPredicate position (entity entity) relation)
(sme:defPredicate simultaneous (relation) relation)
(sme:defPredicate converge (entity entity) relation)
(sme:defPredicate destroy (entity entity) relation)

;;;#18
(sme:defPredicate instructor (entity) attribute)
(sme:defPredicate teacher (entity) attribute)
(sme:defPredicate teachers (entity) attribute)
(sme:defPredicate head-instructor (entity) attribute)
(sme:defPredicate principals (entity) attribute)
(sme:defPredicate provosts (entity) attribute)
(sme:defPredicate professor (entity) attribute)
(sme:defPredicate professors (entity) attribute)
(sme:defPredicate sailor (entity) attribute)
(sme:defPredicate sailors (entity) attribute)
(sme:defPredicate captains (entity) attribute)
(sme:defPredicate free-time (entity) attribute)
(sme:defPredicate administration (entity) attribute)
(sme:defPredicate incendiary (entity) attribute)
(sme:defPredicate money (entity) attribute)
(sme:defPredicate solid (enity) attribute)
(sme:defPredicate Jacksons (entity) attribute)
(sme:defPredicate McGhees (entity) attribute)
(sme:defPredicate salary-increase (entity) attribute)
(sme:defPredicate has (entity predicate) relation)
(sme:defPredicate amount-of (physob) function :expression-type linear)
(sme:defPredicate anger (entity) function :expression-type ordinal)
(sme:defPredicate burn (entity entity entity) relation)
(sme:defPredicate say (entity predicate) relation)
(sme:defPredicate desire2 (entity entity) relation)

;time
(sme:defPredicate exists (object) relation)
(sme:defPredicate happen (event) relation)
(sme:defPredicate follow ((event1 event)(event2 event)) relation)
(sme:defPredicate same-time ((event1 event)(event2 event)) relation)

;functions
(sme:defPredicate estate (animal) function :expression-type ordinal)	;low=sad, high=happy
(sme:defPredicate pstate (physob) function :expression-type ordinal)	;physical state
(sme:defPredicate loc    (physob) function :expression-type ordinal)
(sme:defPredicate desirability (relation) function :expression-type ordinal)
(sme:defPredicate part-of (physob) function :expression-type physob)
; (sme:defPredicate part-of (entity) function :expression-type physob)
(sme:defPredicate center (physob) function  :expression-type physob)

(sme:defPredicate container (object) attribute)
(sme:defPredicate education-level (person) function :expression-type ordinal)
(sme:defPredicate or (relation relation) logical :n-ary? t :commutative? t)
(sme:defPredicate prevent (relation relation) relation)
(sme:defPredicate prevent2 (relation) relation)
(sme:defPredicate enable (relation relation) relation)
(sme:defPredicate reason (relation relation) relation)
(sme:defPredicate result (relation relation) relation)

(sme:defPredicate toy (entity) attribute)
(sme:defPredicate member-class (entity class) relation)
(sme:defPredicate move (entity entity) relation)
(sme:defPredicate manner (relation entity) relation)
(sme:defPredicate belongs-to (entity entity) relation)
(sme:defPredicate Isa (entity entity) taxonomy)
(sme:defPredicate lives (entity entity) relation)
(sme:defPredicate near (entity entity) relation)
(sme:defPredicate size (entity) function)
(sme:defPredicate power (entity) function)
(sme:defPredicate possession-of (entity) function)
(sme:defPredicate funct-of (entity) function)
(sme:defPredicate has-authority (entity) function) 
(sme:defPredicate shape (entity) function)
(sme:defPredicate color (entity) function)
(sme:defPredicate sound (sound-type) relation)
(sme:defPredicate controlled-by (entity entity) relation)
(sme:defPredicate hover (entity) relation)
(sme:defPredicate wings (entity) attribute)
(sme:defPredicate beak (entity) attribute)
(sme:defPredicate feathers (entity) attribute)
(sme:defPredicate claws (entity) attribute)
(sme:defPredicate territorial (entity) attribute)
(sme:defPredicate transportation (entity) attribute)
(sme:defPredicate has-part (entity entity) relation)
(sme:defPredicate top-of (entity) function :expression-type linear)
(sme:defPredicate weight (physob) function :expression-type number)
(sme:defPredicate nutrient (entity) attribute)
(sme:defPredicate grow (entity) relation)
(sme:defPredicate supports (entity entity) relation)
(sme:defPredicate length (physob) function :expression-type number)
(sme:defPredicate width (physob) function :expression-type number)
(sme:defPredicate plastic (entity) attribute)
(sme:defPredicate paper (entity) attribute)
(sme:defPredicate supply (entity entity) relation)
(sme:defPredicate long (entity) attribute)
(sme:defPredicate skinny (entity) attribute)
(sme:defPredicate land-at (entity entity) relation)
(sme:defPredicate old (entity) attribute)
(sme:defPredicate oak (entity) attribute)
(sme:defPredicate tall (entity) attribute)
(sme:defPredicate tasty (entity) attribute)
(sme:defPredicate wooden (entity) attribute)
(sme:defPredicate gorgeous (entity) attribute)
(sme:defPredicate unclaimed (entity) attribute)
(sme:defPredicate western (entity) attribute)
(sme:defPredicate desirable (entity) attribute)
(sme:defPredicate monetary (entity) attribute)
(sme:defPredicate thankful (entity) attribute)

;; Geometric domain (SQLG)
(sme:defPredicate taxonomy (event event) relation :n-ary? t)
(sme:defPredicate above (entity entity) relation)
(sme:defPredicate below (entity entity) relation)
(sme:defPredicate left-of (entity entity) relation)
(sme:defPredicate right-of (entity entity) relation)
(sme:defPredicate outside (entity entity) relation)
(sme:defPredicate inside (entity entity) relation)
(sme:defPredicate center (entity entity entity) relation)
(sme:defPredicate centered-below (entity entity) relation)
(sme:defPredicate centered-above (entity entity) relation)
(sme:defPredicate centered-inside (entity entity) relation)
(sme:defPredicate centered-outside (entity entity) relation)
(sme:defPredicate centered-left-of (entity entity) relation)
(sme:defPredicate centered-right-of (entity entity) relation)
(sme:defPredicate location-of (entity entity) relation)
(sme:defPredicate rec-coord (entity entity entity entity entity) relation)
(sme:defPredicate shape (entity entity) attribute)
(sme:defPredicate color (entity entity)  attribute)
(sme:defPredicate size (entity entity)  attribute)
(sme:defPredicate same (predicate predicate) relation)