;;; -*- Mode: LISP; Syntax: Common-lisp; Package: SME; Base: 10; -*-

;;; Version of SME config file for Mac II's running ACL
;;; Hacked by KDF

(in-package 'sme :use '(lisp))		;defPackage


;;;; Structure-Mapping Engine  (Site configuration declarations)


(defvar *the-user-package* 'user)		;this machine's user package
(defvar *the-lisp-package* 'lisp)	;this machine's lisp package
     ;IMPORTANT - modify in-package at top of this file
     ; :use there must match the lisp one here.


(defvar *sme-dgroup-pathname* "Macintosh HD:SME:")
(defvar *sme-rules-pathname* "Macintosh HD:SME:")
(defvar *sme-language-file* "Macintosh HD:SME:language")
(defvar *sme-default-rules* "Macintosh HD:SME:literal-similarity.rules")

(defvar *sme-system-pathname* "Macintosh HD:SME:")
(defvar *sme-files* '("defs" "bits" "bms" "bms-tre" "sme"
                      "match" "match-rules-support" "display"
                      "generalize" "batch"   ;optional utilities
                      "cmenu" ;; KDF: character-oriented menu system
                      "charsme" ;; KDF: Some useful utilities.
                      ;; Call (sme::toplevel) to operate.
                      ;;; Any volunteers to write a MAC-based windowing system?
                      ;;;     -KDF
		      ;;"windowing"  ;optional flavor-based windowing system
		      ))

(defun load-sme ()
  ;  (load-zgraph)				;this needs to be defined
  (dolist (file *sme-files*)
     (load (format nil "~A~A" *sme-system-pathname* file))))


(defun compile-sme ()
  (dolist (file *sme-files*)
    (compile-file (format nil "~A~A" *sme-system-pathname* file))
    (load (format nil "~A~A" *sme-system-pathname* file))))


;;; Symbol hacking
;;;   We want these symbols accessible in SME package, yet also accessible
;;;   as the same symbol in user package, since things like dgroup and rule
;;;   definitions are written in the user package.
;;;   This is here in the first file since having them in the same file as
;;;   their use seems to be a loss when using shadowing import, no idea why...
;;;
(eval-when (compile load eval)	;want to bring in user's symbols, rather than ship ours out.
  (dolist (sym-name '("ENTITIES" "EXPRESSIONS"	;for defDescription (defs)
		      "MH" "GMAP" "CI"		;for rule triggering (defs)
		      "AND" "OR" "IMPLIES"))	;for rule triggering (bms)
    (format t "~%Shadowing ~A" sym-name)
    (shadowing-import (intern sym-name (find-package *the-user-package*))
		      (find-package 'sme))))
