;;; -*- Mode: LISP; Syntax: Common-lisp; Package: SME; Base: 10; -*-


(in-package 'sme :use '(lisp))		;defPackage


;;;; Structure-Mapping Engine  (Site configuration declarations)




(defvar *the-user-package* 'user)		;this machine's user package
(defvar *the-lisp-package* 'lisp)	;this machine's lisp package
     ;IMPORTANT - modify in-package at top of this file
     ; :use there must match the lisp one here.


(setq *sme-dgroup-pathname* "/usr/qrg/sme2e.2/")
(setq *sme-rules-pathname* "/usr/qrg/sme2e.2/")
(setq *sme-language-file* "/usr/qrg/sme2e.2/language")
(setq *sme-default-rules* "/usr/qrg/sme2e.2/literal-similarity.rules")
(setq *sme-system-pathname* "/usr/qrg/sme2e.2/")

#||
(defvar *sme-dgroup-pathname* "/u/siegle/sme2e.2/")
(defvar *sme-rules-pathname* "/u/siegle/sme2e.2/")
(defvar *sme-language-file* "/u/siegle/sme2e.2/language")
(defvar *sme-default-rules* "/u/siegle/sme2e.2/literal-similarity.rules")
(defvar *sme-system-pathname* "/u/siegle/sme2e.2/")
||#

#||
(defvar *sme-files* '("defs" "bits" "bms" "bms-tre" "sme"
                      "match" "match-rules-su" "display"
                      "generalize" "batch"   ;optional utilities
;; DO NOT LOAD THIS BY DEFAULT!  It assumes the menus utilties
;;    and ZGRAPH! -- KDF 
;;		      "windowing"            ;optional windowing system
		      ))
||#

(defvar *sme-files* '("defs" "bits" "bms" "bms-tre" "sme"
                      "match" "match-rules-support" "display"
                      "generalize" "batch"   ;optional utilities
;;                      "cmenu" ;; KDF: character-oriented menu system
;;                      "charsme" ;; KDF: Some useful utilities.
                      ;; Call (sme::toplevel) to operate.
                      ;;; Any volunteers to write a MAC-based windowing system?
;; DO NOT LOAD THIS BY DEFAULT!  It assumes the menus utilties
;;    and ZGRAPH! -- KDF 
;;;		      "windowing"  ;optional windowing system
		      ))



(defun load-sme (&optional (sources? nil))
  (dolist (file *sme-files*)
          (load (format nil "~A~A.~A"
			*sme-system-pathname* file
			(if sources? "lisp" "rbin"))))
  ;; WARNING!  DO NOT AUTOMATICALLY LOAD GRAPHICS!
    )


(defun compile-sme ()
  (dolist (file *sme-files*)
    (compile-file (format nil "~A~A" *sme-system-pathname* file))
    (load (format nil "~A~A" *sme-system-pathname* file))))

;;; CLIM-based SME graphical interface

(defun load-sme-graphics (&optional (sources? nil))
  (load "/usr/lpp/clim/tools/menus.lisp")
  (load "/usr/qrg/zgraph/defsys")
  ;; The eval Avoids mentioning zg package if it isn't there
  (eval (list (intern "LOAD-ZGRAPH" 'ZG) sources?))
  (load "/usr/qrg/sme2e.2/windowing.lisp"))


;;; Symbol hacking
;;;   We want these symbols accessible in SME package, yet also accessible
;;;   as the same symbol in user package, since things like dgroup and rule
;;;   definitions are written in the user package.
;;;   This is here in the first file since having them in the same file as
;;;   their use seems to be a loss when using shadowing import, no idea why...
;;;
(eval-when (compile load eval)	;want to bring in user's symbols, rather than ship ours out.
  (dolist (sym-name '("ENTITIES" "EXPRESSIONS"	;for defDescription (defs)
		      "MH" "GMAP" "CI"		;for rule triggering (defs)
		      "AND" "OR" "IMPLIES"))	;for rule triggering (bms)
    (format t "~%Shadowing ~A" sym-name)
    (shadowing-import (intern sym-name (find-package *the-user-package*))
		      (find-package 'sme))))




