/************************************************************************/
/*                                                                      */
/*  Queue ADT: Basic data structure specified in queue.h.  Access fns   */
/*             include queue_init, queue_add, queue_delete, and         */
/*             queue_is_empty.  Queue element types of (void *) are     */
/*             used so that any data type can be added to a queue.      */
/*                                                                      */
/************************************************************************/

#include "soar.h"
#include "queue.h"


/*----------------------------------------------------------------------*/
/*                                                                      */
/*  queue_init: Initialize a queue.  This is required before a queue    */
/*              can be used.                                            */
/*                                                                      */
/*----------------------------------------------------------------------*/

void
queue_init (queue * q)
{
  q->front = NIL;
  q->rear  = NIL;
}


/*----------------------------------------------------------------------*/
/*                                                                      */
/*  queue_add: Add an item to a queue.  Before adding an item to the    */
/*             queue, a pointer must be to the elt must be cast to void.*/
/*             That enables any data type to be stored in the queue.    */
/*                                                                      */
/*             !! A check should be added to see if any memory is left  */
/*                to allocate the next queue position.                  */
/*----------------------------------------------------------------------*/

void
queue_add (queue * q, void * item)
{
  cons * new_cons;
  cons * prev_rear;

  allocate_cons(&new_cons);
  new_cons->first = item;

  prev_rear = q->rear;
  q->rear = new_cons;

  if (prev_rear == NIL) {
    q->front = new_cons;
  } else {
    prev_rear->rest = new_cons;
  }
}


/*----------------------------------------------------------------------*/
/*                                                                      */
/*  queue_delete: Delete an item from a queue.  The item deleted from   */
/*                The queue is returned via the pointer reference given */
/*                in the item parameter.  TRUE is returned if an item   */
/*                was deleted and FALSE is returned if no items were    */
/*                present in the queue.                                 */
/*                                                                      */
/*----------------------------------------------------------------------*/

bool
queue_delete (queue * q, void * * item)
{
  void * item_deleted;
  cons * cons_to_delete;

  if (q->front == NIL) {
    print("\nError -- attempt to remove element from an empty queue.\n");
    return FALSE;
  }

  cons_to_delete = q->front;
  item_deleted   = q->front->first;
  q->front       = q->front->rest;
  free_cons(cons_to_delete);

  if (q->front == NIL) {
    q->rear = NIL;
  }

  *item = item_deleted;

  return TRUE;
}


/*----------------------------------------------------------------------*/
/*                                                                      */
/*  queue_is_empty:  Returns TRUE is queue is empty, FALSE otherwise.   */
/*                                                                      */
/*----------------------------------------------------------------------*/

bool
queue_is_empty (queue * q) 
{
  return q->front == NIL;
}
