;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /u/hucka/Projects/Soar/Interface/Src/RCS/sde-maint.el,v $
;;;; $Id: sde-maint.el,v 0.5 1994/06/08 17:36:47 hucka Exp $
;;;; 
;;;; Description       : SDE maintenance routines.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1993 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-maint-el-version "$Revision"
  "The revision number of sde-maint.el.  The complete RCS id is:
      $Id: sde-maint.el,v 0.5 1994/06/08 17:36:47 hucka Exp $")


;;;----------------------------------------------------------------------------
;;; Support for compiling under different versions of Emacs.
;;;----------------------------------------------------------------------------

(defconst sde-maint-running-lemacs
    (and (string-match "Lucid" emacs-version) t))

(defconst sde-maint-running-emacs19
    (and (string-match "\\`19" emacs-version) (not sde-maint-running-lemacs)))

;; Files in each list below need to be listed in the desired order of
;; compilation.

(defvar sde-maint-first-srcs
  '((sde-maint-running-emacs19 "sde-emacs19.el")
    (sde-maint-running-lemacs  "sde-lemacs.el")))

(defvar sde-maint-extra-srcs
  '((sde-maint-running-emacs19
     "header.el" "tagify.el" "powerkey.el")
    (sde-maint-running-lemacs
     "header.el" "tagify.el")))

(defvar sde-maint-core-srcs
  '("sde-version.el" "sde.el" "sde-compat.el" "sde-feedback.el"
    "sde-find.el" "sde-header.el" "sde-highlight.el" "sde-repos.el"
    "sde-search.el" "sde-soar-mode.el" "conversion.el"))

;; Functions.

(defun sde-maint-compile-conditionally (cond-list)
  (while (not (eval (car (car cond-list))))
    (setq cond-list (cdr cond-list)))
  (if cond-list
      (mapcar 'sde-maint-compile-file (cdr (car cond-list)))))

(defun sde-maint-compile-file (file)
  (message "Compiling %s..." file)
  (byte-compile-file file))

(defun sde-maint-compile-distribution ()
  "Compile the files that come with SDE.
Usage: emacs -batch -q -l sde-maint -f sde-maint-compile-distribution"
  (interactive)
  (let* ((inhibit-local-variables nil)
	 (enable-local-variables nil)
	 (enable-local-eval nil)
	 (byte-compile-verbose t))
    (if (not (or sde-maint-running-emacs19 sde-maint-running-lemacs))
	(error "SDE will only function in GNU Emacs 19 or Lucid Emacs 19."))
    ;; Make sure we're in the right directory.
    (find-file "sde.el")
    (if (= (buffer-size) 0)
	(error "This command must be executed in the SDE source directory."))
    ;; Make sure current directory is in load-path.
    (setq load-path (cons default-directory load-path))
    ;; Compile files appropriately.
    ;; First the initial, version-specific set.
    (sde-maint-compile-conditionally sde-maint-first-srcs)
    ;; Next, the extras.  There's nothing to be done about warnings for the
    ;; extra packages included, since I'm not going to maintain them, so
    ;; quiet the compiler first.
    (setq byte-compile-warnings nil)
    (sde-maint-compile-conditionally sde-maint-extra-srcs)    
    ;; Finally, the main code.
    (setq byte-compile-warnings t)      
    (mapcar 'sde-maint-compile-file sde-maint-core-srcs)))
