/************************************************************************/
/*                                                                      */
/*  Queue ADT: Access functions specified in queue.c.  Basic data       */
/*             structure is a linked list of cons cells.  Pointers to   */
/*             the head and tail of the linked list indicate the front  */
/*             and rear of the queue, respectively.  Items are added to */
/*             the rear (only) and removed from the front (only) so we  */
/*             have a strict FIFO queueing discipline.                  */
/*                                                                      */
/************************************************************************/

#ifndef _QUEUE_H_INCLUDED
#define _QUEUE_H_INCLUDED

#include "soar.h"

typedef struct queue_struct {
  cons * front;
  cons * rear;
} queue;

extern void queue_create (queue * * q);
extern void queue_add (queue * q, void * item);
extern bool queue_delete (queue * q, void * * item);
extern bool queue_is_empty (queue * q);

#endif /* _QUEUE_H_INCLUDED */

