/* =====================================================================
			 SimTime Include File

   This file declares the variables and functions that are part of the
   simulated real time mechanism built to replace Mark Weismeyer's EDT.
===================================================================== */

typedef struct opdur {
  char *name;
  int duration;
  struct opdur *next;
} OpDur, *POpDur;

typedef struct st_event {
  int time;
  char *type;
  char *args;
  struct st_event *next;
} STEvent, *PSTEvent;

typedef struct st_funcall {
  char *type;
  void (*fun)(char *);
} STFuncList;

typedef struct st_wme {
  struct st_wme *next;  /* next item in hash bucket */
  char *name;
  wme *value;
} ST_wme;

typedef struct st_variable {
  struct st_variable *next;  /* next item in hash bucket */
  char *name;
  Symbol *value;
} ST_variable;

/* Simulated real time in ms.					*/
extern int simtime;

/* List of {name, function} pairs to be provided by user.	*/
extern STFuncList st_funcs[];

/* Adds user-interface commands for simulated time system.	*/
void add_simtime_commands(void);

/* Reinitialize simulated time system.				*/
void init_simtime(void);

/* Call before each DC to record bottom operator on stack.	*/
void ST_before_DC(void);

/* Call after each DC to update time when operator changes, or	*/
/* count time for basic decision cycle.				*/
void ST_after_DC(void);

/* Call after each EC to count time basic elaboration cycle.	*/
void ST_after_EC(void);

/* Mechanism for recording tied-up resources.			*/
void CPM_schedule_resource(char *resname, int duration);

/* Make publicly available this routine to get an arbitrarily	*/
/* long string from a file.  (Terminates at newline or EOF.)	*/
char *fgets_long(FILE *fp);
