/* =====================================================================
                      Hook Routines for Soar 6

   These routines are called from Soar 6 when certain events happen.

   This version does not include all of the necessary code; it only
   shows some sample modifications that must be done to use the
   SIMTIME code.
===================================================================== */

#include "soar.h"

/*********** Add this line: ************/
#include "simtime.h"

/********* Optional addition **********/
/* If you don't wish to write any C functions, add in the following	*/
/* three lines of code.  Otherwise, add in something of the form shown	*/
/* in example.c.							*/

STFuncList st_funcs[] = {
  {NULL, NULL}
};


/* --------------------------------------------------------------------
                         System Startup Hook

   This function is called only once, at system startup time.  Typically,
   it should be used to set up any Soar I/O routines and install any
   user-defined RHS functions or interface commands.  This function is
   called after most of the system has been initialized, but before 
   ".init.soar" is loaded.

-------------------------------------------------------------------- */

void system_startup_hook (void) {
/*********** Add this line: ************/
  add_simtime_commands();
}

/* --------------------------------------------------------------------
                    Before and After Init Soar Hooks

   These functions are called just before and after, respectively, any
   init-soar is done.  (This includes not only the (init-soar) command,
   but also (excise-task) and (excise-all), which do an init-soar.)
-------------------------------------------------------------------- */

void before_init_soar_hook (void) {
/*********** Add this line: ************/
  init_simtime();
}

/* --------------------------------------------------------------------
                  Before and After Decision Cycle Hooks

   These functions are called at the start and end, respectively, of
   each decision cycle.
-------------------------------------------------------------------- */

void before_decision_cycle_hook (void) {
/*********** Add this line: ************/
  ST_before_DC();
}

void after_decision_cycle_hook (void) {
/*********** Add this line: ************/
  ST_after_DC();
}

/* --------------------------------------------------------------------
                  Before and After Input Phase Hooks

   These functions are called just before and after, respectively, the
   Soar I/O input cycle is executed.  (They are called even if the input
   cycle is effectively null because there is no top state.)
-------------------------------------------------------------------- */

void before_input_phase_hook (void) {
}

void after_input_phase_hook (void) {
/* Might want to call this somewhere else, I'm not sure. */
/*********** Add this line: ************/
  ST_after_EC();
}
