#include "soar.h"
#include "simtime.h"

/* This variable must be defined to tell the SIMTIME system about the	*/
/* functions that you have written.  It translates from a printable 	*/
/* event type (which is case sensitive) to the name of a function you	*/
/* wish to have called whenever the event occurs.			*/
/* It must be terminated by the pair {NULL, NULL}.			*/

STFuncList st_funcs[] = {
  {"OIS-INPUT", OIS_input},
  {"NTD-REPLY", NTD_reply},
  {NULL, NULL}
};

/* The functions which correspond to different events must also be	*/
/* defined somewhere and linked in to your program.  These functions	*/
/* take one argument, a character pointer, which will contain a string	*/
/* arguments that follow the event name in the event-listing file.	*/

/* This function copies text into a "phonological buffer", which might	*/
/* be used by another part of the program.  It also prints some of the	*/
/* arguments with an appropriate format.				*/
char phonological_buffer[100];
int pbuf_input;

void OIS_input (char *args) {
  int channel;
  char *sloc, *tloc;
  char speaker[10];
  char text[80];

  channel = atoi(args);
  sloc = strchr(args, ' '); tloc = strchr(args, '\t');
  strncpy(speaker, sloc+1, tloc-sloc); speaker[tloc-sloc-1] = '\0';
  strcpy(text, tloc+1);

  print("\n%7d OIS channel %d, %s says: %s\n",
	simtime, channel, speaker, text);
  strcpy(phonological_buffer, text);
  pbuf_input = FALSE;
  /* This eventually results in the addition of things to working	*/
  /* memory.  However, one could simply generate IO symbols and add	*/
  /* working memory elements right here.				*/
}

/* This function simply formats its arguments and prints them.		*/
void NTD_reply (char *args) {
  int channel;
  char *sloc, *tloc;
  char speaker[10];
  char text[80];

  channel = atoi(args);
  sloc = strchr(args, ' '); tloc = strchr(args, '\t');
  strncpy(speaker, sloc+1, tloc-sloc); speaker[tloc-sloc-1] = '\0';
  strcpy(text, tloc+1);

  if (strcmp(speaker, "NTD")) {
    print("Error: NTD not speaker in NTD-REPLY!\n");
  }

  print("\n%7d OIS channel %d, %s says: %s\n",
	simtime, channel, speaker, text);
}
