;; =====================================================================
;;
;; Conversion program for converting TAQL TC's to Soar 6 productions
;;
;; Usage:  start Soar5, load TAQL, load all your TC's, load this file;
;;         then do (dump-productions "filename");
;;         then go back to the shell and run "filename" through the 
;;           Soar5-->Soar6 production converting program
;;
;; =====================================================================

(in-package 'soar)
(lispsyntax)

;---- patch to get Soar to print symbols like |(| on LHS's correctly

(defun pm-lhs-conjunctive-test-to-list-of-strings (conjunctive-test)
  ;; Modified to not goof up and reverse some lists. -BGM 8/17/89
  ;; Modified to print { <> UNDECIDED ... } as ... or { ... }. -BGM 8/17/89
 (cond ((null conjunctive-test) (list "NIL"))
       ((listp conjunctive-test)
	(cond ((and (eq (first conjunctive-test) '{)
		    (eq (second conjunctive-test) '<>)
		    (eq (third conjunctive-test) 'UNDECIDED))
		 (if (still-conjunctive-test-after-removing-<>-undecided conjunctive-test)
		     (pm-lhs-conjunctive-test-to-list-of-strings (cons '{ (nthcdr 3 conjunctive-test)))
		     (pm-lhs-conjunctive-test-to-list-of-strings (butlast (nthcdr 3 conjunctive-test) 1))))
	      (t (do ((result-list nil)
		      (subtestp conjunctive-test (cdr subtestp)))
		     ((null subtestp) result-list)
		   (setq result-list 
			 (nconc result-list
				(pm-lhs-conjunctive-test-to-list-of-strings (car subtestp))
				(when (cdr subtestp) (list " "))))))))
       ((stringp conjunctive-test) (list (format nil "~S" conjunctive-test)))
       (t (list (format nil "~S" conjunctive-test))))) ; 9/24/91 RBD changed ~A to ~S



;---- code to dump all productions, along with op-apps if necessary,
;to a file

(defun dump-list-of-productions (prod-name-list filename)
  (with-open-file (*trace-file* filename :direction :output :if-exists :supersede)
    (dolist (name prod-name-list)
      (let* ((p (gethash name *rules*))
             (class (p-class p)))
        ;--- if necessary, print op-apps declaration for p
        (if (p-declared p)
            (if (or (member 'operator-application class)
                    (member 'operator-creation class)
                    (member 'operator-modification class))
                (format *trace-file* "~%~%(op-apps ~S)~%~%" name)
              ; else
                (if (member 'miscellaneous class)
                    (format *trace-file* "~%~%(op-no-apps ~s)~%~%" name)) ))
        ;--- print p
        (eval `(spm ,name))
        ))))

(defun dump-productions (filename)
  (dump-list-of-productions *user-pnames* filename))

(defun dump-productions-including-default (filename)
  (dump-list-of-productions *pnames* filename))

(export '(dump-productions dump-productions-including-default))
  
(soarsyntax)
(in-package 'user)
