;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-window-support.el,v $
;;;; $Id: sde-window-support.el,v 0.9 1994/06/23 20:07:29 hucka Exp $
;;;; 
;;;; Description       : Mouse, menu, font & color support.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-window-support-el-version "$Revision: 0.9 $"
  "The revision number of sde-window-support.el.  The complete RCS id is:
      $Id: sde-window-support.el,v 0.9 1994/06/23 20:07:29 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;; -----------------
;;; 0. Documentation.
;;; -----------------
;;;
;;; For font-lock.el, available in both FSF Emacs 19 and Lucid Emacs 19.


;;;----------------------------------------------------------------------------
;;; 1.  Requirements and miscellaneous setup.
;;;     Do not modify these.
;;;----------------------------------------------------------------------------

(require 'easymenu)
(eval-when (compile)
  (condition-case nil
      (require 'lmenu)
    (error				; Prior to 19.25, GNU Emacs lmenu.el
     (load-library "lmenu"))))		;  didn't do provide 'lmenu.


;;;----------------------------------------------------------------------------
;;; 2.  Mouse support.
;;;----------------------------------------------------------------------------

;; Not all of the following are used explicitly.  The rest are provided for
;; the user's convenience, if they want to bind them to buttons themselves.

(defun sde-mouse-print-soar (args)
  "Execute Soar \"print\" on the item under the cursor."
  (interactive "@e")
  (mouse-set-point args)
  (sde-check-soar)
  (call-interactively 'print-soar))

(defun sde-mouse-matches (args)
  "Execute Soar \"matches\" on the item under the cursor."
  (interactive "@e")
  (mouse-set-point args)
  (sde-check-soar)
  (call-interactively 'matches))

(defun sde-mouse-preferences (args)
  "Execute Soar \"preferences\" on the production under the cursor."
  (interactive "@e")
  (mouse-set-point args)
  (sde-check-soar)
  (call-interactively 'preferences))

(defun sde-mouse-find-production-by-name (args)
  "Execute `sde-find-production' on the production name under the cursor."
  (interactive "@e")
  (mouse-set-point args)
  (call-interactively 'sde-find-production-by-name))

(defun sde-mouse-send-production (args)
  "Send (load) the production under the cursor."
  (interactive "@e")
  (mouse-set-point args)
  (sde-check-soar)
  (call-interactively 'sde-send-production))

(defun sde-mouse-ptrace-production (args)
  "Execute Soar \"ptrace\" on the production under the cursor."
  (interactive "@e")
  (mouse-set-point args)
  (sde-check-soar)
  (call-interactively 'ptrace))

(defun sde-mouse-pbreak-production (args)
  "Execute SDE's \"pbreak\" on the production under the cursor."
  (interactive "@e")
  (mouse-set-point args)
  (sde-check-soar)
  (call-interactively 'pbreak))

(defun sde-mouse-explain (args)
  "Execute SDE's \"explain\" on the chunk condition under the cursor."
  (interactive "@e")
  (mouse-set-point args)
  (sde-check-soar)
  (call-interactively 'explain))


;;;----------------------------------------------------------------------------
;;; 3. Menu support.
;;;----------------------------------------------------------------------------

;; The following variables are set by `sde-menu-set-vars', which gets called
;; before a menu is displayed.  These variables are used as flags in the
;; various menu item definitions to determine whether those menu items should
;; be displayed in a particular situation.  The intent here is to cache
;; values that are used to disable menu items based on different conditions.
;; I think this must be faster that to repeatedly test the conditions
;; directly in the menu item definitions.

(defvar sde-menu-s-test nil
  "Whether Soar is alive.")
(make-variable-buffer-local 'sde-menu-s-test)

(defvar sde-menu-m-test nil
  "Whether this buffer is a source (sde-mode) buffer.")
(make-variable-buffer-local 'sde-menu-m-test)

(defvar sde-menu-s-v-test nil
  "Whether Soar is alive and is version 6.1.1 or later.")
(make-variable-buffer-local 'sde-menu-s-v-test)

(defvar sde-menu-s-m-r-test nil
  "Whether Soar is alive, this is an sde-mode buffer, and the region is active.")
(make-variable-buffer-local 'sde-menu-s-m-r-test)

(defvar sde-menu-s-a-test nil
  "Whether Soar is alive and a multi-agent version.")
(make-variable-buffer-local 'sde-menu-s-a-test)

(defvar sde-menu-s-a-v-test nil
  "Whether Soar is alive, is multi-agent, and is version 6.1.1 or later.")
(make-variable-buffer-local 'sde-menu-s-a-v-test)

;; Declarations for the compiler.

(defvar sde-print-hist)
(defvar sde-preferences-hist)
(defvar sde-matches-hist)
(defvar sde-ms-hist)

;; The menu definitions proper.  These are in Lucid Emacs menu syntax.

(defvar sde-soar-menu
  '("Soar"
    ["Start Soar"                 soar                         (not sde-menu-s-test)]
    ["Start specific Soar"
     (let ((current-prefix-arg 1))
       (call-interactively 'soar))
     (not sde-menu-s-test)]
    ["Interrupt Soar"             sde-interrupt-soar           sde-menu-s-test]
    ["Go"                         go                           sde-menu-s-test]
    ["Run"                        run                          sde-menu-s-test]
    ["Schedule"                   schedule 	               sde-menu-s-test]
    "-----"
    ["Init Soar"                  init-soar 	               sde-menu-s-test]
    ["Reset"                      reset    	               sde-menu-s-test]
    "------"
    ["Load file..."               load-soar                    sde-menu-s-test]
    ["Load default productions"   load-defaults                sde-menu-s-test]))

(defvar sde-settings-menu
  '("Settings"
    ("Print"
     (":depth"
      ["Level 0"                  (push ":depth 0" sde-print-hist)   t]
      ["Level 1"                  (push ":depth 1" sde-print-hist)   t]
      ["Level 2"                  (push ":depth 2" sde-print-hist)   t]
      ["Level 3"                  (push ":depth 3" sde-print-hist)   t]
      ["Level 4"                  (push ":depth 4" sde-print-hist)   t])
     (":internal"
      ["On"                       (sde-munge-print-internal 'add)    t]
      ["Off"                      (sde-munge-print-internal 'remove) t]))
    ("Preferences"
     ["Level 0"                   (push "0" sde-preferences-hist) t]
     ["Level 1"                   (push "1" sde-preferences-hist) t]
     ["Level 2"                   (push "2" sde-preferences-hist) t]
     ["Level 3"                   (push "3" sde-preferences-hist) t])
    ("Matches"
     ["Level 0"                   (push "0" sde-matches-hist)  t]
     ["Level 1"                   (push "1" sde-matches-hist)  t]
     ["Level 2"                   (push "2" sde-matches-hist)  t])
    ("Ms"
     ["Level 0"                   (push "0" sde-ms-hist)       t]
     ["Level 1"                   (push "1" sde-ms-hist)       t]
     ["Level 2"                   (push "2" sde-ms-hist)       t])
    ("Explain"
     ["On"                        explain-on                   sde-menu-s-v-test]
     ["Off"                       explain-off                  sde-menu-s-v-test])
    ("Warnings"
     ["On"                        warnings-on                  sde-menu-s-test]
     ["Off"                       warnings-off                 sde-menu-s-test])
    ("Load errors"
     ["On"                        load-errors-on               sde-menu-s-v-test]
     ["Off"                       load-errors-off              sde-menu-s-v-test])))

(defvar sde-production-menu
  '("Production"
    ["Send production to Soar"    sde-send-production          sde-menu-s-test]
    ["Send region to Soar"        sde-region-send              sde-menu-s-m-r-test]
    "-----"
    ["Excise production"          excise                       sde-menu-s-test]
    ["Excise region"              sde-region-excise            sde-menu-s-m-r-test]
    ["Excise file..."             excise-file                  sde-menu-s-test]
    ["Excise task"                excise-task                  sde-menu-s-test]
    ["Excise chunks"              excise-chunks                sde-menu-s-test]
    ["Excise all"                 excise-all                   sde-menu-s-test]
    "------"
    ["Ptrace production"          ptrace                       sde-menu-s-test]
    ["Ptrace region"              sde-region-ptrace            sde-menu-s-m-r-test]
    "-------"
    ["Pbreak production"          pbreak                       sde-menu-s-test]
    ["Pbreak region"              sde-region-pbreak            sde-menu-s-m-r-test]
    "--------"
    ["Find production by name"    sde-find-production-by-name  t]
    ["Find production by LHS..."  sde-find-production-by-lhs   t]
    ["Find production by RHS..."  sde-find-production-by-rhs   t]
    ["Find production by body..." sde-find-production-by-body  t]
    ["Find operator..."           sde-find-operator            t]
    ["Find problem space..."      sde-find-problem-space       t]
    ["Find next match"            sde-next-match               t]
    "---------"
    ["Count productions region"   sde-region-count-productions mark-active]
    ["Check unbalanced parens"    sde-find-unbalanced          sde-menu-m-test]))

(defvar sde-task-menu
  '("Task"
    ["List known tasks"           sde-list-tasks               t]
    "-----"
    ["String search"              sde-search                   t]
    ["String search regexp"       sde-search-regexp            t]
    ["Query replace"              sde-query-replace            t]
    ["Query replace regexp"       sde-query-replace-regexp     t]
    ["Find next match"            sde-next-match               t]))

(defvar sde-query-menu
  '("Query"
    ["Print"                      print-soar	               sde-menu-s-test]
    ["Matches"                    matches	               sde-menu-s-test]
    ["Preferences"                preferences	               sde-menu-s-test]
    ["Explain"                    explain	               sde-menu-s-v-test]
    ["Wm"                         wm		               sde-menu-s-test]
    ["Firing-counts"              firing-counts                sde-menu-s-test]
    "-----"
    ["View ptraces"               sde-view-ptraces             sde-menu-s-test]
    ["View pbreaks"               sde-view-pbreaks             sde-menu-s-test]
    ["View goal stack (pgs)"      sde-view-pgs                 sde-menu-s-test]
    ["View operator stack (pgso)" sde-view-pgso                sde-menu-s-v-test]
    ["View match set (ms)"        sde-view-ms                  sde-menu-s-test]
    ["View chunks"                sde-view-chunks              sde-menu-s-test]
    ["View productions"           sde-view-productions         sde-menu-s-test]
    ["View justifications"        sde-view-justifications      sde-menu-s-test]
    ["View working memory"        sde-view-working-memory      sde-menu-s-test]
    ["View Soar stats"            sde-view-stats               sde-menu-s-test]))

(defvar sde-agent-menu
  '("Agent"
    ["Create agent..."            create-agent                 sde-menu-s-a-test]
    ["Select agent..."            select-agent                 sde-menu-s-a-test]
    ["Set agent go..."            agent-go                     sde-menu-s-a-test]
    ["Destroy agent..."           destroy-agent                sde-menu-s-a-v-test]
    ["List agents"                list-agents                  sde-menu-s-a-test]))

(defvar sde-help-menu
  '("help"
    ["About SDE"		  sde-about-sde		       t]
    "-----"
    ["SDE Apropos..."             sde-apropos                  t]
    ["SDE/Soar Topic..."          sde-topic-help               t]
    "------"
    ["SDE Manual"                 sde-info                     t]
    ["Soar Manual"                sde-soar-info                t]
    ["Soar Release Notes"         sde-soar-release-notes       t]
    ["Soar User Notes"            sde-soar-user-notes          t]
    "-------"))

(defvar sde-in-out-menu
  '("In/Out"
    ["Previous input"             sde-previous-input           t]
    ["Next input"                 sde-next-input               t]
    ["Complete based on history"  sde-previous-similar-input   t]
    ["Search input history..."    sde-previous-input-matching  t]
    "-----"
    ["Erase last word typed"      backward-kill-word           t]
    ["Erase whole input"          sde-kill-input               t]
    ["Show last output"           sde-show-output              t]
    ["Erase last output"          sde-kill-output              t]
    "------"
    ["Jump to previous prompt"    sde-backward-prompt          t]
    ["Jump to next prompt"        sde-forward-prompt           t]))

;; Declarations to quiet the compiler.  These are actually defined elsewhere.

(defvar sde-soar-agents)
(defvar sde-source-modes)
(defvar sde-soar-version-at-least-6-1-1)

;; This is used to update the selectability flags of menu items.
;; It gets called right after a menu is pull-down by the user but
;; before the menu is actually displayed.

(defun sde-menu-set-vars ()
  (setq sde-menu-s-test     (and (featurep 'sde-soar-mode) (sde-soar-is-alive))
	sde-menu-m-test     (memq major-mode sde-source-modes)
	sde-menu-s-m-r-test (and sde-menu-s-test sde-menu-m-test mark-active)
	sde-menu-s-v-test   (and sde-menu-s-test
				 sde-soar-version-at-least-6-1-1)
	sde-menu-s-a-test   (and sde-menu-s-test sde-soar-agents)
	sde-menu-s-a-v-test (and sde-menu-s-a-test
				 sde-soar-version-at-least-6-1-1)))

;; Ugly function to munge the first item on the print history to add or
;; remove the ":internal" flag.

(defun sde-munge-print-internal (action)
  (let ((head (first sde-print-hist)))
    (save-match-data
      (cond ((null head)
	     (if (eq action 'add)
		 (push ":internal" sde-print-hist)))

	    ((string-match "\\(.*\\):internal\\(.*\\)" head)
	     (if (eq action 'add)
		 sde-print-hist		; Already there; do nothing.
	       (setq sde-print-hist
		     (cons (sde-string-trim (concat (sde-substring head 1)
						    (sde-substring head 2)))
			   (rest sde-print-hist)))))
	    (t
	     (if (eq action 'add)
		 (setq sde-print-hist
		       (cons (sde-string-trim (concat ":internal " head))
			     (rest sde-print-hist)))
	       ;; It's not there; do nothing.
	       nil))))))

;; `sde-define-menus' gets called every time a mode function is invoked.  It
;; is that way to accomodate Lucid Emacs.  Since in GNU Emacs 19 you don't
;; need to redefine the menus each time you create a new buffer in a given
;; mode (unlike in Lucid), we track which modes have had their menus defined
;; and do the definitions conditionally.

(defvar sde-menus-defined nil)

(defun sde-define-menus (mode map)
  "Adds pull-down menus for MODE under keymap MAP.
This assumes it is called in the buffer for which the menus are to be
defined by the mode function."
  (cond (sde-running-emacs19 (sde-define-menus-emacs19 mode map))
	(sde-running-lemacs  (sde-define-menus-lemacs mode map))))

(defun sde-define-menus-emacs19 (mode map)
  ;; Hook the update function into the menu update code.
  (make-local-variable 'menu-bar-update-hook)
  (add-hook 'menu-bar-update-hook 'sde-menu-set-vars)
  ;; Define the menus.  The menu for sde-mode needs to be defined first,
  ;; even if sde-soar-mode is invoked first; that's why the following
  ;; conditions are not mutually exclusive.
  (when (not (memq mode sde-menus-defined))
    ;; The menus have to be defined in reverse order from the order
    ;; in which they are to appear in the menubar.
    (easy-menu-define 'sde map "" sde-help-menu)
    (easy-menu-define 'sde map "" sde-agent-menu)
    (easy-menu-define 'sde map "" sde-query-menu)
    (easy-menu-define 'sde map "" sde-task-menu)
    (easy-menu-define 'sde map "" sde-production-menu)
    (easy-menu-define 'sde map "" sde-settings-menu)
    (easy-menu-define 'sde map "" sde-soar-menu)
    (when (eq mode 'sde-soar-mode)
      (easy-menu-define 'sde map "" sde-in-out-menu))
    (push mode sde-menus-defined)))

;; The popup menu.

(defvar sde-popup-menu 
  '("SDE"
    ["Print" print-soar t]
    ["Preferences" preferences t]
    ["Matches" matches t]
    ["Explain" explain t]
    "-----"
    ["Find production definition" sde-find-production-by-name t]
    ["Send production to Soar" sde-send-production t]
    ["Excise production" excise t]
    ("Trace/Break production"
     ["Ptrace" ptrace t]
     ["Unptrace" unptrace t]
     ["Pbreak" pbreak t]
     ["Unpbreak" pbreak t])))

;; Amazingly enough, this works in both FSF Emacs and Lucid Emacs.
;; In FSF Emacs, have to load lmenu.el.

(defun sde-popup-menu (event)
  "Pop up a menu of common SDE commands."
  (interactive "@e")
  (unless (fboundp 'popup-menu) 
    (when sde-running-emacs19
      ;; Versions of lmenu.el prior to FSF Emacs 19.24 didn't (provide 'lmenu).
      (load-library "lmenu")))
  (mouse-set-point event)
  (sit-for 0)
  (popup-menu sde-popup-menu))


;;;----------------------------------------------------------------------------
;;; 4. Support for highlighting.
;;;----------------------------------------------------------------------------

;; Create faces in a way hopefully compatible with both Lucid and FSF Emacs.
;; This bizarre combination of setting the variables to the symbols and
;; doing make-face on the symbols works, but I'm not sure why.

(defvar sde-names-face 'sde-names-face
  "Face to use for production names.")

(defvar sde-variables-face 'sde-variables-face
  "Face to use for production variables.")

(defvar sde-attributes-face 'sde-attributes-face
  "Face to use for attributes in production clauses.")

(defvar sde-values-face 'sde-values-face
  "Face to use for attribute values in production clauses.")

(defvar sde-flags-face 'sde-flags-face
  "Face to use for production flags.")

(defvar sde-soar-prompt-face 'sde-soar-prompt-face
  "Face to use to highlight the prompt in Soar process buffers.")

(defvar sde-soar-output-buffer-title-face 'sde-soar-output-buffer-title-face 
  "Face to use to highlight title lines in the Soar *output* buffer.")

(make-face 'sde-names-face)
(make-face 'sde-variables-face)
(make-face 'sde-attributes-face)
(make-face 'sde-values-face)
(make-face 'sde-flags-face)
(make-face 'sde-soar-prompt-face)
(make-face 'sde-soar-output-buffer-title-face)

;; Defaults

(condition-case nil
    (or (face-differs-from-default-p sde-names-face)
	(sde-make-face-bold sde-names-face nil t))
  (error nil))

(condition-case nil
    (or (face-differs-from-default-p sde-flags-face)
	(sde-make-face-bold sde-flags-face nil t))
  (error nil))

(condition-case nil
    (or (face-differs-from-default-p sde-soar-prompt-face)
	(sde-make-face-bold sde-soar-prompt-face nil t))
  (error nil))

(condition-case nil
    (or (face-differs-from-default-p sde-soar-output-buffer-title-face)
	(sde-make-face-bold-italic sde-soar-output-buffer-title-face nil t)
	(sde-make-face-italic sde-soar-output-buffer-title-face nil t))
  (error nil))


(defvar sde-font-lock-possible-values '(names flags variables values attributes)
  "Possible contents of the list `sde-font-lock-list'.")

(defvar sde-font-lock-handlers-alist
  '((names      ("[^<]\\<\\(\\(\\sw\\|\\s_\\)+\\*+\\(\\sw\\|\\s_\\|\\*\\)*\\|chunk-[0-9]+\\|justification-[0-9]+\\)\\>"
		 . sde-names-face))
    (variables  ("<[^ \t\n\)>]+>" . sde-variables-face))
    (attributes ("\\^\\([^ \t\n]+\\)" 1 sde-attributes-face))
    (values     ("\\^[^ \t\n]+[ \t]+\\([^^\)\n]+\\)" 1 sde-values-face))
    (flags      ("\\(:default\\|:o-support\\|:no-o-support\\|:chunk\\)" . sde-flags-face))))

(defvar font-lock-keywords)		; For the compiler.

(defun sde-font-lock-mode-hook ()
  "Mode hook for setting font-lock-keywords appropriate for SDE buffers."
  (if (memq major-mode sde-modes)
      ;; This code is a little strange because we have to insure that the
      ;; elements on the font-lock-keywords list appear in the proper order.
      ;; So instead of looping over sde-font-lock-list, we loop over a list
      ;; that contains all possible values of sde-font-lock-list in a preset
      ;; order. 
      (let ((elements sde-font-lock-possible-values)
	    expr)
	(while elements
	  (setq expr (car (cdr (assq (car elements) sde-font-lock-handlers-alist))))
	  (if (and (memq (car elements) sde-font-lock-list)
		   (not (member expr font-lock-keywords)))
	      (setq font-lock-keywords (append font-lock-keywords (list expr))))
	  (setq elements (cdr elements)))))

  ;; If it's a Soar process buffer, also highlight the prompt.
  (if (eq major-mode 'sde-soar-mode)
      (setq font-lock-keywords
	    (append font-lock-keywords
		    (list (cons (concat "\\(" sde-soar-prompt-regexp "\\)")
				'sde-soar-prompt-face)))))

  ;; ... or if it's a Soar output buffer, also highlight the title line.
  (if (eq major-mode 'sde-soar-output-mode)  
      (setq font-lock-keywords
	    (append (list '("^======.*======$" . sde-soar-output-buffer-title-face))
		    font-lock-keywords))))



;;;----------------------------------------------------------------------------
;;; 5.  Closing statements
;;;----------------------------------------------------------------------------

(add-hook 'font-lock-mode-hook 'sde-font-lock-mode-hook)

(provide 'sde-window-support)

;;; Local Variables:
;;; eval:(put 'sde-make-menus 'lisp-indent-function 2)
;;; End:
