;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-version.el,v $
;;;; $Id: sde-version.el,v 0.7 1994/06/23 21:01:25 hucka Exp $
;;;; 
;;;; Description       : Identification of the current version of SDE.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.


;;; -----------------
;;; 0.  Documentation
;;; -----------------
;;;
;;; Prior to distributing a new release of SDE, this file must be checked in
;;; (with RCS) along with the other files in the system.  Doing so will
;;; automatically increment the value of sde-version.  
;;;
;;;      ***************************************************
;;;      *  ONLY CHECK IN THIS FILE AT EVERY NEW RELEASE!  *
;;;      ***************************************************
;;;
;;; Otherwise, the value of sde-version will not correspond to the release
;;; number.  The best way to handle all this is to use rcsfreeze, the RCS
;;; command to assign a symbolic revision number to every file in a system.
;;; Do a "man rcsfreeze" for more information.

(defconst sde-version (substring "$Revision: 0.7 $" 11 -2)
  "The current version number of the Soar Development Environment.")

(defconst sde-version-date (substring "$Date: 1994/06/23 21:01:25 $" 7 -2)
  "The release date of this version of the Soar Development Environment.")

(defun sde-version ()
  "Report the version number of SDE."
  (interactive)
  (message "SDE version %s of %s" sde-version sde-version-date))

(provide 'sde-version)
