;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-vars.el,v $
;;;; $Id: sde-vars.el,v 0.5 1994/06/23 20:46:23 hucka Exp $
;;;; 
;;;; Description       : User customization variables for SDE.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-vars-el-version "$Revision: 0.5 $"
  "The revision number of sde-vars.el.  The complete RCS id is:
      $Id: sde-vars.el,v 0.5 1994/06/23 20:46:23 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation
;;;; 1.  Global variables for customization by user.
;;;; 2.  Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;; -----------------
;;; 0. Documentation.
;;; -----------------
;;;
;;; This file contains all major global variables that can be set to
;;; customize SDE in various ways.  Users may wish to customize the values
;;; of these symbols, by resetting their values via setq in their .emacs
;;; files.
;;;
;;; Other SDE source code files may contain variables, but those are meant
;;; to be local to those files, and not set by the user.


;;;----------------------------------------------------------------------------
;;; 1.  Global variables for customization by user.
;;;----------------------------------------------------------------------------

;;; Configuration variables.

(defvar sde-inhibit-record-file-data nil
  "*If `nil', SDE will not parse Soar tasks as they are visited in Emacs.
SDE normally parses Soar files to determine the set of files and
productions in the tasks that you edit.  This is used to implement various
facilities such as finding production source code, string replacements across
tasks, context-sensitive operations, and more.  SDE is smart about parsing
files and uses caching and other techniques to try to delay performing a full
parse of a task until the information is really needed.  Unfortunately,
parsing files takes time and depending on your computer, the size of your
task, and your needs, you may want to turn it off by setting this variable
to `t'.  Doing so will turn off the facilities that depend on the task
information.")

(defvar sde-file-types-regexp-list
  '("\\.soar$"  "\\.soar5$" "\\.soar6$" "\\.soa$"
    "\\.init\\.soar" "\\.reset.soar")
  "*List of file extensions that should use SDE.
Each regular expression in this is tested against a file name when you visit
a file with `find-file' \(`\\<global-map>\\[find-file]') and if the
expression matches some part of the file name, the file is put into SDE Mode.")

(defvar sde-load-files-regexp-list
  '("\\.init\\.soar" "\\`load\\.soar")
  "*List of regexps matching files that are considered top-level load files.
Normally SDE maintains an internal database of the source files that comprise
the tasks being edited.  In order to build the database, SDE needs to know
which file loads the rest of the files in any given task.  For many files,
SDE needs to prompt the user.  Some files are automatically assumed to be
top-level load files when visited or loaded by Soar.  This variable determines
the names of those files.")

(defvar sde-default-file-extension ".soar"
  "*Default extension used for Soar files created by SDE.")

(defvar sde-use-multiple-frames
  (and window-system (string-match "19" emacs-version))
  "*If t (default in Emacs 19), use multiple frames if possible.
This is only possible in GNU Emacs 19 and Lucid Emacs 19, which are versions
of Emacs that support multiple screens (called \"frames\" in GNU Emacs 19)
under X windows.  A value of t for this variable means SDE will create a
separate frame/screen for the *output* buffer and for each Soar agent
process.  A value of 'output means SDE will only create a separate frame for
the *output* buffer, not for agent processes, while a value of nil means SDE
will never deliberately create a new frame for *output* or for agents.  Also
see the variable `sde-use-output-buffer'.")

(defvar sde-production-indent-offset 2
  "*Integer value indicating how far to indent production clauses.")

(defvar sde-arrow-indent-offset 0
  "*Integer value indicating how far to indent the arrow in a Soar production.
This value is relative to the indentation of the production as a whole.
Default: 0.  A negative value moves the arrow leftward.  A positive value
indents the arrow further to the right relative to the surrounding clauses.")

(defvar sde-sort-lists t
  "*Non-`nil' means to sort lists of files & productions before using them.
Some SDE operations, such as `sde-find-production-by-lhs' and
`sde-query-replace', display or operate on lists of files and productions.
When this flag is non-`nil' \(the default), SDE will sort them alphabetically
before presenting the lists to the user.  However, this can take time,
because the lists can be very long.  To avoid the cost of sorting, set this
flag to `nil'.")

(defvar sde-soar-program "soar"
  "*String indicating the name of the Soar program to run.
This is used by the SDE command `soar' when starting up Soar.  The default
value is the string \"soar\".  It can be the name of a program, or an
absolute pathname (i.e., beginning with a '/' or '~').  If the value of this
variable is not an absolute pathname, the named program is found using normal
shell command searching conventions.")

(defvar sde-soar-starting-directory nil
  "*String indicating the default directory in which to start Soar.  
This is a useful variable to set because Soar looks in the starting directory
for init files.  Unless `\\[soar]' is invoked with a prefix argument, it will
cd to `sde-soar-default-directory' before starting Soar.")

(defvar sde-soar-switches nil
  "*List of strings passed as switches to Soar at start-up time.
As of version 6.1.1, standard Soar does *not* accept command line switches.
This variable is provided for use with modified Soar systems such as
ModSAF/SAFSoar.  Make sure that each individual element in this list
is a separate string.  Example of usage:

  \(setq sde-soar-switches '(\"-sde\" \"-nonet\" \"-terrain\" \"ocean-0001\"))

Also see the documentation for the variable `sde-prompt-for-soar-switches'.")

(defvar sde-prompt-for-soar-switches nil
  "*Whether to prompt for switches to Soar if `sde-soar-switches' is nil.
Normally, the `M-x soar' command will not prompt for switches unless it
is given a prefix argument, because standard Soar does not accept command
line switches.  However, if you wish `M-x soar' to prompt for switches
when `sde-soar-switches' is nil (just as it does for the other variables
such as `sde-soar-starting-directory'), set this variable to t.  This
may be useful if you are running a modified Soar, such as ModSAF/SAFSoar,
and you want to run it repeatedly in the same directory but with different
command line switches each time.")

(defvar sde-soar-use-ptys nil
  "*Non-nil if SDE should make Emacs use a pty for communicating with Soar.
Default: nil.  A pseudo-tty is usually not necessary for SDE to communicate
with Soar, and it is more efficient to use pipes, hence you will normally want
this variable to be nil.  However, if you are running a Soar-derived system
such as ModSAF/SAFSoar, you may need to set this to t.")

(defvar sde-soar-defaults-file nil
  "*Pathname to the Soar default productions file (\"default.soar\").
This is set in the SDE site initialization file, \"sde-site.el\".")

(defvar sde-soar-beep-after-setup nil
  "*Non-nil means beep after Soar has started up and is ready.  Default: nil.")

(defvar sde-soar-use-output-buffer t
  "*Whether output from most Soar commands should be put in a separate buffer.
If this variable is non-nil (the default), output from commands such as
querying commands will be placed in a buffer named *output* instead of being
dumped into the Soar agent buffer.  \(Exception: output from the commands go
and run is always placed in the Soar process buffer.)  If nil, all output
goes to the Soar process buffer.")

(defvar sde-soar-erase-output-buffer nil
  "*Whether to erase the Soar output buffer before each new output appears.
Default is nil.")

(defvar sde-soar-move-point-on-output nil
  "*Whether to move point to the bottom of new output upon each command.
Default is nil, which means that if your cursor is in a Soar agent or output
buffer, but not at the bottom, at the time you issue a command, point will
not be moved.  If this variable is t, then when output appears, the cursor
will be moved to the bottom to follow the output.  The default setting
results in less jerking around of the screen.")

(defvar sde-soar-output-truncation-threshold 1000000
  "*Maximum size of a process buffer before SDE starts truncating it.")

(defvar sde-soar-output-truncation-amount 100000
  "*Number of bytes by which old Soar output is removed from Soar process
buffers when the buffer size exceeds `sde-soar-output-truncation-threshold.")

(defvar sde-soar-agent-buffer-defaults
  '((height . 24)
    (width . 80))
  "*Association list of default values for Soar agent buffer screens/frames.
This determines the attributes of new frames/screens created for Soar agents.
This is only effective if `sde-use-multiple-frames' is non-nil and you are
running in Emacs 19.22 or later or Lucid Emacs 19.  The value may be set in
your ~/.emacs init file, like this:
     
  (setq sde-soar-agent-buffer-defaults '((width . 80) (height . 55)))
     
In Emacs 19.22, the possible parameters are: 
  height                  -- Height of the window in characters.
  width                   -- Width of the window in characters.
  left                    -- Screen position of the left edge, in pixels.
  top                     -- Screen position of the top edge, in pixels.
  name                    -- Name of the frame.
  auto-raise              -- Whether selecting the frame raises it.
  auto-lower              -- Whether deselecting the frame raises it.
  vertical-scroll-bars    -- Whether frame has a vertical scroll bar.
  horizontal-scroll-bars  -- Whether frame has a horizontal scroll bar.
  border-width            -- The width in pixels of the window border.
  internal-border-width   -- The distance in pixels between text and border.
  menu-bar-lines          -- Number of lines to allocate for a menu bar.
  minibuffer              -- Whether to have a minibuffer in the frame
  cursor-color            -- The color of the text cursor that shows point.
  mouse-color             -- The color of the mouse cursor.
  foreground-color        -- The color of the inside of characters.
  background-color        -- The color of background of text.
  border-color            -- The color for the border of the frame.
  cursor-type             -- The way to display the cursor.
     There are two legitimate values: `bar' and `box'.  
     The value `bar' specifies a vertical bar between characters as the
     cursor.  The value `box' specifies an ordinary black box overlaying
     the character after point; that is the default.
  icon-type               -- Type of icon to use when frame it is iconified.
                             Non-`nil' = bitmap icon, `nil' = text icon.")

(defvar sde-soar-output-buffer-defaults 
  '((height . 20)
    (width . 80)
    (top . 20)
    (left . 20))
  "*Association list of default values for Soar output buffer screens/frames.
This determines the attributes of the Soar output buffer screen/frame when
`sde-use-multiple-frames' is non-nil.  This is only effective if
`sde-use-multiple-frames' is non-nil and you are running in Emacs 19.22 or
later or Lucid Emacs 19.  The value may be set in your init file, like this:
     
  (setq sde-soar-output-buffer-defaults '((width . 80) (height . 55)))
     
In Emacs 19.22, the possible parameters are: 
  height                  -- Height of the window in characters.
  width                   -- Width of the window in characters.
  left                    -- Screen position of the left edge, in pixels.
  top                     -- Screen position of the top edge, in pixels.
  name                    -- Name of the frame.
  auto-raise              -- Whether selecting frame raises it.
  auto-lower              -- Whether deselecting frame raises it.
  vertical-scroll-bars    -- Whether frame has a vertical scroll bar.
  horizontal-scroll-bars  -- Whether frame has a horizontal scroll bar.
  border-width            -- The width in pixels of the window border.
  internal-border-width   -- The distance in pixels between text and border.
  menu-bar-lines          -- Number of lines to allocate for a menu bar.
  minibuffer              -- Whether to have a minibuffer in the frame
  cursor-color            -- The color of the text cursor that shows point.
  mouse-color             -- The color of the mouse cursor.
  foreground-color        -- The color of the inside of characters.
  background-color        -- The color of background of text.
  border-color            -- The color for the border of the frame.
  cursor-type             -- The way to display the cursor.
     There are two legitimate values: `bar' and `box'.  
     The value `bar' specifies a vertical bar between characters as the
     cursor.  The value `box' specifies an ordinary black box overlaying
     the character after point; that is the default.
  icon-type               -- Type of icon to use when frame it is iconified.
                             Non-`nil' = bitmap icon, `nil' = text icon.")

(defvar sde-soar-track-cd t
  "*Non-nil (the default) means track cd & pwd commands in the Soar process.")

(defvar sde-soar-input-ring-size 30
  "*Size of Soar process input history ring.")

(defvar sde-soar-input-ring-filter
  '(lambda (str) (not (string-match "\\`\\s *\\'" str)))
  "*Predicate for filtering additions to Soar process input history.
Only inputs answering true to this function are saved on the input
history list.  Default is to save anything that isn't all whitespace.")

(defvar sde-production-name-test-regexp
  "\*\\|chunk-[0-9]+\\|justification-[0-9]+"
  "*Regexp for determining whether a symbol likely is a production name.
It is used by the function that extracts production names near the cursor in
a buffer.  By default this regular expression tests that an extracted name
contains either the character '*' or a string of the form \"chunk-n\" or
\"justification-n\", where \"n\" is an integer.") 

(defvar sde-compat-auto-update t
  "*If non-nil, SDE will automatically convert files that try to use
\"soar-mode\" or \"production-editor\" to use SDE instead.  The files' 
local variables lists or the -*- header lines will be edited to use
\"sde-mode\".")

(defvar sde-query-replace-highlight window-system
  "*Non-nil means to highlight words during query replacement.
This sets the value of `query-replace-highlight' in the string search functions
that use `sde-query-replace' and `sde-query-replace-regexp'.  It is turned on
by default when Emacs is running in a windowing environment.")

(defvar sde-font-lock-list '(names)
  "*List of production elements to highlight using the font-lock package.
In addition to the regular font-lock faces, this list determines which
production elements will be displayed in different faces when font locking is
turned on.  The font-lock package automatically highlights comments and
strings using the two faces

    font-lock-comment-face
    font-lock-string-face

\(See the documentation for `font-lock-mode' for more information.)
`sde-font-lock-list' is a list containing symbols that indicate which
production elements, in addition to comments and strings, should be
highlighted in SDE mode.  It can contain only the following symbols:

    names	-- highlight names of productions
    variables	-- highlight variables
    attributes	-- highlight attributes
    values	-- highlight values of attributes
    flags	-- highlight the production flag (e.g., \":o-support\", etc.)

By default this list contains only '(names), which means to highlight just
production names.  You can change this by setting the value of this variable
to a new list in your .emacs file.  For example, to highlight names and
variables, use 

    (setq sde-font-lock-list '(names variables))

The font lock faces corresponding to the different production elements are:

    sde-names-face	 -- the face used for \"names\"
    sde-variables-face	 -- the face used for \"variables\"
    sde-attributes-face	 -- the face used for \"attributes\"
    sde-values-face	 -- the face used for \"values\"
    sde-flags-face	 -- the face used for \"flags\"

By default, only the faces `sde-names-face' and `sde-flags-face' are set to
something other than the Emacs default face.  You may set their
characteristics to your liking in your ~/.emacs file.  Here are the Emacs
commands available for this (where FACE is one of sde-names-face,
sde-variables-face, etc.):

    (set-face-font FACE \"font\")         -- set font
    (set-face-foreground FACE \"color\")  -- set foreground color
    (set-face-background FACE \"color\")  -- set background color
    (set-face-underline-p FACE t/nil)     -- make face underlined or not
    (invert FACE)                         -- swap foreground & background
    (make-face-bold FACE)                 -- use the bold version of the font
    (make-face-italic FACE)               -- use the italic version
    (make-face-bold-italic FACE)          -- use the bold italic version
    (make-face-unbold FACE)               -- turn off bold facing
    (make-face-unitalic FACE)             -- turn off italic

For example, if you wanted to make SDE highlight both production names and
attributes using font lock, and make attributes be underlined, you could put
the following in your ~/.emacs after loading SDE:

    (setq sde-font-lock-list '(names attributes))
    (set-face-underline-p sde-attributes-face t)

Remember that to turn on font locking, you must invoke `font-lock-mode'.  To
make SDE font lock all Soar buffers, add this to your ~/.emacs:

    (add-hook 'sde-mode-hook '(lambda () (font-lock-mode 1)))
    (add-hook 'sde-soar-mode-hook '(lambda () (font-lock-mode 1)))
    (add-hook 'sde-soar-output-mode-hook '(lambda () (font-lock-mode 1)))

Beware that when font-lock is turned on, the *first* time you visit a
particular file in Emacs, it will take some time to perform the highlighting.
The more elements you put on `sde-font-lock-list', the longer it will take
for Emacs to \"fontify\" your code initially, so use this feature sparingly.
Once the initial highlighting is finished, editing does not suffer a
significant slowdown.

To find out about the color names available for your X Window System,
read the file /usr/lib/X11/rgb.txt.  Alternatively, you can use a hexadecimal
number to specify a color\; to learn about this, read the man page for \"X\",
which includes a section on colors in X Windows.  You can easily read the
manual page using the `M-x man' command in Emacs.

Beware that for GNU Emacs 19, it is best to use fixed-width fonts.  To
find out which fixed-width fonts are available on your computer system,
run the following commands in a Unix shell:

     xlsfonts -fn '*x*'
     xlsfonts -fn '*-*-*-*-*-*-*-*-*-*-*-m*'
     xlsfonts -fn '*-*-*-*-*-*-*-*-*-*-*-c*'

\(Note: on some machines these commands seem to freeze the window server
for a few seconds while they execute -- patience is required here.)")

;; Leave the next few vars unbound by default.  This makes it possible to
;; determine whether the user has set them at all.

(defvar sde-feedback-cc nil
  "*Address(es) that will be carbon-copied automatically by sde-feedback.
This variable should be set to a string containing addresses separated by
commas.")

(defvar sde-feedback-self-blind)
(put   'sde-feedback-self-blind 'variable-documentation
  "*If non-nil, a blind carbon-copy (bcc) field to yourself is inserted into
the sde-message when it is initialized.  Setting this variable overrides the
standard Emacs `mail-self-blind' variable in sde-feedback messages.")

(defvar sde-feedback-archive-file-name)
(put   'sde-feedback-archive-file-name 'variable-documentation
  "*If non-nil, it should be a string naming a file in which the sde-feedback
message will be written at the same time it is mailed.  Setting this variable
overrides the standard `mail-archive-file-name' in sde-feedback messages.
Here is an example of how to set this in your .emacs file:

      \(setq 'sde-feedback-archive-file-name \"~/mail/sde-mail\"")

(defvar sde-feedback-setup-hook nil
  "*If non-nil, it should be a function or list of functions to call after a
message is initialized.  Hook functions get called with no arguments.")

;; Keymaps

(defvar sde-mode-map nil
  "*Keymap for SDE Mode.")

(defvar sde-find-cmds-map nil
  "*Keymap for find commands in SDE.")

(defvar sde-view-cmds-map nil
  "*Keymap for view commands in SDE.")

(defvar sde-agent-cmds-map nil
  "*Keymap for agent commands in SDE.")

(defvar sde-region-cmds-map nil
  "*Keymap for region commands in SDE.")

(defvar sde-help-cmds-map nil
  "*Keymap for help commands in SDE.")  

(defvar sde-soar-mode-map nil
  "*Keymap for Soar Mode.")

(defvar sde-soar-output-mode-map nil
  "*Keymap for Soar output buffer.")

;; Syntax tables & other tables.

(defvar sde-mode-syntax-table nil
  "*Syntax table used while in Soar Mode.")

(defvar sde-mode-abbrev-table nil
  "*Table of abbreviations for Soar Mode.")

;;; Hook variables.

(defvar sde-site-hook nil
  "*Hook run after loading the Soar Development Environment.
This is the place to put site-specific initializations, such as local
menus.")

(defvar sde-load-hook nil
  "*Hook run after loading the Soar Development Environment.
This is a good place to put customizations and key bindings.")

(defvar sde-mode-hook nil
  "*Hook run after starting sde-mode.  
This is a good place to put customizations and key bindings.")

(defvar sde-soar-mode-hook nil
  "*Hook for functions to be run after starting up a Soar process.
Good for customizing the interaction environment.")

(defvar sde-soar-output-mode-hook nil
  "*Hook of functions to be run after the Soar output buffer is created.")

(defvar sde-soar-hook nil
  "*Hook of functions to run after first prompt appears in Soar process buffer.")

(defvar sde-soar-error-hook nil
  "*Hook of functions to be run after an error is shown the Soar error buffer.")

;; Declared here for the compiler but really defined in sde-headers.el.
(defvar sde-header-hooks)
(put   'sde-header-hooks 'variable-documentation
 "*List of functions that insert each line of a file header in Soar files.")

;;; Defaults for optional arguments to commands

(defvar sde-go-args nil
  "*String containing default optional args for \"go\".")

(defvar sde-run-args nil
  "*String containing default optional args for \"run\".")

(defvar sde-matches-args nil
  "*String containing default optional args for \"matches\".")

(defvar sde-ms-args nil
  "*String containing default optional args for \"ms\".")

(defvar sde-firing-counts-args nil
  "*String containing default optional args for \"firing-counts\".")

(defvar sde-print-args nil
  "*String containing default optional args for \"soar-print\".")

(defvar sde-preferences-args nil
  "*String containing default optional args for \"preferences\".")

(defvar sde-list-productions-args nil
  "*String containing default optional args for \"list-productions\".")

(defvar sde-list-chunks-args nil
  "*String containing default optional args for \"list-chunks\".")

(defvar sde-list-justifications-args nil
  "*String containing default optional args for \"list-justifications\".")

(defvar sde-agent-go-args nil
  "*String containing default optional args for \"agent-go\".")

(defvar sde-schedule-args nil
  "*String containing default optional args for \"schedule\".")

(defvar sde-reset-args nil
  "*String containing default optional args for \"reset\".")

(defvar sde-explain-args nil
  "*String containing default optional args for \"explain\".")


;;;----------------------------------------------------------------------------
;;; 2.  Closing statements.
;;;----------------------------------------------------------------------------
