;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/flamingo/y/soar/projects/hucka/sde/RCS/sde-repos.el,v $
;;;; $Id: sde-repos.el,v 0.3 1994/06/15 20:29:36 hucka Exp $
;;;; 
;;;; Description       : Special command for repositioning window.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-repos-el-version "$Revision: 0.3 $"
  "The revision number of sde-repos.el.  The complete RCS id is:
      $Id: sde-repos.el,v 0.3 1994/06/15 20:29:36 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation
;;;; 1.  Require, provide, and miscellaneous setup.
;;;; 2.  Main code.
;;;; 3.  Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;; ----------------
;;; 0. Documentation
;;; ----------------
;;;
;;; Implementation of a smart window repositioning command.
;;; Originally from reposition-window.el by Michael Ernst & adapted for SDE.
;;; Newsgroups: gnu.emacs.sources
;;; From: mernst@@theory.lcs.mit.edu (Michael Ernst)
;;; Subject: reposition-window.el (again) (corrected posting)
;;; Date: 22 Feb 91 11:30:49
;;;
;;; Put here because sde.el was getting too big, and users don't seem to
;;; employ this as frequently as I thought they would.  


;;;----------------------------------------------------------------------------
;;; 1.  Require, provide, and miscellaneous setup.
;;;     Do not modify these.
;;;----------------------------------------------------------------------------


;;;----------------------------------------------------------------------------
;;; 2.  Main code.
;;;----------------------------------------------------------------------------

(defun sde-reposition-window (&optional arg)
  "Move current production & its preceding comments to beginning of window.
Further invocations move first line of production to the top of the window
or toggle the visibility of comments that precede it.
  Point is left unchanged unless prefix ARG is supplied.
  If the production is fully onscreen, it is moved to the top of the
window.  If it is partly offscreen, the window is scrolled to get the
definition (or as much as will fit) onscreen, unless point is in a comment
which is also partly offscreen, in which case the scrolling attempts to get
as much of the comment onscreen as possible.
  Initially `sde-reposition-window' attempts to make both the definition and
preceding comments visible.  Further invocations toggle the visibility of
the comment lines.
  If ARG is non-nil, point may move in order to make the whole production
visible (if only part could otherwise be made so), to make the production
line visible (if point is in code and it could not be made so, or if only
comments, including the first comment line, are visible), or to make the
first comment line visible (if point is in a comment)."
  (interactive "P")
  (let* ((here (point))
	 ;; change this name once I've gotten rid of references to ht.
	 ;; this is actually the number of the last screen line
	 (ht (- (window-height (selected-window)) 2))
	 (line (sde-repos-count-lines (window-start) (point)))
	 (comment-height
	  ;; The call to max deals with the case of cursor between defuns.
	  (max 0
	       (sde-repos-count-lines-signed
		;; the beginning of the preceding comment
		(save-excursion
		  (forward-char 1)
		  (sde-beginning-of-production 2)
		  (sde-end-of-production)
		  ;; Skip whitespace, newlines, and form feeds.
		  (re-search-forward "[^\\s \n\014]")
		  (backward-char 1)
		  (point))
		here)))
	 (defun-height 
	     (sde-repos-count-lines-signed
	      (save-excursion
		(sde-end-of-production 1)	; so comments associate with following defuns
		(sde-beginning-of-production 1)
		(point))
	      here))
	 ;; This must be positive, so don't use the signed version.
	 (defun-depth (sde-repos-count-lines here
					     (save-excursion
					       (sde-end-of-production 1)
					       (point))))
	 (defun-line-onscreen-p
	     (and (<= defun-height line)
		  (<= (- line defun-height) ht))))
    (cond ((or (= comment-height line)
	       (and (= line ht)
		    (> comment-height line)
		    ;; if defun line offscreen, we should be in case 4
		    defun-line-onscreen-p))
	   ;; Either first comment line is at top of screen or (point at
	   ;; bottom of screen, defun line onscreen, and first comment line
	   ;; off top of screen).  That is, it looks like we just did
	   ;; recenter-definition, trying to fit as much of the comment
	   ;; onscreen as possible.  Put defun line at top of screen; that
	   ;; is, show as much code, and as few comments, as possible.

	   (if (and arg (> defun-depth (1+ ht)))
	       ;; Can't fit whole defun onscreen without moving point.
	       (progn (sde-end-of-production) (sde-beginning-of-production) (recenter 0))
	       (recenter (max defun-height 0))))

	  ((or (= defun-height line)
	       (= line 0)
	       (and (< line comment-height)
		    (< defun-height 0)))
	   ;; Defun line or cursor at top of screen, OR cursor in comment
	   ;; whose first line is offscreen.
	   ;; Avoid moving definition up even if defun runs offscreen;
	   ;; we care more about getting the comment onscreen.
	   
	   (cond ((= line ht)
		  ;; cursor on last screen line (and so in a comment)
		  (if arg (progn (sde-end-of-production) (sde-beginning-of-production)))
		  (recenter 0))
		 

		 ;; This condition, copied from case 4, may not be quite right
		 
		 ((and arg (< ht comment-height))
		  ;; Can't get first comment line onscreen.
		  ;; Go there and try again.
		  (forward-line (- comment-height))
		  (beginning-of-line)
		  (recenter 0))
		 (t
		  (recenter (min ht comment-height)))))

	  ((and (> (+ line defun-depth -1) ht)
		defun-line-onscreen-p)
	   ;; Defun runs off the bottom of the screen and the defun line
	   ;; is onscreen.
	   ;; Move the defun up.
	   (recenter (max 0 (1+ (- ht defun-depth)) defun-height)))

	  (t
	   ;; If on the bottom line and comment start is offscreen
	   ;; then just move all comments offscreen, or at least as
	   ;; far as they'll go.
	   ;; Try to get as much of the comments onscreen as possible.
	   (if (and arg (< ht comment-height))
	       ;; Can't get defun line onscreen; go there and try again.
	       (progn (forward-line (- defun-height))
		      (beginning-of-line)
		      (reposition-window))
	       (recenter (min ht comment-height)))))))


;; Return number of screen lines between START and END.

(defun sde-repos-count-lines (start end)
  (save-excursion
    (save-restriction
      (narrow-to-region start end)
      (goto-char (point-min))
      (vertical-motion (- (point-max) (point-min))))))


;; Return number of screen lines between START and END; returns a negative
;; number if END precedes START.

(defun sde-repos-count-lines-signed (start end)
  (let ((lines (sde-repos-count-lines start end)))
    (if (< start end)
	lines
	(- lines))))


;;;----------------------------------------------------------------------------
;;; 3.  Closing statements.
;;;----------------------------------------------------------------------------
