;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/flamingo/y/soar/projects/hucka/sde/RCS/sde-misc.el,v $
;;;; $Id: sde-misc.el,v 0.1 1994/06/15 20:28:42 hucka Exp $
;;;; 
;;;; Description       : Miscellaneous editing commands for SDE.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-misc-el-version "$Revision: 0.1 $"
  "The revision number of sde-misc.el.  The complete RCS id is:
      $Id: sde-misc.el,v 0.1 1994/06/15 20:28:42 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation.
;;;; 1.  Miscellaneous editing commands.
;;;; 2.  Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;; -----------------
;;; 0. Documentation.
;;; -----------------
;;;
;;; This file contains code for implementing various random editing commands
;;; in SDE; i.e., things that didn't fit well in other files.


;;;----------------------------------------------------------------------------
;;; 1.  Miscellaneous editing commands.
;;;----------------------------------------------------------------------------

(defun sde-close-all-sp (&optional arg) 
  "Insert enough parentheses to close the enclosing production.
If there are too many parens, excess parentheses are deleted.  The form
is also indented."
  (interactive "P")
  (let ((begin (sde-beginning-of-production 1 t))
	(end (sde-end-sp-text t))
	(count 0))
    (goto-char end)
    ;; Loop by going to the beginning, attempting to forward-sexp,
    ;; and inserting right parens until we get no more errors.
    (save-restriction
      (narrow-to-region (point) begin)
      (while (save-excursion
	       (progn (sde-beginning-of-production)
		      (condition-case nil
			  (progn (forward-sexp 1) nil)
			(error t))))
	(insert ?\))
	(setq count (1+ count)))
      ;; Delete the extra parens we inserted here.
      (unless (eq end (point))
	(delete-region end (point))))
    ;; Now insert the real parens.
    (goto-char end)
    (while (> count 0)
      (insert ?\))
      (setq count (1- count)))
    (goto-char begin)
    (sde-indent-sexp)
    (forward-sexp 1)))

;; Find unbalanced delimiters.
;; Originally from ilisp-ext.el by Chris McConnell.

(defun sde-find-unbalanced (arg)
  "Go to the point in buffer where there exists an extra delimiter.  
Point will be on the offending delimiter.  If called with a prefix, use the
current region.  Checks for '{' '}' and '(' ')' delimiters."
  (interactive "P")
  (if arg
      (call-interactively 'sde-find-unbalanced-region)
    (sde-find-unbalanced-region (point-min) (point-max))))

(defun sde-find-unbalanced-region (start end)
  "Go to the point in region where LEFT-DELIMITER and RIGHT-DELIMITER
become unbalanced.  Point will be on the offending delimiter."
  (interactive "r")
  (sde-count-pairs start end ?\{ ?\} )
  (sde-count-pairs start end ?\( ?\) )
  (beep)
  (message "Delimiters balance."))

(defun sde-count-pairs (begin end left-delimiter right-delimiter)
  "Return the number of top-level pairs of LEFT-DELIMITER and
RIGHT-DELIMITER between BEGIN and END.  If they don't match, the point
will be placed on the offending entry."
  (let ((old-point (point))
	(sexp 0))
    (goto-char begin)
    (sde-skip-chars end)
    (while (< (point) end)
      (let ((char (char-after (point))))
	(cond ((or (eq char left-delimiter)
		   ;; For things other than lists
		   (eq (char-after (1- (point))) ?\n))
	       (setq sexp (1+ sexp))
	       (condition-case ()
		   (progn (forward-sexp) nil)
		 (error 
		  (error "Extra %s" (char-to-string left-delimiter)))))
	      ((eq char right-delimiter)
	       (error "Extra %s" (char-to-string right-delimiter)))
	      ((< (point) end) (forward-char))))
      (sde-skip-chars end))
    (goto-char old-point)
    sexp))

;; Print information about the current file.
;; Originally based on functions from soar-mode v5.0.

(defun sde-region-count-productions (begin end)
  "Count the number of productions, lines & characters in the current region.
To count the productions in the whole buffer, first type `\\[mark-whole-buffer]'."
  (interactive "r")
  (when (interactive-p)
    (message "Counting soar productions..."))
  (let ((count 0)
	(lines (count-lines begin end)))
    (save-excursion
      (goto-char begin)
      (while (re-search-forward sde-sp-name-regexp end t)
	(setq count (1+ count))))
    (when (interactive-p)
      (message "%d production%s, %d line%s, %d character%s."
	       count (if (= count 1) "" "s")
	       lines (if (= lines 1) "" "s")
	       (- end begin) (if (= 1 (- end begin)) "" "s")))
    count))

;; Time/date stamps.  Based on some original code from a date.el that I
;; had written but never released.

(defconst sde-date-month-number
  '(("Jan" . 1) ("Feb" . 2) ("Mar" . 3) ("Apr" . 4) ("May" . 5) ("Jun" . 6)
    ("Jul" . 7) ("Aug" . 8) ("Sep" . 9) ("Oct" . 10) ("Nov" . 11) ("Dec" . 12))
  "Assoc list for looking up the month number from the month
abbreviation.")

(defun sde-insert-date-stamp (&optional arg)
  "Inserts the current date after point, in DD-MM-YY format.
With prefix argument, inserts the weekday first."
  (interactive)
  (let* ((s (current-time-string))
	 (day (substring s 0 3))
	 (month-name (substring s 4 7))
	 (date (if (equal ?\  (aref s 8)) ; Skip any leading space
		   (substring s 9 10)	;  in the day number.
		 (substring s 8 10)))
	 (year (substring s -4 nil)))
    (when current-prefix-arg
      (insert-before-markers (format "%s " day)))
    (insert-before-markers (format "%s-%s-%s" date month-name year))))


;;;----------------------------------------------------------------------------
;;; 2.  Closing statements.
;;;----------------------------------------------------------------------------
