;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-maint.el,v $
;;;; $Id: sde-maint.el,v 0.7 1994/06/23 20:05:13 hucka Exp $
;;;; 
;;;; Description       : SDE maintenance routines.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-maint-el-version "$Revision"
  "The revision number of sde-maint.el.  The complete RCS id is:
      $Id: sde-maint.el,v 0.7 1994/06/23 20:05:13 hucka Exp $")


;; Constants for detecting different Emacs versions.

(defconst sde-maint-running-lemacs
    (and (string-match "Lucid" emacs-version) t))

(defconst sde-maint-running-emacs19
    (and (string-match "\\`19" emacs-version) (not sde-maint-running-lemacs)))

;; Files in each list below need to be listed in the desired order of
;; compilation.

(defvar sde-maint-first-srcs
  '((sde-maint-running-emacs19 "sde-emacs19.el")
    (sde-maint-running-lemacs  "sde-lemacs.el")))

(defvar sde-maint-extra-srcs
  '((sde-maint-running-emacs19
     "header.el" "tagify.el" "easymenu.el" "powerkey.el" "conversion.el")
    (sde-maint-running-lemacs
     "header.el" "tagify.el" "conversion.el")))

(defvar sde-maint-core-srcs
  '("sde-basics.el" "sde-vars.el" "sde-data.el" "sde-version.el"
    "sde-compat.el" "sde-comment.el" "sde-feedback.el" "sde-find.el"
    "sde-first.el" "sde-header.el" "sde-help.el" "sde-indent.el" "sde-last.el"
    "sde-misc.el" "sde-next-match.el" "sde-repos.el" "sde-search.el"
    "sde-soar-mode.el" "sde-window-support.el"))

(defvar sde-maint-preload-srcs
  '("sde-first.el" "sde-vars.el" "sde-basics.el" "sde-data.el" "sde-version.el"))

;; Functions.

(defun sde-maint-compile-conditionally (cond-list)
  (while (not (eval (car (car cond-list))))
    (setq cond-list (cdr cond-list)))
  (if cond-list
      (mapcar 'sde-maint-compile-file (cdr (car cond-list)))))

(defun sde-maint-compile-file (file)
  (message "Compiling %s..." file)
  (byte-compile-file file))

(defun sde-maint-compile-distribution ()
  "Compile the files that come with SDE.
Usage: emacs -batch -q -l sde-maint -f sde-maint-compile-distribution"
  (interactive)
  (let* ((inhibit-local-variables nil)
	 (enable-local-variables nil)
	 (enable-local-eval nil)
	 (byte-compile-verbose t))
    (if (not (or sde-maint-running-emacs19 sde-maint-running-lemacs))
	(error "SDE will only function in GNU Emacs 19 or Lucid Emacs 19."))
    ;; Make sure we're in the right directory.
    (find-file "sde-version.el")
    (if (= (buffer-size) 0)
	(error "This command must be executed in the SDE source directory."))
    ;; Make sure current directory is in load-path.
    (setq load-path (cons default-directory load-path))
    ;; Compile files appropriately.
    ;; First the initial, version-specific set.
    (sde-maint-compile-conditionally sde-maint-first-srcs)
    ;; Now the main code.
    ;; First load the preload set.  This contains important macros & variables.
    (mapcar 'load-file sde-maint-preload-srcs)
    (mapcar 'sde-maint-compile-file sde-maint-core-srcs)
    ;; Last, the extras.  There's nothing to be done about warnings for the
    ;; extra packages included, since I'm not going to maintain them, so
    ;; quiet the compiler first.
    (setq byte-compile-warnings nil)
    (sde-maint-compile-conditionally sde-maint-extra-srcs)))    

;; Adapted from `print-autoloads' from VM 5.72.

(defun sde-maint-print-autoloads ()
  (let ((enable-local-variables t)
	(enable-local-eval t)
	(files sde-maint-core-srcs)
	;; Kludge for broken v19 emacs.  It's supposed to accept t in
	;; autoloads to mean 'macro but it doesn't.  This kludge will screw
	;; people who try to byte-compile VM with emacs18 for emacs19.
	(macro-flag (if (string-match "^19" emacs-version) ''macro t))
	file sexp function doc interactive macro)
    (while files
      (if (member (car files) sde-maint-preload-srcs)
	  ;; Skip this -- it's preloaded. 
	  (setq files (cdr files))
	;; Do this file.
	(set-buffer (find-file-noselect (car files)))
	(goto-char (point-min))
	(condition-case nil
	    (while t
	      (setq sexp (read (current-buffer)))
	      (if (and (consp sexp) (cdr sexp)
		       (or (eq (car sexp) 'defun)
			   (eq (car sexp) 'defmacro)))
		  (progn
		    (if (eq (car sexp) 'defmacro)
			(setq macro macro-flag)
		      (setq macro nil))
		    (setq sexp (cdr sexp)
			  function (car sexp)
			  sexp (cdr (cdr sexp)))
		    (if (stringp (car sexp))
			(setq doc (car sexp)
			      sexp (cdr sexp))
		      (setq doc nil))
		    (if (and (consp (car sexp))
			     (eq (car (car sexp)) 'interactive))
			(setq interactive t)
		      (setq interactive nil))
		    (if (string-match "\.el$" (car files))
			(setq file (substring (car files) 0 -3))
		      (setq file (car files)))
		    (print (list 'autoload (list 'quote function) file
				 doc interactive macro)))))
	  (end-of-file nil))
	(kill-buffer (current-buffer))
	(setq files (cdr files))))))
