;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-last.el,v $
;;;; $Id: sde-last.el,v 0.2 1994/06/22 08:56:14 hucka Exp $
;;;; 
;;;; Description       : Final statements, performed last in loading SDE.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-final-el-version "$Revision: 0.2 $"
  "The revision number of sde-final.el.  The complete RCS id is:
      $Id: sde-last.el,v 0.2 1994/06/22 08:56:14 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation.
;;;; 1.  Main code.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;; ------------------
;;; 0.  Documentation.
;;; ------------------
;;;
;;; This file contains code that is executed last during the loading of SDE.


;;;----------------------------------------------------------------------------
;;; 1.  Main code.
;;;----------------------------------------------------------------------------

;; Load menu, mouse, font & color support if we're running in a windowing env.

(when window-system
  (require 'sde-window-support))

;; Attempt to load site-specific file.  If it doesn't exist, don't complain.

(load "sde-site.el" 'failure-ok)

;; Provide now, in case user's code checks this.

(provide 'sde)

;; Run user hooks.

(run-hooks 'sde-site-hook)
(run-hooks 'sde-load-hook)

;; Set up the file extensions which invoke soar-mode.  The variable
;; `sde-file-types-regexp-list' contains the list of file suffixes.  If you
;; wish to add to this list, do a setq of `sde-file-types-regexp-list' prior
;; to loading this file.  (For example, you can do this in the site-hook or
;; load-hook.)

(mapcar (function (lambda (suffix)
		    (unless (assoc suffix auto-mode-alist)
		      (setq auto-mode-alist (cons (cons suffix 'sde-mode)
						  auto-mode-alist)))))
	sde-file-types-regexp-list)
