;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-first.el,v $
;;;; $Id: sde-first.el,v 0.1 1994/06/17 06:31:12 hucka Exp $
;;;; 
;;;; Description       : First file loaded into sde.elc.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-first-el-version "$Revision: 0.1 $"
  "The revision number of sde-first.el.  The complete RCS id is:
      $Id: sde-first.el,v 0.1 1994/06/17 06:31:12 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation
;;;; 1.  Core code.
;;;; 2.  Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;;-------------------
;;; 0.  Documentation.
;;;-------------------
;;;
;;; The main SDE compiled binary file, sde.elc, is constructed by
;;; concatenating several files together and including autoload statements
;;; for functions not included directly in sde.elc.  This file is the
;;; first file included in sde.elc.  It contains important set-up code
;;; that needs to appear first in sde.elc.


;;;----------------------------------------------------------------------------
;;; 1.  Core code.
;;;----------------------------------------------------------------------------

;; Fabulous hack to figure out where this file is located and add that
;; directory to the load-path.  This allows users simply to issue a
;;      (load "/foo/bar/soar")
;; and automatically get the /foo/bar directory added to their load-path if
;; it's not in load-path already.  Algorithm: look at where this file is
;; being loaded from, look at load-path, and if the current directory isn't
;; on load-path, add it.
;;
;; sde-directory is based on original code from Andy Norman:
;;
;;   From: Andy Norman <ange@hplb.hpl.hp.com>
;;   To: hucka@engin.umich.edu
;;   Subject: Re: How to get path info during load? 
;;   Date: Tue, 28 Jan 92 10:40:28 GMT

(defvar sde-directory nil
  "Directory contain SDE's files.")

(defun sde-directory ()
  "Guess the directory of the file currently being loaded, or return nil."
  (let* ((buf (get-buffer-create " *backtrace*"))
	 (standard-output buf)
	 file)
    (condition-case nil
	(save-excursion
	  (set-buffer buf)
	  (erase-buffer)
	  (backtrace)
	  (goto-char (point-min))
	  (if (re-search-forward "load(\"\\([^\"]+\\)\"" nil t)
	      (setq file (buffer-substring (match-beginning 1) (match-end 1))))
	  (kill-buffer buf))
      (error nil))
    (if (and file (file-name-directory file))
	(directory-file-name (file-name-directory file)))))

;; Now hack user's load-path if necessary.

(let ((path (sde-directory)))
  (if (null path)
      ;; Directory must be on load-path already & user did (load "sde").
      ;; Search for sde.el in one of the load-path directories. 
      (let ((lpath load-path))
	(while (and lpath
		    (not (file-exists-p (expand-file-name "sde-version.el" (car lpath)))))
	  (setq lpath (cdr lpath)))
	(if lpath
	    (setq sde-directory (car lpath))))
    ;; Found a dir in the load stmt.  Add to load-path if not there already.
    (setq sde-directory path)
    (if (not (member sde-directory load-path))
	(setq load-path (cons path load-path)))))

;; Requirements.  

(require 'cl)				; Common Lisp extensions for Emacs.
(require 'cl-19)			; Insures we get the correct version.

(eval-when (eval load compile)
  (when (string-lessp emacs-version "19")
    (error "SDE will only work in GNU Emacs 19 or Lucid Emacs 19.")))

(eval-when (eval load compile)
  (when window-system
    (require 'mouse))
  (cond ((string-match "Lucid" emacs-version)
	 (require 'sde-lemacs))
	((not (string-lessp emacs-version "19"))
	 (require 'sde-emacs19))))


;;;----------------------------------------------------------------------------
;;; 2.  Closing statements.
;;;----------------------------------------------------------------------------
