;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-emacs19.el,v $
;;;; $Id: sde-emacs19.el,v 0.12 1994/06/22 08:51:44 hucka Exp $
;;;; 
;;;; Description       : Functions specific to GNU Emacs 19.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-emacs19-el-version "$Revision: 0.12 $"
  "The revision number of sde-emacs19.el.  The complete RCS id is:
      $Id: sde-emacs19.el,v 0.12 1994/06/22 08:51:44 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation
;;;; 1.  Requirements and miscellaneous setup.
;;;; 2.  Window and frame/screen handling functions.
;;;; 3.  Misc. functions.
;;;; 4.  Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;; -----------------
;;; 0.  Documentation
;;; -----------------
;;;
;;; The purpose of this file is to hide differences between different Emacs
;;; versions and to implement menus in Emacs 19.
;;;
;;; Window and frame handling functions have different names in GNU Emacs 19
;;; and Lucid Emacs 19.  To avoid testing at run-time the version of Emacs,
;;; SDE uses a common set of names for the functions, and their actual
;;; implementation is left to this file and other files such as
;;; sde-lemacs.el.  For example, the equivalent of `frame-list' is named
;;; `screen-list' in Lucid Emacs 19.  To hide this, we have SDE code refer
;;; to `sde-frame-list' throughout, then define `sde-frame-list' to be just
;;; `frame-list' in this file and `screen-list' in sde-lemacs.el.  The main
;;; file (sde.el) only has to test the version of Emacs once and load the
;;; appropriate file.
;;;
;;; The drawback to this approach is that the definitions of many functions
;;; are split across multiple files.


;;;----------------------------------------------------------------------------
;;; 1.  Requirements and miscellaneous setup.
;;;     Do not modify these.
;;;----------------------------------------------------------------------------

;; Requirements

(eval-when-compile
  (require 'cl)
  (require 'faces))

;; Provide is at the end.


;;;----------------------------------------------------------------------------
;;; 2.  Window and frame/screen handling functions.
;;;----------------------------------------------------------------------------

;; These have different names in Lucid Emacs 19, but are functionally identical

(defalias 'sde-frame-root-window 'frame-root-window)
(defalias 'sde-frame-list 'frame-list)
(defalias 'sde-window-frame 'window-frame)
(defalias 'sde-selected-frame 'selected-frame)
(defalias 'sde-select-frame 'select-frame)
(defalias 'sde-raise-frame 'raise-frame)
(defalias 'sde-delete-frame 'delete-frame)
(defalias 'sde-make-frame-visible 'make-frame-visible)
(defalias 'sde-frame-live-p 'frame-live-p)
(defalias 'sde-frame-p 'framep)
(defalias 'sde-frame-width 'frame-width)
(defalias 'sde-set-window-dedicated-p 'set-window-dedicated-p)

;; This takes different arguments in different Emacses.

(defmacro sde-next-window-any (window &optional all-frames)
  "Return next window after WINDOW.  Consider any frame if ALL-FRAMES."
  (` (next-window (, window) 'no-mini (, all-frames))))

(defun sde-window-list (&optional all-frames)
  "Return a list of all windows excluding the minibuffer's windows.  
If optional arg ALL-FRAMES is non-nil, also lists windows on other
frames, including invisible and iconified frames."
  ;; Emacs 19.22's get-buffer-window completely ignores invisible windows,
  ;; so we have to do this the hard way.
  (let* ((first (selected-window))
	 (current first)
	 (windows nil))
    (while (progn
	     (setq windows (cons current windows)
		   current (sde-next-window-any current all-frames))
	     (not (eq current first))))
    windows))

(defun sde-buffer-window (buffer &optional all-frames)
  "Return a window in which BUFFER is shown, or return nil.
In Emacs 19 variants, all visible screens are searched, and if optional arg
ALL-FRAMES is non-nil, then even invisible and iconified screens
are searched."
  (if (bufferp buffer)
      (or (get-buffer-window buffer t)
	  (and all-frames
	       ;; Look in invisible frames.
	       ;; get-buffer-window in 19.22 doesn't let you specify
	       ;; invisible and iconified frames; must search manually.
	       (let ((windows (sde-window-list t)))
		 (while (and windows
			     (not (eq (window-buffer (car windows)) buffer)))
		   (setq windows (cdr windows)))
		 (car windows))))))

(defun sde-buffer-frame (buffer &optional all-frames)
  "Return the frame object in which buffer is being shown, or return nil.
If optional arg ALL-FRAMES is non-nil, consider all frames/screens, including
invisible ones.  This function only works in FSF Emacs 19 and Lucid Emacs 19\;
in Emacs 18 it returns nil."
  (if (bufferp buffer)
      ;; Emacs bug: window-frame in 19.22 will error if given nil.
      (let ((window (sde-buffer-window buffer all-frames)))
	(and window (window-frame window)))))

(defun sde-make-frame (buffer &optional params)
  ;; Internal function to hide differences in Emacs versions.  Create a
  ;; frame/screen for buffer
  (funcall 'make-frame params))

(defun sde-make-face-bold (face &optional screen no-error)
  (make-face-bold face screen no-error))

(defun sde-make-face-italic (face &optional screen no-error)
  (make-face-italic face screen no-error))

(defun sde-make-face-bold-italic (face &optional screen no-error)
  (make-face-bold-italic face screen no-error))


;;;----------------------------------------------------------------------------
;;; 3.  Misc. functions.
;;;----------------------------------------------------------------------------

;; This took different arguments in Emacs 19.22 and 19.24+.

(if (boundp 'emacs-minor-version)	; Absent up through 19.22.
    (defalias 'sde-where-is-internal 'where-is-internal)
  ;; Else, define a version that takes args like the 19.24 version.
  (defun sde-where-is-internal (definition &optional keymap firstonly noindirect)
    "Return list of keys that invoke DEFINITION.
If KEYMAP is non-nil, search only KEYMAP and the global keymap.
If KEYMAP is nil, search all the currently active keymaps.

If optional 3rd arg FIRSTONLY is non-nil, return the first key sequence found,
rather than a list of all possible key sequences.
If FIRSTONLY is t, avoid key sequences which use non-ASCII
keys and therefore may not be usable on ASCII terminals.  If FIRSTONLY
is the symbol `non-ascii', return the first binding found, no matter
what its components.

If optional 4th arg NOINDIRECT is non-nil, don't follow indirections
to other keymaps or slots.  This makes it possible to search for an
indirect definition itself."
    (where-is-internal definition keymap firstonly noindirect)))

;; Functions for handling text properties. 

(defun sde-insert-faced (face &rest args)
  ;; Insert text with given face.
  (if window-system
      (let ((start (point)))
	(apply 'insert args)
	(put-text-property start (point) 'face face))
    (apply 'insert args)))


;;;----------------------------------------------------------------------------
;;; 4.  Closing statements.
;;;----------------------------------------------------------------------------

;; Provide.

(provide 'sde-emacs19)
