;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/flamingo/y/soar/projects/hucka/sde/RCS/sde-comment.el,v $
;;;; $Id: sde-comment.el,v 0.1 1994/06/15 20:16:10 hucka Exp $
;;;; 
;;;; Description       : Comment support for editing Soar programs.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993, 1994 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;
;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1994 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.50:      Copyright (C) 1991-1994 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; VM 5.72:        Copyright (C) 1989-1994 Kyle E. Jones
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-comment-el-version "$Revision: 0.1 $"
  "The revision number of sde-comment.el.  The complete RCS id is:
      $Id: sde-comment.el,v 0.1 1994/06/15 20:16:10 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation.
;;;; 1.  Functions for comment support.
;;;; 2.  Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;; -----------------
;;; 0. Documentation.
;;; -----------------
;;;
;;; This file contains code for implementing special commands for dealing
;;; with comments in Soar code.  At present this is fairly simple, consisting
;;; only of a function that lets the user comment out or uncomment regions of
;;; code.  (This is in addition to the standard Emacs comment commands such
;;; as `M-;'.)


;;;----------------------------------------------------------------------------
;;; 1.  Functions for comment support.
;;;----------------------------------------------------------------------------

;; Comment out regions.
;; Originally from ilisp-ext.el by Chris McConnell.

(defvar sde-comment-marker (make-marker) ; Declare global to avoid calling
  "Marker for end of a comment region.") ;  make-marker repeatedly.

(defun sde-region-comment (start end prefix)
  "If prefix is positive, insert prefix copies of `comment-start' at the
start and `comment-end' at the end of each line in region.  If prefix is
negative, remove all `comment-start' and `comment-end' strings from the
region."
  (interactive "r\np")
  (save-excursion
    (goto-char end)
    (if (and (/= start end) (bolp))
	(setq end (1- end)))
    (goto-char end)
    (beginning-of-line)
    (set-marker sde-comment-marker (point))
    (untabify start end)
    (goto-char start)
    (beginning-of-line)
    (let* ((count 1)
	   (comment comment-start)
	   (comment-end (if (not (equal comment-end "")) comment-end)))
      (if (> prefix 0)
	  (progn
	    (while (< count prefix)
	      (setq comment (concat comment-start comment)
		    count (1+ count)))
	    (while (<= (point) sde-comment-marker)
	      (beginning-of-line)
	      (insert comment)
	      (if comment-end (progn (end-of-line) (insert comment-end)))
	      (forward-line 1)))
	  (setq comment (concat comment "+"))
	  (while (<= (point) sde-comment-marker)
	    (back-to-indentation)
	    (if (looking-at comment) (replace-match ""))
	    (if comment-end
		(progn
		  (re-search-backward comment-end)
		  (replace-match "")))
	    (forward-line 1)))
      (set-marker sde-comment-marker nil))))


;;;----------------------------------------------------------------------------
;;; 2.  Closing statements.
;;;----------------------------------------------------------------------------
