;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-lemacs.el,v $
;;;; $Id: sde-lemacs.el,v 0.1 1994/03/10 07:15:52 hucka Exp $
;;;; 
;;;; Description       : Functions specific to Lucid Emacs 19.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1993 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.46:      Copyright (C) 1991-1992 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-lemacs-el-version "$Revision: 0.1 $"
  "The revision number of sde-lemacs.el.  The complete RCS id is:
      $Id: sde-lemacs.el,v 0.1 1994/03/10 07:15:52 hucka Exp $")


;;;----------------------------------------------------------------------------
;;; 1.  Require, provide, and miscellaneous setup.
;;;     Do not modify these.
;;;----------------------------------------------------------------------------

;; Provide.

(provide 'sde-lemacs)


;;;----------------------------------------------------------------------------
;;; 2. Window and frame/screen handling functions.
;;;----------------------------------------------------------------------------


(defmacro defalias-sde (newname oldname)
  "Set NEWNAME's function definition to OLDNAME, and return OLDNAME.
In Emacs 19, associates the function with the current load file, if any."
  (` (defalias (, newname) (, oldname))))


(defalias-sde 'sde-frame-root-window 'screen-root-window)
(defalias-sde 'sde-frame-list 'screen-list)
(defalias-sde 'sde-window-frame 'window-screen)
(defalias-sde 'sde-selected-frame 'selected-screen)
(defalias-sde 'sde-select-frame 'select-screen)
(defalias-sde 'sde-raise-frame 'raise-screen)
(defalias-sde 'sde-delete-frame 'delete-screen)
(defalias-sde 'sde-make-frame-visible 'make-screen-visible)
(defalias-sde 'sde-frame-live-p 'live-screen-p)
(defalias-sde 'sde-frame-p 'screenp)


(defmacro sde-next-window-any (window &optional all-frames)
  ;; Return next window after WINDOW.  Consider any frame if ALL-FRAMES.
  ;; This is an internal macro to hide differences between versions of Emacs.
  (` (next-window (, window) 'no-mini (, all-frames) (, all-frames))))


(defun sde-set-window-dedicated-p (window dedicated)
  ;; Doesn't work for Lucid currently.
  )


(defun sde-buffer-window (buffer &optional all-frames)
  "Return a window in which BUFFER is shown, or return nil.
In Emacs 19 variants, all visible screens are searched, and if optional arg
ALL-FRAMES is non-nil, then even invisible and iconified screens
are searched."
  (get-buffer-window buffer t all-frames))  


(defun sde-buffer-frame (buffer &optional all-frames)
  "Return the frame object in which buffer is being shown, or return nil.
If optional arg ALL-FRAMES is non-nil, consider all frames/screens, including
invisible ones.  This function only works in FSF Emacs 19 and Lucid Emacs 19\;
in Emacs 18 it returns nil."
  (if (bufferp buffer)
      ;; Emacs bug: window-frame in 19.22 will error if given nil.
      (let ((window (sde-buffer-window buffer all-frames)))
	(and window (sde-window-frame window)))))


(defun sde-make-frame (buffer &optional params)
  ;; Internal function to hide differences in Emacs versions.  
  ;; Create a frame/screen for buffer
  (let ((sc (funcall screen-creation-func params)))
    (select-screen sc)
    (make-screen-visible sc)
    (switch-to-buffer buffer)
    sc))


(defun sde-make-face-bold (face &optional screen no-error)
  (make-face-bold face screen))


(defun sde-make-face-italic (face &optional screen no-error)
  (make-face-italic face screen))


(defun sde-make-face-bold-italic (face &optional screen no-error)
  (make-face-bold-italic face screen))


;;;----------------------------------------------------------------------------
;;; 3. Menu handling.
;;;
;;; Strictly speaking, this doesn't have to be among first the things defined
;;; for SDE, but since it doesn't depend on other code, it may as well be put
;;; here because it's Emacs-version-specific.
;;;----------------------------------------------------------------------------

;; Defines for the compiler.  These are actually found elsewhere.

(defvar sde-soar-agents)
(defvar sde-source-modes)
(defvar sde-soar-modes)
(defvar sde-mode-map)
(defvar sde-soar-version-at-least-6-1-1)

;; The following variables are set by `sde-menu-set-vars', which is attached
;; to the Lucid `activate-menubar-hook' that gets called before a menubar
;; menu is pulled down.  The intent here is to cache values that are used to
;; disable menu items based on different conditions.  I think this must be
;; faster that to repeatedly test the conditions directly in the menu item
;; definitions.

(defvar sde-menu-soar-ok nil)
(defvar sde-menu-version-ok nil)
(defvar sde-menu-region-ok nil)
(defvar sde-menu-agents-ok nil)

(defun sde-menu-set-vars ()
  ;; Intented to be called by the activate-menubar-hook.
  (setq sde-menu-soar-ok    (sde-soar-is-alive)
	sde-menu-region-ok  (and sde-menu-soar-ok
				 (memq major-mode sde-source-modes)))
  (if (featurep 'sde-soar-mode)
      (setq sde-menu-version-ok (and sde-menu-soar-ok
				     sde-soar-version-at-least-6-1-1)
	    sde-menu-agents-ok  (and sde-menu-soar-ok sde-soar-agents))
      (setq sde-menu-version-ok nil
	    sde-menu-agents-ok nil))
  nil)


(defvar sde-mode-menus
  '("SDE"
    ("Soar"
     ["Start Soar"        soar                 (not sde-menu-soar-ok)]
     ["Interrupt Soar"    sde-interrupt-soar     sde-menu-soar-ok]
     ["Go"                go                     sde-menu-soar-ok]
     ["Run"               run                    sde-menu-soar-ok]
     ["Schedule"          schedule 	         sde-menu-soar-ok]
     "-----"
     ["Init Soar"         init-soar 	         sde-menu-soar-ok]
     ["Reset"             reset    	         sde-menu-version-ok]
     "-----"
     ["Load file..."      load-soar              sde-menu-soar-ok]
     ["Load default productions" load-defaults   sde-menu-soar-ok]
     "-----"
     ["Explain on"        explain-on             sde-menu-version-ok]
     ["Explain off"       explain-off            sde-menu-version-ok]
     ["Load errors on"    load-errors-on         sde-menu-version-ok]
     ["Load errors off"   load-errors-off        sde-menu-version-ok])

    ("Production"
     ["Send production"   sde-send-production    sde-menu-soar-ok]
     ["Send region"       sde-region-send        sde-menu-soar-ok]
     "-----"
     ["Excise production" excise                 sde-menu-soar-ok]
     ["Excise region"     sde-region-excise      sde-menu-region-ok]
     ["Excise file..."    excise-file            sde-menu-soar-ok]
     ["Excise task"       excise-task            sde-menu-soar-ok]
     ["Excise chunks"     excise-chunks          sde-menu-soar-ok]
     ["Excise all"        excise-all             sde-menu-soar-ok]
     "-----"
     ["Ptrace production" ptrace                 sde-menu-soar-ok]
     ["Ptrace region"     sde-region-ptrace      sde-menu-region-ok]
     "-----"
     ["Pbreak production" pbreak                 sde-menu-soar-ok]
     ["Pbreak region"     sde-region-pbreak      sde-menu-region-ok]
     "-----"
     ["Find production"   sde-find-production t]
     ["Find next occurrence" sde-find-next-production t])

    ("Query"
     ["Print"             print-soar	         sde-menu-soar-ok]
     ["Matches"           matches	         sde-menu-soar-ok]
     ["Matches 1"         matches-1	         sde-menu-soar-ok]
     ["Matches 2"         matches-2	         sde-menu-soar-ok]
     ["Preferences"       preferences	         sde-menu-soar-ok]
     ["Explain"           explain	         sde-menu-version-ok]
     ["Wm"                wm		         sde-menu-soar-ok]
     ["Firing-counts"     firing-counts	         sde-menu-soar-ok]
     "-----"
     ["View ptraces"      sde-view-ptraces       sde-menu-soar-ok]
     ["View pbreaks"      sde-view-pbreaks       sde-menu-soar-ok]
     ["View goal stack (pgs)" sde-view-pgs       sde-menu-soar-ok]
     ["View operator stack (pgso)" sde-view-pgso sde-menu-soar-ok]
     ["View match set (ms)" sde-view-ms	         sde-menu-soar-ok]
     ["View chunks"       sde-view-chunks        sde-menu-soar-ok]
     ["View productions"  sde-view-productions   sde-menu-soar-ok]
     ["View justifications" sde-view-justifications sde-menu-soar-ok]
     ["View working memory" sde-view-working-memory sde-menu-soar-ok]
     ["View Soar stats"   sde-view-stats         sde-menu-soar-ok])

    ("Agent"
     ["Create agent..."   create-agent           sde-menu-agents-ok]
     ["Select agent..."   select-agent           sde-menu-agents-ok]
     ["Set agent go..."   agent-go               sde-menu-agents-ok]
     ["Destroy agent..."  destroy-agent          sde-menu-agents-ok]
     ["List agents"       list-agents            sde-menu-agents-ok]))
  "The menu for SDE Mode.")

(defvar sde-soar-mode-menus 
  '("In/Out"
    ["Previous input"            sde-previous-input t]
    ["Next input"                sde-next-input t]
    ["Complete based on history" sde-previous-similar-input t]
    ["Search input history..."   sde-previous-input-matching t]
    "-----"
    ["Erase last word typed"     backward-kill-word t]
    ["Erase whole input"         sde-kill-input t]
    ["Show last output"          sde-show-output t]
    ["Erase last output"         sde-kill-output t]
    "-----"
    ["Jump to previous prompt"   sde-backward-prompt t]
    ["Jump to next prompt"       sde-forward-prompt t])
  "Additional menus for SDE Soar Mode.")

(defvar sde-help-menus
  '("SDE"
    ["Help on SDE Mode"          sde-describe-mode t]
    ["List SDE bindings"         sde-describe-bindings t]
    "-----"
    ["SDE Apropos..."            sde-apropos t]
    ["SDE/Soar Topic..."         sde-topic-help t]
    "-----"
    ["SDE Manual"                sde-info t]
    ["Soar Manual"               sde-soar-info t]
    ["Soar Release Notes"        sde-soar-release-notes t]
    ["Soar User Notes"           sde-soar-user-notes t])
  "Help menu additions for SDE Mode.")
    

(defun sde-define-menus (mode map)
  "Define menus as appropriate for MODE on keymap MAP."
  (sde-define-sde-mode-menus)
  (if (memq mode sde-soar-modes)
      (progn
	(sde-define-soar-mode-menus)
	(define-key sde-mode-map 'button3 'sde-mode-menu)))
  (add-hook 'activate-menubar-hook 'sde-menu-set-vars)
  (define-key sde-mode-map 'button3 'sde-mode-menu))


(defun sde-define-sde-mode-menus ()
  "Defines pull-down menus for SDE Mode in Lucid Emacs 19.
This assumes it is called in the buffer for which the menus are to be
defined by the mode function."
  (or current-menubar
      (set-menubar default-menubar))
  (set-buffer-menubar (copy-sequence current-menubar))
  (add-menu nil (car sde-mode-menus) (cdr sde-mode-menus))
  (add-menu '("Help") (car sde-help-menus) (cdr sde-help-menus)))


(defun sde-define-soar-mode-menus ()
  "Defines pull-down menus for SDE Soar Mode in Lucid Emacs 19.
This assumes it is called in the buffer for which the menus are to be
defined by the mode function."
  ;; This only needs to append additional SDE Soar Mode-specific items.
  ;; `sde-mode-build-lemacs-menu' will have been called already.
  (or current-menubar
      (set-menubar default-menubar))
  (add-menu '("SDE") (car sde-soar-mode-menus) (cdr sde-soar-mode-menus)))


;;;----------------------------------------------------------------------------
;;; 4. Pop-up menu support.
;;;----------------------------------------------------------------------------

(defun sde-mode-menu (e)
  (interactive "e")
  (mouse-set-point e)
  (popup-menu sde-mode-menus))


;;;----------------------------------------------------------------------------
;;; 5. Closing statements.
;;;----------------------------------------------------------------------------
