;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-highlight.el,v $
;;;; $Id: sde-highlight.el,v 0.5 1994/03/10 07:15:34 hucka Exp $
;;;; 
;;;; Description       : Font and color support for SDE
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:       Copyright (C) 1985-1993 Free Software Foundation, Inc.
;;;; Soar-mode 5.0    Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:      Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.46:       Copyright (C) 1991-1992 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25    Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:     Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu

(defconst sde-highlight-el-version "$Revision: 0.5 $"
  "The revision number of sde-menus.el.  The complete RCS id is:
      $Id: sde-highlight.el,v 0.5 1994/03/10 07:15:34 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation
;;;; 1.  Require, provide, and miscellaneous setup.
;;;; 2.  Global parameters and configuration variables
;;;; 3.  Internal constants and variables
;;;; 4.  Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;;; ----------------
;;;; 0. Documentation
;;;; ----------------



;;;-----------------------------------------------------------------------------
;;; 1.  Require, provide, and miscellaneous setup.
;;;     Do not modify these.
;;;-----------------------------------------------------------------------------

;; Requirements.

(require 'sde)

;; Provide.

(provide 'sde-highlight)


;;;-----------------------------------------------------------------------------
;;; 2.  Global parameters and configuration variables
;;;
;;; Users may wish to customize the values of these symbols, by resetting their
;;; values via setq in their .emacs files.
;;;-----------------------------------------------------------------------------

;; For font-lock.el, available in both FSF Emacs 19 and Lucid Emacs 19.

(defvar sde-font-lock-list '(names)
  "*List of production elements to highlight using the font-lock package.
In addition to the regular font-lock faces, this list determines which
production elements will be displayed in different faces when font locking is
turned on.  The font-lock package automatically highlights comments and
strings using the two faces

    font-lock-comment-face
    font-lock-string-face

\(See the documentation for `font-lock-mode' for more information.)
`sde-font-lock-list' is a list containing symbols that indicate which
production elements, in addition to comments and strings, should be
highlighted in SDE mode.  It can contain only the following symbols:

    names	-- highlight names of productions
    variables	-- highlight variables
    attributes	-- highlight attributes
    values	-- highlight values of attributes
    flags	-- highlight the production flag (e.g., \":o-support\", etc.)

By default this list contains only '(names), which means to highlight just
production names.  You can change this by setting the value of this variable
to a new list in your .emacs file.  For example, to highlight names and
variables, use 

    (setq sde-font-lock-list '(names variables))

The font lock faces corresponding to the different production elements are:

    sde-names-face	 -- the face used for \"names\"
    sde-variables-face	 -- the face used for \"variables\"
    sde-attributes-face	 -- the face used for \"attributes\"
    sde-values-face	 -- the face used for \"values\"
    sde-flags-face	 -- the face used for \"flags\"

By default, only the faces `sde-names-face' and `sde-flags-face' are set to
something other than the Emacs default face.  You may set their
characteristics to your liking in your ~/.emacs file.  Here are the Emacs
commands available for this (where FACE is one of sde-names-face,
sde-variables-face, etc.):

    (set-face-font FACE \"font\")         -- set font
    (set-face-foreground FACE \"color\")  -- set foreground color
    (set-face-background FACE \"color\")  -- set background color
    (set-face-underline-p FACE t/nil)     -- make face underlined or not
    (invert FACE)                         -- swap foreground & background
    (make-face-bold FACE)                 -- use the bold version of the font
    (make-face-italic FACE)               -- use the italic version
    (make-face-bold-italic FACE)          -- use the bold italic version
    (make-face-unbold FACE)               -- turn off bold facing
    (make-face-unitalic FACE)             -- turn off italic

For example, if you wanted to make SDE highlight both production names and
attributes using font lock, and make attributes be underlined, you could put
the following in your ~/.emacs after loading SDE:

    (setq sde-font-lock-list '(names attributes))
    (set-face-underline-p sde-attributes-face t)

Remember that to turn on font locking, you must invoke `font-lock-mode'.  To
make SDE font lock all Soar buffers, add this to your ~/.emacs:

    (add-hook 'sde-mode-hook '(lambda () (font-lock-mode 1)))
    (add-hook 'sde-soar-mode-hook '(lambda () (font-lock-mode 1)))
    (add-hook 'sde-soar-output-mode-hook '(lambda () (font-lock-mode 1)))

Beware that when font-lock is turned on, the *first* time you visit a
particular file in Emacs, it will take some time to perform the highlighting.
The more elements you put on `sde-font-lock-list', the longer it will take
for Emacs to \"fontify\" your code initially, so use this feature sparingly.
Once the initial highlighting is finished, editing does not suffer a
significant slowdown.

To find out about the color names available for your X Window System,
read the file /usr/lib/X11/rgb.txt.  Alternatively, you can use a hexadecimal
number to specify a color\; to learn about this, read the man page for \"X\",
which includes a section on colors in X Windows.  You can easily read the
manual page using the `M-x man' command in Emacs.

Beware that for GNU Emacs 19, it is best to use fixed-width fonts.  To
find out which fixed-width fonts are available on your computer system,
run the following commands in a Unix shell:

     xlsfonts -fn '*x*'
     xlsfonts -fn '*-*-*-*-*-*-*-*-*-*-*-m*'
     xlsfonts -fn '*-*-*-*-*-*-*-*-*-*-*-c*'

\(Note: on some machines these commands seem to freeze the window server
for a few seconds while they execute -- patience is required here.)")

;; Create faces in a way hopefully compatible with both Lucid and FSF Emacs.
;; This bizarre combination of setting the variables to the symbols and
;; doing make-face on the symbols works, but I'm not sure why.

(defvar sde-names-face 'sde-names-face
  "Face to use for production names.")

(defvar sde-variables-face 'sde-variables-face
  "Face to use for production variables.")

(defvar sde-attributes-face 'sde-attributes-face
  "Face to use for attributes in production clauses.")

(defvar sde-values-face 'sde-values-face
  "Face to use for attribute values in production clauses.")

(defvar sde-flags-face 'sde-flags-face
  "Face to use for production flags.")

(defvar sde-soar-prompt-face 'sde-soar-prompt-face
  "Face to use to highlight the prompt in Soar process buffers.")

(defvar sde-soar-output-buffer-title-face 'sde-soar-output-buffer-title-face 
  "Face to use to highlight title lines in the Soar *output* buffer.")

(make-face 'sde-names-face)
(make-face 'sde-variables-face)
(make-face 'sde-attributes-face)
(make-face 'sde-values-face)
(make-face 'sde-flags-face)
(make-face 'sde-soar-prompt-face)
(make-face 'sde-soar-output-buffer-title-face)

;; Defaults

(condition-case nil
    (or (face-differs-from-default-p sde-names-face)
	(sde-make-face-bold sde-names-face nil t))
  (error nil))

(condition-case nil
    (or (face-differs-from-default-p sde-flags-face)
	(sde-make-face-bold sde-flags-face nil t))
  (error nil))

(condition-case nil
    (or (face-differs-from-default-p sde-soar-prompt-face)
	(sde-make-face-bold sde-soar-prompt-face nil t))
  (error nil))

(condition-case nil
    (or (face-differs-from-default-p sde-soar-output-buffer-title-face)
	(sde-make-face-bold-italic sde-soar-output-buffer-title-face nil t)
	(sde-make-face-italic sde-soar-output-buffer-title-face nil t))
  (error nil))


;;;-----------------------------------------------------------------------------
;;; 3.  Internal constants and variables.
;;;-----------------------------------------------------------------------------


(defvar sde-font-lock-possible-values '(names flags variables values attributes)
  "Possible contents of the list `sde-font-lock-list'.")

(defvar sde-font-lock-handlers-alist
  '((names      ("[^<]\\<\\(\\(\\sw\\|\\s_\\)+\\*+\\(\\sw\\|\\s_\\|\\*\\)*\\|chunk-[0-9]+\\|justification-[0-9]+\\)\\>"
		 . sde-names-face))
    (variables  ("<[^ \t\n\)>]+>" . sde-variables-face))
    (attributes ("\\^\\([^ \t\n]+\\)" 1 sde-attributes-face))
    (values     ("\\^[^ \t\n]+[ \t]+\\([^^\)\n]+\\)" 1 sde-values-face))
    (flags      ("\\(:default\\|:o-support\\|:no-o-support\\|:chunk\\)" . sde-flags-face))))


;;;-----------------------------------------------------------------------------
;;; 4.  Font locking.
;;;-----------------------------------------------------------------------------

(defvar font-lock-keywords)		; For the compiler.

(defun sde-font-lock-mode-hook ()
  "Mode hook for setting font-lock-keywords appropriate for SDE buffers."
  (if (memq major-mode sde-modes)
      ;; This code is a little strange because we have to insure that the
      ;; elements on the font-lock-keywords list appear in the proper order.
      ;; So instead of looping over sde-font-lock-list, we loop over a list
      ;; that contains all possible values of sde-font-lock-list in a preset
      ;; order. 
      (let ((elements sde-font-lock-possible-values)
	    expr)
	(while elements
	  (setq expr (car (cdr (assq (car elements) sde-font-lock-handlers-alist))))
	  (if (and (memq (car elements) sde-font-lock-list)
		   (not (sde-member expr font-lock-keywords)))
	      (setq font-lock-keywords (append font-lock-keywords (list expr))))
	  (setq elements (cdr elements)))))

  ;; If it's a Soar process buffer, also highlight the prompt.
  (if (eq major-mode 'sde-soar-mode)
      (setq font-lock-keywords
	    (append font-lock-keywords
		    (list (cons (concat "\\(" sde-soar-prompt-regexp "\\)")
				'sde-soar-prompt-face)))))

  ;; ... or if it's a Soar output buffer, also highlight the title line.
  (if (eq major-mode 'sde-soar-output-mode)  
      (setq font-lock-keywords
	    (append (list '("^======.*======$" . sde-soar-output-buffer-title-face))
		    font-lock-keywords))))


(add-hook 'font-lock-mode-hook 'sde-font-lock-mode-hook)

;;;-----------------------------------------------------------------------------
;;; 4. Closing statements.
;;;-----------------------------------------------------------------------------
