;;;; -*- Mode: emacs-lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-header.el,v $
;;;; $Id: sde-header.el,v 0.5 1993/06/09 20:22:59 hucka Exp $
;;;; 
;;;; Description       : Soar-specific customizations to file header system.
;;;; Original author(s): Frank Ritter
;;;; Organization      : University of Michigan AI Lab
;;;; 
;;;; Copyright (C) 1993 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs 18.58: Copyright (C) 1985-1991 Free Software Foundation, Inc.
;;;; Soar-mode 5.0    Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:      Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.46:       Copyright (C) 1991-1992 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25    Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:     Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu

(defconst sde-header-el-version "$Revision: 0.5 $"
  "The revision number of sde-header.el.  The complete RCS id is:
      $Id: sde-header.el,v 0.5 1993/06/09 20:22:59 hucka Exp $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation
;;;; 1.  Require, provide, and miscellaneous setup.
;;;; 2.  Global parameters and configuration variables
;;;; 3.  General internal constants and variables
;;;; 4.  Main exported functions
;;;; 5.  Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;;; ----------------
;;;; 0. Documentation
;;;; ----------------
;;;; ... unfinished ...


;;;-----------------------------------------------------------------------------
;;; 1.  Require, provide, and miscellaneous setup.
;;;     Do not modify these.
;;;-----------------------------------------------------------------------------

;; Requirements

(require 'header)
(require 'sde)


;; Provide

(provide 'sde-header)


;;;-----------------------------------------------------------------------------
;;; 2.  Global parameters and configuration variables
;;;
;;; Users may wish to customize the values of these symbols, by resetting their
;;; values via setq in their .emacs files.
;;;-----------------------------------------------------------------------------

;;; soar-header-hooks
;;;
;;; We don't want to set the header style for every file, so we don't
;;; setq make-header-hooks.  Instead, we add a hook to soar-mode-hook that
;;; makes make-header-hooks local to a buffer, and redefines it to be
;;; soar-header-hooks.

(defvar sde-header-hooks 
      '(;; top line with mode  comes for free
        ;; divisor line        comes for free
        header-blank
        header-file-name
        header-author
        header-creation-date
        header-modification-author
        header-modification-date
        header-update-count
        sde-header-soar-version
        ;;Put PURPOSE and TOC near top
        header-blank
        header-purpose
        header-toc
        header-copyright
        ;; Generally want either RCS stuff or header-history.
        header-divisor-line
        header-status
        header-history
        ;;header-rcs-locker
        ;;;;header-rcs-header
        ;;header-rcs-log
        ;; divisor line        comes for free
        )
 "*List of functions that insert each line of a file header in Soar files.")


;;;-----------------------------------------------------------------------------
;;; 3.  General internal constants and variables
;;;-----------------------------------------------------------------------------


;;;-----------------------------------------------------------------------------
;;; 4.  Main exported functions
;;;-----------------------------------------------------------------------------

(defun sde-header-soar-version ()
  "Inserts the version number of the current Soar."
  (if (memq major-mode '(sde-mode production-editor-mode))
      (insert header-prefix-string "Soar Version    : "
	      sde-soar-version "\n")))



;;;-----------------------------------------------------------------------------
;;; 5.  Closing statements.
;;;-----------------------------------------------------------------------------

(setq make-header-hooks sde-header-hooks)
