;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-emacs19.el,v $
;;;; $Id: sde-emacs19.el,v 0.2 1994/03/21 07:53:02 hucka Exp $
;;;; 
;;;; Description       : Functions specific to GNU Emacs 19.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1993 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.46:      Copyright (C) 1991-1992 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-emacs19-el-version "$Revision: 0.2 $"
  "The revision number of sde-emacs19.el.  The complete RCS id is:
      $Id: sde-emacs19.el,v 0.2 1994/03/21 07:53:02 hucka Exp $")


;;;----------------------------------------------------------------------------
;;; 1.  Require, provide, and miscellaneous setup.
;;;     Do not modify these.
;;;----------------------------------------------------------------------------

;; Provide.

(provide 'sde-emacs19)


;;;----------------------------------------------------------------------------
;;; 2. Window and frame/screen handling functions.
;;;----------------------------------------------------------------------------


(defmacro defalias-sde (newname oldname)
  "Set NEWNAME's function definition to OLDNAME, and return OLDNAME.
In Emacs 19, associates the function with the current load file, if any."
  (` (defalias (, newname) (, oldname))))


(defalias-sde 'sde-frame-root-window 'frame-root-window)
(defalias-sde 'sde-frame-list 'frame-list)
(defalias-sde 'sde-window-frame 'window-frame)
(defalias-sde 'sde-selected-frame 'selected-frame)
(defalias-sde 'sde-select-frame 'select-frame)
(defalias-sde 'sde-raise-frame 'raise-frame)
(defalias-sde 'sde-delete-frame 'delete-frame)
(defalias-sde 'sde-make-frame-visible 'make-frame-visible)
(defalias-sde 'sde-frame-live-p 'frame-live-p)
(defalias-sde 'sde-frame-p 'framep)
(defalias-sde 'sde-set-window-dedicated-p 'set-window-dedicated-p)


(defmacro sde-next-window-any (window &optional all-frames)
  "Return next window after WINDOW.  Consider any frame if ALL-FRAMES."
  (` (next-window (, window) 'no-mini (, all-frames))))


(defun sde-buffer-window (buffer &optional all-frames)
  "Return a window in which BUFFER is shown, or return nil.
In Emacs 19 variants, all visible screens are searched, and if optional arg
ALL-FRAMES is non-nil, then even invisible and iconified screens
are searched."
  (if (bufferp buffer)
      (or (get-buffer-window buffer t)
	  (and all-frames
	       ;; Look in invisible frames.
	       ;; get-buffer-window in 19.22 doesn't let you specify
	       ;; invisible and iconified frames; must search manually.
	       (let ((windows (sde-window-list t)))
		 (while (and windows
			     (not (eq (window-buffer (car windows)) buffer)))
		   (setq windows (cdr windows)))
		 (car windows))))))


(defun sde-buffer-frame (buffer &optional all-frames)
  "Return the frame object in which buffer is being shown, or return nil.
If optional arg ALL-FRAMES is non-nil, consider all frames/screens, including
invisible ones.  This function only works in FSF Emacs 19 and Lucid Emacs 19\;
in Emacs 18 it returns nil."
  (if (bufferp buffer)
      ;; Emacs bug: window-frame in 19.22 will error if given nil.
      (let ((window (sde-buffer-window buffer all-frames)))
	(and window (sde-window-frame window)))))


(defun sde-make-frame (buffer &optional params)
  ;; Internal function to hide differences in Emacs versions.  Create a
  ;; frame/screen for buffer
  (funcall 'make-frame params))


(defun sde-make-face-bold (face &optional screen no-error)
  (make-face-bold face screen no-error))


(defun sde-make-face-italic (face &optional screen no-error)
  (make-face-italic face screen no-error))


(defun sde-make-face-bold-italic (face &optional screen no-error)
  (make-face-bold-italic face screen no-error))


;;;----------------------------------------------------------------------------
;;; 3. Menu handling.
;;;
;;; Strictly speaking, this doesn't have to be among first the things defined
;;; for SDE, but since it doesn't depend on other code, it may as well be put
;;; here because it's Emacs-version-specific.
;;;----------------------------------------------------------------------------

;; Defines for the compiler.  These are actually found elsewhere.

(defvar sde-soar-agents)
(defvar sde-source-modes)
(defvar sde-soar-modes)
(defvar sde-soar-version-at-least-6-1-1)

;; The menu creation utility functions here are taken from Edebug 3.2.

(defun sde-make-menus (keymap menu menus)
  "Define menus for a KEYMAP starting at MENU adding all the MENUS.
Each of the MENUS is of the form (NAME TITLE MENU-ITEMS).
The NAME is vconcatted to the MENU.
The MENUS and MENU-ITEMS are all given in the order they should appear."
  (mapcar 
   (function
    (lambda (menu-spec)
     (apply 
      (function
       (lambda (name title menu-items)
	(sde-make-one-menu keymap
			     (vconcat menu (list name))
			     title menu-items)))
      menu-spec)))
   (reverse menus)))


(defun sde-make-one-menu (keymap menu title menu-items)
  "Define KEYMAPs MENU, titled TITLE, with MENU-ITEMS under it.
Append the name of the new menu in MENU after the parent menu.  TITLE
is used for both the menu item in MENU and as the heading for the
MENU-ITEMS.  MENU-ITEMS is a list of items in the order they should
appear.  Each menu item is a list with the title, function, and
optional item name."
  (let ((submenu (make-sparse-keymap title))
	(menus (reverse menu-items)))
    (define-key keymap menu (cons title submenu))
    (mapcar (function
	     (lambda (item)
	       (apply 
		(function 
		 (lambda (title function &optional name)
		   (define-key submenu (vector (or name function))
		     (cons title function))
		   ))
		item)))
	    menus)))


;; `sde-defined-menus' gets called every time a mode function is invoked.  It
;; is that way to accomodate Lucid Emacs.  Since in GNU Emacs 19 you don't
;; need to redefine the menus each time you create a new buffer in a given
;; mode (unlike in Lucid), we track which modes have had their menus defined
;; and do the definitions conditionally.

(defvar sde-menus-defined nil)

(defun sde-define-menus (mode map)
  "Defines menus as appropriate for MODE on keymap MAP."
  (cond ((and (eq mode 'sde-mode) (not (memq mode sde-menus-defined)))
	 (sde-define-sde-mode-menus map)
	 (setq sde-menus-defined (cons mode sde-menus-defined)))

	((and (eq mode 'sde-soar-mode) (not (memq mode sde-menus-defined)))
	 (sde-define-sde-mode-menus map)
	 (sde-add-soar-mode-menus map)
	 (setq sde-menus-defined (cons mode sde-menus-defined)))))


;; Note about the " " lines.  In FSF Emacs it makes it be a non-selectable
;; item.  Because the string items in Emacs 19 menus must (apparently) be
;; unique in FSF Emacs menus, each instance of the separator in a menu is a
;; longer string.  What a hack.

(defun sde-define-sde-mode-menus (map)
  "Defines menus for basic SDE Mode on keymap MAP."
  (sde-make-menus map [menu-bar]
    '((soar "Soar"
       (("Start Soar" soar)
	("Interrupt Soar" sde-interrupt-soar)
	("Go" go)
	("Run" run)
	("Schedule" schedule)
	(" " nil " ")
	("Init Soar" init-soar)
	("Reset" reset)
	("  " nil "  ")
	("Load file..." load-soar)
	("Load default productions" load-defaults)
	("   " nil "   ")
	("Explain on" explain-on)
	("Explain off" explain-off)
	("Load errors on" load-errors-on)
	("Load errors off" load-errors-off)
	("    " nil "    ")
	("Create agent..." create-agent)
	("Select agent..." select-agent)
	("Set agent go..." agent-go)
	("Destroy agent..." destroy-agent)
	("List agents" list-agents)))

      (production "Production"
       (("Send production" sde-send-production)
	("Send region" sde-region-send)
	(" " nil " ")
	("Excise production" excise)
	("Excise region" sde-region-excise)
	("Excise file..." excise-file)
	("Excise task" excise-task)
	("Excise chunks" excise-chunks)
	("Excise all" excise-all)
	("  " nil "  ")
	("Ptrace production" ptrace)
	("Ptrace region" sde-region-ptrace)
	("   " nil "   ")
	("Pbreak production" pbreak)
	("Pbreak region" sde-region-pbreak)
	("    " nil "    ")
	("Find production" sde-find-production)
	("Find next occurrence" sde-find-next-production)))

      (query "Query"
       (("Print" print-soar)
	("Matches" matches)
	("Matches 1" matches-1)
	("Matches 2" matches-2)
	("Preferences" preferences)
	("Explain" explain)
	("Wm" wm)
	("Firing-counts" firing-counts)
	(" " nil " ")
	("View ptraces" sde-view-ptraces)
	("View pbreaks" sde-view-pbreaks)
	("View goal stack (pgs)" sde-view-pgs)
	("View operator stack (pgso)" sde-view-pgso)
	("View match set (ms)" sde-view-ms)
	("View chunks" sde-view-chunks)
	("View productions" sde-view-productions)
	("View justifications" sde-view-justifications)
	("View working memory" sde-view-working-memory)
	("View Soar stats" sde-view-stats)))

      (help "Help"
       (("Help on SDE Mode"  sde-describe-mode)
	("List SDE bindings"  sde-describe-bindings)
	(" " nil " ")
	("SDE Apropos..." sde-apropos)
	("SDE/Soar Topic..." sde-topic-help)
	("  " nil "  ")
	("SDE Manual" sde-info)
	("Soar Manual" sde-soar-info)
	("Soar Release Notes" sde-soar-release-notes)
	("Soar User Notes" sde-soar-user-notes))
       ))))


(defun sde-add-soar-mode-menus (map)
  "Adds pull-down menus for SDE Soar Mode in Lucid Emacs 19.
This assumes it is called in the buffer for which the menus are to be
defined by the mode function."
  ;; This only needs to add items, since SDE Mode will have already
  ;; defined the rest of the menu bar.
  (sde-make-menus map [menu-bar]
    '((input "In/Out"
       (("Previous input" sde-previous-input)
	("Next input" sde-next-input)
	("Complete based on history" sde-previous-similar-input)
	("Search input history..." sde-previous-input-matching)
	(" " nil " ")
	("Erase last word typed" backward-kill-word)
	("Erase whole input" sde-kill-input)
	("Show last output" sde-show-output)
	("Erase last output" sde-kill-output)
	("  " nil "  ")
	("Jump to previous prompt" sde-backward-prompt)
	("Jump to next prompt" sde-forward-prompt))
       ))))


;; Most commands are unavailable if Soar isn't running.
;; Some commands have additional conditions on their availability.

(put 'sde-interrupt-soar      'menu-enable '(sde-soar-is-alive))
(put 'go 		      'menu-enable '(sde-soar-is-alive))
(put 'run 		      'menu-enable '(sde-soar-is-alive))
(put 'init-soar 	      'menu-enable '(sde-soar-is-alive))
(put 'sde-send-production     'menu-enable '(sde-soar-is-alive))
(put 'load-soar 	      'menu-enable '(sde-soar-is-alive))
(put 'load-defaults 	      'menu-enable '(sde-soar-is-alive))
(put 'excise 		      'menu-enable '(sde-soar-is-alive))
(put 'excise-file 	      'menu-enable '(sde-soar-is-alive))
(put 'excise-task 	      'menu-enable '(sde-soar-is-alive))
(put 'excise-chunks 	      'menu-enable '(sde-soar-is-alive))
(put 'excise-all 	      'menu-enable '(sde-soar-is-alive))
(put 'ptrace 		      'menu-enable '(sde-soar-is-alive))
(put 'pbreak 		      'menu-enable '(sde-soar-is-alive))
(put 'print-soar 	      'menu-enable '(sde-soar-is-alive))
(put 'matches	 	      'menu-enable '(sde-soar-is-alive))
(put 'matches-1 	      'menu-enable '(sde-soar-is-alive))
(put 'matches-2 	      'menu-enable '(sde-soar-is-alive))
(put 'preferences 	      'menu-enable '(sde-soar-is-alive))
(put 'wm 		      'menu-enable '(sde-soar-is-alive))
(put 'firing-counts 	      'menu-enable '(sde-soar-is-alive))
(put 'sde-view-ptraces 	      'menu-enable '(sde-soar-is-alive))
(put 'sde-view-pbreaks 	      'menu-enable '(sde-soar-is-alive))
(put 'sde-view-pgs 	      'menu-enable '(sde-soar-is-alive))
(put 'sde-view-pgso 	      'menu-enable '(sde-soar-is-alive))
(put 'sde-view-ms 	      'menu-enable '(sde-soar-is-alive))
(put 'sde-view-chunks 	      'menu-enable '(sde-soar-is-alive))
(put 'sde-view-productions    'menu-enable '(sde-soar-is-alive))
(put 'sde-view-justifications 'menu-enable '(sde-soar-is-alive))
(put 'sde-view-working-memory 'menu-enable '(sde-soar-is-alive))
(put 'sde-view-stats 	      'menu-enable '(sde-soar-is-alive))
(put 'list-productions 	      'menu-enable '(sde-soar-is-alive))
(put 'list-chunks 	      'menu-enable '(sde-soar-is-alive))
(put 'list-justifications     'menu-enable '(sde-soar-is-alive))

;; The following are also dependent on the version of Soar.

(put 'reset 'menu-enable
     '(and (sde-soar-is-alive) sde-soar-version-at-least-6-1-1))
(put 'explain 'menu-enable
     '(and (sde-soar-is-alive) sde-soar-version-at-least-6-1-1))
(put 'explain-on 'menu-enable
     '(and (sde-soar-is-alive) sde-soar-version-at-least-6-1-1))
(put 'explain-off 'menu-enable
     '(and (sde-soar-is-alive) sde-soar-version-at-least-6-1-1))
(put 'load-errors-on 'menu-enable
     '(and (sde-soar-is-alive) sde-soar-version-at-least-6-1-1))
(put 'load-errors-off 'menu-enable
     '(and (sde-soar-is-alive) sde-soar-version-at-least-6-1-1))
(put 'sde-view-pgso 'menu-enable
     '(and (sde-soar-is-alive) sde-soar-version-at-least-6-1-1))

;; Make the following unselectable if we know the Soar process
;; isn't a multi-agent Soar or it's not running.

(put 'schedule      'menu-enable '(and (sde-soar-is-alive) sde-soar-agents))
(put 'create-agent  'menu-enable '(and (sde-soar-is-alive) sde-soar-agents))
(put 'select-agent  'menu-enable '(and (sde-soar-is-alive) sde-soar-agents))
(put 'agent-go      'menu-enable '(and (sde-soar-is-alive) sde-soar-agents))
(put 'list-agents   'menu-enable '(and (sde-soar-is-alive) sde-soar-agents))
(put 'destroy-agent 'menu-enable '(and sde-soar-version-at-least-6-1-1
				   (sde-soar-is-alive) sde-soar-agents))

;; Make the following unselectable in process buffers, where it doesn't
;; make sense to use them anyway.

(put 'sde-region-send 'menu-enable
     '(and (sde-soar-is-alive) (memq major-mode sde-source-modes) mark-active))
(put 'sde-region-pbreak 'menu-enable
     '(and (sde-soar-is-alive) (memq major-mode sde-source-modes) mark-active))
(put 'sde-region-ptrace 'menu-enable
     '(and (sde-soar-is-alive) (memq major-mode sde-source-modes) mark-active))
(put 'sde-region-excise 'menu-enable
     '(and (sde-soar-is-alive) (memq major-mode sde-source-modes) mark-active))

;; This one doesn't make sense if Soar is already running.

(put 'soar 'menu-enable '(not (sde-soar-is-alive)))


;;;----------------------------------------------------------------------------
;;; 5. Closing statements.
;;;----------------------------------------------------------------------------

;;; Local Variables:
;;; eval:(put 'sde-make-menus 'lisp-indent-function 2)
;;; End:
