;;;; -*- Mode: Emacs-Lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-emacs18.el,v $
;;;; $Id: sde-emacs18.el,v 0.1 1994/03/10 07:13:31 hucka Exp $
;;;; 
;;;; Description       : Functions specific to GNU Emacs 18.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs:      Copyright (C) 1985-1993 Free Software Foundation, Inc.
;;;; Soar-mode 5.0:  Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:     Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.46:      Copyright (C) 1991-1992 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25:  Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:    Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu
;;;; Calc 2.02b:     Copyright (C) 1990-1993 Free Software Foundation, Inc.
;;;; Edebug 3.2:     Copyright (C) 1988-1993 Free Software Foundation, Inc.
;;;; rp-describe-function:  Copyright (C) 1991 Robert D. Potter.

(defconst sde-emacs18-el-version "$Revision: 0.1 $"
  "The revision number of sde-emacs18.el.  The complete RCS id is:
      $Id: sde-emacs18.el,v 0.1 1994/03/10 07:13:31 hucka Exp $")


;;;----------------------------------------------------------------------------
;;; 1.  Require, provide, and miscellaneous setup.
;;;     Do not modify these.
;;;----------------------------------------------------------------------------

;; Provide.

(provide 'sde-emacs18)


;;;----------------------------------------------------------------------------
;;; 2. Window and frame/screen handling functions.
;;;----------------------------------------------------------------------------


(defmacro defalias-sde (newname oldname)
  "Set NEWNAME's function definition to OLDNAME, and return OLDNAME.
In Emacs 19, associates the function with the current load file, if any."
  (` (fset (, newname) (symbol-function (, oldname)))))


(defmacro sde-next-window-any (window &optional all-frames)
  "Return next window after WINDOW."
  (` (next-window (, window))))


(defun sde-buffer-window (buffer &optional all-frames)
  "Return a window in which BUFFER is shown, or return nil.
In Emacs 19 variants, all visible screens are searched, and if optional arg
ALL-FRAMES is non-nil, then even invisible and iconified screens
are searched."
  (if (bufferp buffer)
      (if sde-running-epoch
	  (epoch::get-buffer-window buffer)
	  (get-buffer-window buffer))))


(defun sde-buffer-frame (buffer &optional all-frames)
  "Return the frame object in which buffer is being shown, or return nil.
If optional arg ALL-FRAMES is non-nil, consider all frames/screens, including
invisible ones.  This function only works in FSF Emacs 19 and Lucid Emacs 19\;
in Emacs 18 it returns nil."
  (if (bufferp buffer)
      (or (car (symbol-buffer-value 'allowed-screens buffer))
	  (epoch::current-screen))))
