/*
 * $Id: explain.h,v 1.1 1993/11/21 16:20:14 portelli Exp $
 * $Log:	explain.h,v $
 * Revision 1.2  93/11/21  16:45:31  soarhack
 * 6.1.1 checkin
 * 
 * Revision 1.1  93/11/21  16:21:25  soarhack
 * initial checkin
 */

#include "global_vars.h"

/*
   For each production which is backtraced through, keep the name of the production,
   which condition was being traced (from the RHS of this production firing) and
   then the lists of grounds, potentials, locals and negateds generated during
   the backtrace.
   At the moment I'm not guaranteeing that each condition appears in the correct
   list -- this is because elements move between lists after there initial
   positioning.
*/

typedef struct backtrace_struct {
   int result;                              /* 1 when this is a result of the chunk */
   condition *trace_cond;                   /* The (local) condition being traced */
   char   prod_name[256];                   /* The production's name */
   condition *grounds;                      /* The list of conds for the LHS of chunk */
   condition *potentials;                   /* The list of conds which aren't linked */
   condition *locals;                       /* Conds in the subgoal -- need to BT */
   condition *negated;                      /* Negated conditions (sub/super) */
   struct backtrace_struct *next_backtrace; /* Pointer to next in this list */
} backtrace_str;

/*
   For each chunk (or justification) take a copy of its conds and actions,
   and the list of productions which were backtraced through in creating it.
   Also keep a list of all of the grounds (WMEs in the supergoal) which were
   tested as the chunk was formed.
*/

typedef struct explain_chunk_struct {
   char name[256];                          /* Name of this chunk/justification */
   condition *conds;                        /* Variablized list of conditions */
   action *actions;                         /* Variablized list of actions */
   struct backtrace_struct *backtrace;      /* List of back traced productions */
   struct explain_chunk_struct *next_chunk; /* Next chunk in the list */
   condition *all_grounds;                  /* All conditions which go to LHS -- 
                                               must be in same order as the chunk's 
                                               conditions. */
} explain_chunk_str;

/* KBS commented this out -- redundant with global_vars.h */
/* extern bool explain_flag;   Flag for whether we're explaining or not */

extern bool explain_interface_routine (void);
extern char *help_on_explain[];

