/*
 * $Id: ma_interface.c,v 1.1 1993/06/17 20:48:16 jtraub Exp $
 * $Log: ma_interface.c,v $
 * Revision 1.1  1993/06/17  20:48:16  jtraub
 * Released
 *
 * Revision 0.1  1993/06/17  20:21:37  jtraub
 * 6.1_checkin
 *
 * Revision 9.1  1993/06/15  18:04:46  jtraub
 * Split these routines out of interface.c so that mac could continue
 * to compile.
 *
 */

/* =================================================================
                          ma_interface.c
      Interface routines for multi-agent soar mode
================================================================= */

#include <time.h>
#include "soar.h"
#include "scheduler.h"

/* -------------------------------------------------------------------
   
                          "Create Agents" Command

   Syntax:  (create-agents agent-name*)
------------------------------------------------------------------- */

#ifdef MULTI_AGENT_ENABLED
char *help_on_create_agents[] = {
"Command: create-agents",
"",
"Syntax: (create-agents agent-name*)",
"",
"This command creates soar agents identified by the given names",
0 };

bool create_agents_interface_routine (void) {
  char sub_dir[1000];
  int agent_count_in_command = 0;
  agent * first_agent;
  agent * new_agent;
  cons * c;
  agent * the_agent;
  bool agent_already_defined;

  first_agent = soar_agent;

  get_lexeme();  /* consume "create-agents", advance to agent name(s) */
  while (current_agent(lexeme).type!=R_PAREN_LEXEME) {

    agent_already_defined = FALSE;
    for (c = all_soar_agents; c != NIL; c = c->rest) {
      the_agent = (agent *) c->first;
      if (!strcmp(the_agent->name, current_agent(lexeme).string)) {
         agent_already_defined = TRUE;
       }
    }

    if (!strcmp(global_agent->name, current_agent(lexeme).string)) {
      agent_already_defined = TRUE;
    }

    if (agent_already_defined) {
      print ("\nError: Agent %s ", current_agent(lexeme).string);
      print ("already defined, duplicate declaration ignored.\n");
      print_location_of_most_recent_lexeme();
    } else {
      print("\nCreating agent %s.\n", current_agent(lexeme).string);
      strcpy (sub_dir, current_agent(lexeme).string);
      strcat (sub_dir, "/");

      soar_agent = create_soar_agent(current_agent(lexeme).string, ++agent_count);

#ifdef USE_X_DISPLAY
      create_agent_window(soar_agent);
#endif

      load_init_multi_file(sub_dir);

#ifdef USE_X_DISPLAY
      print_agent_prompt(soar_agent);
#endif

      agent_count_in_command++;

      new_agent = soar_agent;
      soar_agent = first_agent;
      push(new_agent, all_soar_agents);
    }
    get_lexeme(); /* consume this one, advance to next agent name */
  }

  if (agent_count_in_command == 0) {
    print("Warning! No agents defined in define-agents command.\n");
    if (agent_count == 0) {
      print("Switching to single agent mode.\n");
      multi_agent_mode = FALSE;
    }
  } else {
    all_soar_agents = destructively_reverse_list (all_soar_agents);
  }

  return TRUE;
}


/* -------------------------------------------------------------------
   
                          "Agent Go" Command

   Syntax:  (agent-go agent-name [integer | 'forever'] [type])
            type ::= p | e | d | g | ps | s | o | context-variable
------------------------------------------------------------------- */

char *help_on_agent_go[] = {
"Command: agent-go",
"",
"Syntax: (agent-go agent_name [integer | 'forever'] [type])",
"        type ::= 'p' | 'e' | 'd' | 'g' | 'ps' | 's' | 'o' | context-variable",
"",
"This command operates exactly the same as the go command, EXCEPT that",
"this only defines the go settings for a agent when it is selected to",
"run by the multi-agent scheduler.  Hence, the go settings are defined",
"for subsequent runs, but no runs are made when the command is read."
"",
"See also:  go, d, run",
0 };

bool agent_go_interface_routine (void) {
  cons  * c;
  agent * the_agent;
  agent * curr_agent;
  long               prev_go_number;
  Symbol           * prev_go_slot_attr;
  goal_stack_level   prev_go_slot_level;
  enum go_type_enum  prev_go_type;
  bool the_result;

  get_lexeme();

  for (c = all_soar_agents; c != NIL; c = c->rest) {
    the_agent = (agent *) c->first;
    if (!strcmp(the_agent->name, current_agent(lexeme).string)) {
      if(the_agent != soar_agent) {
        prev_go_number     = current_agent(go_number);
        prev_go_slot_attr  = current_agent(go_slot_attr);
        prev_go_slot_level = current_agent(go_slot_level);
        prev_go_type       = current_agent(go_type);

        current_agent(go_number)     = the_agent->go_number;
        current_agent(go_slot_attr)  = the_agent->go_slot_attr;
        current_agent(go_slot_level) = the_agent->go_slot_level;
        current_agent(go_type)       = the_agent->go_type;
      }

      the_result = parse_go_command();

      if (the_result && the_agent != soar_agent) {
	the_agent->go_number     = current_agent(go_number);
	the_agent->go_slot_attr  = current_agent(go_slot_attr);
	the_agent->go_slot_level = current_agent(go_slot_level);
	the_agent->go_type       = current_agent(go_type);
      }

      if(the_agent != soar_agent) {
        current_agent(go_number)     = prev_go_number;
        current_agent(go_slot_attr)  = prev_go_slot_attr;
        current_agent(go_slot_level) = prev_go_slot_level;
        current_agent(go_type)       = prev_go_type;
      }
      return the_result;
    }
  }  

  print ("Agent %s is not known.  Ignoring command.\n", 
	 current_agent(lexeme).string);

  print_location_of_most_recent_lexeme();
  if (strcmp(current_agent(lexeme).string, ")")) {
    get_lexeme(); 
  }
  return FALSE;      
}


/* -------------------------------------------------------------------
   
                           "schedule" Command

   Syntax:  (schedule)
------------------------------------------------------------------- */

char *help_on_schedule[] = {
"Command: schedule",
"",
"Syntax: (schedule)",
"",
"Schedule agents in a multi-agent soar setting.",
0 };

bool schedule_interface_routine (void) {
  struct lexeme_info last_lexeme;
  cons * c;
  agent * the_agent;
  int cycles = -1;
  
  get_lexeme();  /* consume "schedule" */

  if (!multi_agent_mode) {
    print("Warning! Only one agent is known. Scheduling single agent only.\n");
  }

  if (current_agent(lexeme).type==INT_CONSTANT_LEXEME) {
    cycles = current_agent(lexeme).int_val;
    get_lexeme();  
  }

  last_lexeme = current_agent(lexeme); 

  schedule_agents(cycles);

#ifdef USE_X_DISPLAY  
  for (c = all_soar_agents; c != NIL; c = c->rest) {
    the_agent = (agent *) c->first;
    if (the_agent != soar_agent) {
    print_agent_prompt (the_agent);
    }
  }
#endif

  current_agent(lexeme) = last_lexeme;
  return TRUE;
}

/* -------------------------------------------------------------------
                           "Select Agent" Command

   Syntax:  (select-agent agent-name)
------------------------------------------------------------------- */

#ifndef USE_X_DISPLAY

char *help_on_select_agent[] = {
"Command: select-agent",
"",
"Syntax: (select-agent agent-name)",
"",
"Select agent to receive commands",
0 };

bool select_agent_interface_routine (void) {
  cons * c;
  
  get_lexeme();  /* consume "select-agent" */

  if (current_agent(lexeme).type = SYM_CONSTANT_LEXEME) {
    for(c = all_soar_agents; c != NIL; c = c->rest) {
      if (!strcmp(current_agent(lexeme).string,
		  ((agent *)c->first)->name)) {
        get_lexeme(); 
	((agent *)c->first)->lexeme = current_agent(lexeme); 
	soar_agent = (agent *)c->first;

        return TRUE;
      }
      if(!strcmp(current_agent(lexeme).string, "control")) {
        get_lexeme();
        global_agent->lexeme = current_agent(lexeme);
        soar_agent = global_agent;
        return TRUE;
      }
    }
    if (strcmp(current_agent(lexeme).string, ")")) {
      print ("Unknown agent name.\n");
    } else {
      print ("Expected agent name.\n");
    }
  } else {
    print ("Expected agent name.\n");
  }
  print_location_of_most_recent_lexeme();
  if (strcmp(current_agent(lexeme).string, ")")) {
    get_lexeme(); 
  }
  return FALSE;      
}
#endif /* USE_X_DISPLAY */

void init_multi_agent_built_in_commands(void) {
  add_command ("create-agents", create_agents_interface_routine);
  add_help ("create-agents", help_on_create_agents);

  add_command ("agent-go", agent_go_interface_routine);
  add_help ("agent-go", help_on_agent_go);

  add_command ("schedule", schedule_interface_routine);
  add_help ("schedule", help_on_schedule);

#ifndef USE_X_DISPLAY
  add_command ("select-agent", select_agent_interface_routine);
  add_help ("select-agent", help_on_select_agent);
#endif /* USE_X_DISPLAY */
}

#endif /* MULTI_AGENT_ENABLED */


