// machview.cpp : implementation file
//

#include "stdafx.h"
#include "soar.h"
#include "machview.h"
#include "prodwiz.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMachineView

IMPLEMENT_DYNCREATE(CMachineView, CFormView)

CMachineView::CMachineView()
	: CFormView(CMachineView::IDD)
{
	//{{AFX_DATA_INIT(CMachineView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CMachineView::~CMachineView()
{
}

BOOL CMachineView::Create(LPCSTR lpszClassName,
			 		      LPCSTR lpszWindowName,
					      DWORD  dwStyle,
					      const RECT& rect,
					      CWnd* pParentWnd,
					      UINT nID,
					      CCreateContext* pContext)
{        
	if (CFormView::Create(lpszClassName,
						  lpszWindowName,
						  dwStyle,
						  rect,
						  pParentWnd,
						  nID,
						  pContext) == FALSE)
		return FALSE;

	SetButtonState(CMachineDoc::IDH_STEP|CMachineDoc::IDH_RUN);
    m_InterruptButton.AutoLoad(ID_INTERRUPT,this);
    m_StepButton.AutoLoad(ID_STEP,this);
    m_RunButton.AutoLoad(ID_RUN,this);
	return TRUE;
}

void CMachineView::SetButtonState(int buttons)
{
	m_InterruptButton.EnableWindow(buttons&CMachineDoc::IDH_INTERRUPT);
	m_StepButton.EnableWindow(buttons&CMachineDoc::IDH_STEP);
	m_RunButton.EnableWindow(buttons&CMachineDoc::IDH_RUN);
}

void CMachineView::OnInitialUpdate()
{
	char buff[MISC_STRING_SIZE];
	CMachineDoc* pDoc = (CMachineDoc *)GetDocument();
	POSITION pos;

    CFormView::OnInitialUpdate();

	for (pos=pDoc->m_LogList.GetHeadPosition();pos!=NULL;)
	  m_LogScroll.AddString(pDoc->m_LogList.GetNext(pos));
	  
	for (pos=pDoc->m_ChunkList.GetHeadPosition();pos!=NULL;)
	  m_ChunkList.AddString(CString(symbol_to_string(
	             ((production *)pDoc->m_ChunkList.GetNext(pos))->name,TRUE,buff)));

	for (pos=pDoc->m_ProductionList.GetHeadPosition();pos!=NULL;)
	  m_ProductionList.AddString(CString(symbol_to_string(
	             ((production *)pDoc->m_ProductionList.GetNext(pos))->name,TRUE,buff)));
	  
	SetButtonState(pDoc->m_ButtonState);

	return;
}

void CMachineView::OnUpdate(CView* pSender,
			  LPARAM lHint,
			  CObject *pHint)
{
	CMachineDoc* pDoc = (CMachineDoc *)GetDocument();

	switch (lHint&0xff00) {
	  case CMachineDoc::IDH_ADD:
	  	// Add stuff....
		switch (lHint&0x00ff) {
		  case CMachineDoc::IDH_LOG:
			m_LogScroll.AddString(*(CString *)pHint);
			m_LogScroll.SetCaretIndex(m_LogScroll.GetCount()-1);
			return;
		  case CMachineDoc::IDH_PRODUCTION:
		    m_ProductionList.AddString(*(CString *)pHint);
			m_ProductionList.SetCaretIndex(m_ProductionList.GetCount()-1);
		    return;
		  case CMachineDoc::IDH_CHUNK:
		    m_ChunkList.AddString(*(CString *)pHint);
			m_ChunkList.SetCaretIndex(m_ChunkList.GetCount()-1);
		    return;
		}
		break;
	  case CMachineDoc::IDH_REMOVE:
	  	// Remove stuff....
		switch (lHint&0x00ff) {
		  case CMachineDoc::IDH_LOG:
		  	AfxMessageBox("Sorry, but you can't remove strings from the Log.");
		  	return;
		  case CMachineDoc::IDH_PRODUCTION:
		    m_ProductionList.DeleteString(m_ProductionList.FindString(-1,*(CString *)pHint));
		    return;
		  case CMachineDoc::IDH_CHUNK:
		    m_ChunkList.DeleteString(m_ChunkList.FindString(-1,*(CString *)pHint));
		    return;
		}
	  	break;
	  case CMachineDoc::IDH_CLEAR:
	  	// Remove stuff....
		switch (lHint&0x00ff) {
		  case CMachineDoc::IDH_LOG:
		  	m_LogScroll.ResetContent();
		  	break;
		  case CMachineDoc::IDH_PRODUCTION:
		    m_ProductionList.ResetContent();
		    return;
		  case CMachineDoc::IDH_CHUNK:
		    m_ChunkList.ResetContent();
		    return;
		}
	  	return;
	  	break;
	  case CMachineDoc::IDH_BUTTONS:
	  	SetButtonState((int)lHint&0xff);
	  	return;
	}
	CFormView::OnUpdate(pSender,lHint,pHint);

 	return;
}

void CMachineView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMachineView)
	DDX_Control(pDX, IDC_SOAR_LOG, m_LogScroll);
	DDX_Control(pDX, IDC_SOAR_CHUNKS, m_ChunkList);
	DDX_Control(pDX, IDC_SOAR_PRODUCTIONS, m_ProductionList);
	DDX_Control(pDX, IDC_SOAR_COMMAND, m_CommandCombo);
	DDX_Control(pDX, ID_EXECUTE, m_ExecuteButton);
	DDX_Control(pDX, ID_STEP, m_StepButton);
	DDX_Control(pDX, ID_RUN, m_RunButton);
	DDX_Control(pDX, ID_INTERRUPT, m_InterruptButton);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMachineView, CFormView)
	//{{AFX_MSG_MAP(CMachineView)
	ON_BN_CLICKED(ID_INTERRUPT, OnClickedInterrupt)
	ON_BN_CLICKED(ID_RUN, OnClickedRun)
	ON_BN_CLICKED(ID_STEP, OnClickedStep)
	ON_BN_CLICKED(ID_EXECUTE, OnClickedExecute)
	ON_LBN_DBLCLK(IDC_SOAR_CHUNKS, OnDblclkSoarChunks)
	ON_LBN_DBLCLK(IDC_SOAR_PRODUCTIONS, OnDblclkSoarProductions)
	ON_LBN_SELCHANGE(IDC_SOAR_LOG, OnLogSelect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMachineView message handlers


void CMachineView::OnClickedInterrupt()
{
    current_agent(stop_soar) = STOP_INTERRUPT;
    current_agent(reason_for_stopping) = "*** Interrupt Acknowledged ***";
	print("\n****** Interrupt Hit ******\n");
}

void CMachineView::OnClickedRun()
{
	m_CommandCombo.SetWindowText("d");
	PostMessage(WM_COMMAND,ID_EXECUTE);
}

void CMachineView::OnClickedStep()
{
	m_CommandCombo.SetWindowText("go");
	PostMessage(WM_COMMAND,ID_EXECUTE);
}

extern "C" void read_and_dispatch_command(void);

void CMachineView::OnClickedExecute()
{
	CString tmpstr;
	
	m_CommandCombo.GetWindowText(tmpstr);
	m_CommandCombo.InsertString(0,tmpstr);
	while (m_CommandCombo.GetCount()>16)
	  m_CommandCombo.DeleteString(16);    	  
	m_LogScroll.DeleteString(m_LogScroll.FindString(-1,CString("Soar>")));
	
	strcpy(current_agent(current_line),tmpstr);
	tmpstr  = "Soar> ";
	tmpstr += current_agent(current_line);
	print("%s\n",tmpstr);
	current_agent(current_line_index)=0;
	current_agent(current_char)=' ';
	((CMachineDoc *)GetDocument())->SetButtons(
	               CMachineDoc::IDH_INTERRUPT);
	read_and_dispatch_command();
	((CMachineDoc *)GetDocument())->SetButtons(
	               CMachineDoc::IDH_STEP|
	               CMachineDoc::IDH_RUN);
	print("\n");
	m_LogScroll.InsertString(-1,"Soar>");
	m_LogScroll.SetCaretIndex(m_LogScroll.GetCount()-1);
	m_CommandCombo.SetFocus();
}

void CMachineView::OnDblclkSoarChunks()
{
	CMachineDoc *pDoc = (CMachineDoc *)GetDocument();
	CProductionWizard pWiz(pDoc->m_ChunkList,CString("Chunk"));
	m_ChunkList.GetText(m_ChunkList.GetCurSel(),pWiz.m_SelectedProduction);
	pWiz.SetWindowText("Chunk Wizard");
	pWiz.DoModal();	
}

void CMachineView::OnDblclkSoarProductions()
{
	CMachineDoc *pDoc = (CMachineDoc *)GetDocument();
	CProductionWizard pWiz(pDoc->m_ProductionList,CString("Production"));
	m_ProductionList.GetText(m_ProductionList.GetCurSel(),pWiz.m_SelectedProduction);
	pWiz.DoModal();	
}

void CMachineView::OnLogSelect()
{
	m_LogScroll.SetCurSel(-1);
	
}
