// machdoc.h : header file
//

#ifndef _MACHDOC_H_
#define _MACHDOC_H_

#include "src/soar.h"

/////////////////////////////////////////////////////////////////////////////
// CMachineDoc document

class CMachineDoc : public CDocument
{

	DECLARE_SERIAL(CMachineDoc)
protected:
	CMachineDoc();			// protected constructor used by dynamic creation

// Attributes
public:
	enum {IDH_PRODUCTION=0x0001, // Hints for OnUpdate of views...
		  IDH_CHUNK=0x0002,
		  IDH_LOG=0x0004,
		  IDH_ADD=0x7100,		 // so we can mask &0xff00
		  IDH_REMOVE=0x7200,
		  IDH_CLEAR=0x7300};
	enum {IDH_INTERRUPT=0x0001,  // Hints for buttons
		  IDH_STEP=0x0002,
		  IDH_RUN=0x0004,
		  IDH_BUTTONS=0x7400};	// button command...
	int			 m_ButtonState;
	CStringList  m_LogList;
	CPtrList	 m_ChunkList;
	CPtrList	 m_ProductionList;

// Operations
	void AddLog(CString& logline);
	void AddProduction(production *prod);
	void RemoveProduction(production *prod);
	void AddChunk(production *chunk);
	void RemoveChunk(production *chunk);
	inline void SetButtons(int state) { m_ButtonState=(state & 0xff); 
										UpdateAllViews(NULL,IDH_BUTTONS|m_ButtonState,NULL); }

// Implementation
protected:
	virtual ~CMachineDoc();
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
	virtual	BOOL OnNewDocument();
	virtual void OnDeleteContents();
	virtual BOOL CMachineDoc::CanCloseFrame(CFrameWnd *pFrame);
	// Generated message map functions

protected:
	//{{AFX_MSG(CMachineDoc)
	afx_msg void OnFileClose();
	afx_msg void OnExciseall();
	afx_msg void OnExcisechunks();
	afx_msg void OnInitsoar();
	afx_msg void OnChunkwizard();
	afx_msg void OnProductionwizard();
	afx_msg void OnLearn();
	afx_msg void OnExcisetask();
	afx_msg void OnWatches();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif /* _MACHDOC_H_ */