// machdoc.cpp : implementation file
//

#include "stdafx.h"
#include "soar.h"
#include "machdoc.h"
#include "machview.h"
#include "learndlg.h"
#include "prodwiz.h"
#include "watchdlg.h"

// Soar stuff...
#include "src/soar.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CSoarApp FAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CMachineDoc

IMPLEMENT_SERIAL(CMachineDoc, CDocument, 0 /* schema number*/ )

CMachineDoc::CMachineDoc()
{                  
	ASSERT(theApp.m_pSoarMachine==NULL);
	theApp.m_pSoarMachine=this;
}

BOOL CMachineDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	SetModifiedFlag();
	SetButtons(IDH_RUN|IDH_STEP);
	init_soar();
	return TRUE;
}

CMachineDoc::~CMachineDoc()
{
}


BEGIN_MESSAGE_MAP(CMachineDoc, CDocument)
	//{{AFX_MSG_MAP(CMachineDoc)
	ON_COMMAND(ID_FILE_CLOSE, OnFileClose)
	ON_COMMAND(ID_CONTROL_EXCISE_EXCISEALL, OnExciseall)
	ON_COMMAND(ID_CONTROL_EXCISE_EXCISECHUNKS, OnExcisechunks)
	ON_COMMAND(ID_CONTROL_INITSOAR, OnInitsoar)
	ON_COMMAND(ID_MACHINE_CHUNKWIZARD, OnChunkwizard)
	ON_COMMAND(ID_MACHINE_PRODUCTIONWIZARD, OnProductionwizard)
	ON_COMMAND(ID_MACHINE_LEARN, OnLearn)
	ON_COMMAND(ID_CONTROL_EXCISE_EXCISETASK, OnExcisetask)
	ON_COMMAND(ID_MACHINE_WATCHES, OnWatches)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMachineDoc serialization

void CMachineDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		POSITION pos=m_LogList.GetHeadPosition();
		while (pos!=NULL) 
		  ar << m_LogList.GetNext(pos) << "\r\n";
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMachineDoc commands

void Unimplemented()
{
	AfxMessageBox("Sorry, but that isn't implemented");
}


BOOL CMachineDoc::CanCloseFrame(CFrameWnd *pFrame)
{
	ASSERT_VALID(pFrame);

	POSITION pos = GetFirstViewPosition();
	while (pos)
	{
		CView* pView = GetNextView(pos);
		ASSERT_VALID(pView);
		CFrameWnd* pFrame = pView->GetParentFrame();
		// assume frameless views are ok to close
		if (pFrame != NULL)
		{
			// assumes 1 document per frame
			ASSERT_VALID(pFrame);
			if (pFrame->m_nWindow > 0)
				return TRUE;        // more than one frame refering to us
		}
	}

	// otherwise only one frame that we know about
	AfxMessageBox("Sorry, you can't close the\nlast view to the Soar Machine.");
	return FALSE;
}

void CMachineDoc::OnFileClose()
{
	  AfxMessageBox("Sorry, you can't close the Soar Machine.");
}

void CMachineDoc::OnDeleteContents()
{
	m_LogList.RemoveAll();
	UpdateAllViews(NULL,IDH_CLEAR|IDH_LOG);
	m_ChunkList.RemoveAll();
	UpdateAllViews(NULL,IDH_CLEAR|IDH_CHUNK);
	m_ProductionList.RemoveAll();
	UpdateAllViews(NULL,IDH_CLEAR|IDH_PRODUCTION);
}

//  Operators.....
void CMachineDoc::AddLog(CString& logline)
{
	if (m_LogList.GetCount()>32000)
	  m_LogList.RemoveHead();
	m_LogList.AddTail(logline);
	UpdateAllViews(NULL,
				   IDH_ADD|IDH_LOG,
				   (CObject *)(&logline));
}

void CMachineDoc::AddProduction(production *prod)
{                                  
	char buff[MISC_STRING_SIZE];
	CString key(symbol_to_string(prod->name,TRUE,buff));

	if (m_ProductionList.GetCount()>65000)
	  m_ProductionList.RemoveHead();
	m_ProductionList.AddTail((void *)prod);
	UpdateAllViews(NULL,
				   IDH_ADD|IDH_PRODUCTION,
				   (CObject *)(&key));
}

void CMachineDoc::RemoveProduction(production *prod)
{
	char buff[MISC_STRING_SIZE];
	CString key(symbol_to_string(prod->name,TRUE,buff));

	if (m_ChunkList.GetCount()>65000)
	  m_ChunkList.RemoveHead();
	m_ProductionList.RemoveAt(m_ProductionList.Find((void *)prod));
	UpdateAllViews(NULL,
				   IDH_REMOVE|IDH_PRODUCTION,
				   (CObject *)(&key));
}

void CMachineDoc::AddChunk(production *chunk)
{
	char buff[MISC_STRING_SIZE];
	CString key(symbol_to_string(chunk->name,TRUE,buff));
	m_ChunkList.AddTail((void *)chunk);
	UpdateAllViews(NULL,
				   IDH_ADD|IDH_CHUNK,
				   (CObject *)(&key));
}

void CMachineDoc::RemoveChunk(production *chunk)
{
	char buff[MISC_STRING_SIZE];
	CString key(symbol_to_string(chunk->name,TRUE,buff));
	m_ChunkList.RemoveAt(m_ChunkList.Find((void *)chunk));
	UpdateAllViews(NULL,
				   IDH_REMOVE|IDH_CHUNK,
				   (CObject *)(&key));
}

extern "C" void excise_all_productions_of_type(byte type);

// Remove all productions
void CMachineDoc::OnExciseall()
{
  if (AfxMessageBox("  This will remove all productions,\n"
  				    "chunks, and the default productions.",
  					MB_OKCANCEL)!=IDOK)
  	return;
  excise_all_productions_of_type (DEFAULT_PRODUCTION_TYPE);
  excise_all_productions_of_type (USER_PRODUCTION_TYPE);
  excise_all_productions_of_type (CHUNK_PRODUCTION_TYPE);
  excise_all_productions_of_type (JUSTIFICATION_PRODUCTION_TYPE);
  reinitialize_soar();  /* for excise-all, also do an init-soar */
  AddLog(CString("Soar> excise-all"));
}


// Remove current task
void CMachineDoc::OnExcisetask()
{
  if (AfxMessageBox("This will remove all productions and chunks.",
  					MB_OKCANCEL)!=IDOK)
  	return;
  excise_all_productions_of_type (USER_PRODUCTION_TYPE);
  excise_all_productions_of_type (CHUNK_PRODUCTION_TYPE);
  excise_all_productions_of_type (JUSTIFICATION_PRODUCTION_TYPE);
  reinitialize_soar();  /* for excise-all, also do an init-soar */
  AddLog(CString("Soar> excise-task"));
}

// Remove all chunks
void CMachineDoc::OnExcisechunks()
{
  if (AfxMessageBox("This will remove all chunks.",
  					MB_OKCANCEL)!=IDOK)
  	return;
  excise_all_productions_of_type (CHUNK_PRODUCTION_TYPE);
  excise_all_productions_of_type (JUSTIFICATION_PRODUCTION_TYPE);
  AddLog(CString("Soar> excise-chunks"));
}

void CMachineDoc::OnInitsoar()
{
  if (AfxMessageBox("Reset to initial state?",
  					MB_OKCANCEL)!=IDOK)
  	return;
  reinitialize_soar();
  AddLog(CString("Soar> init-soar"));
}

void CMachineDoc::OnChunkwizard()
{
	CProductionWizard prodWiz(m_ChunkList,CString("Chunk"));
	prodWiz.SetWindowText("Chunk Wizard");
	prodWiz.DoModal();		
}

void CMachineDoc::OnProductionwizard()
{                  
	CProductionWizard prodWiz(m_ProductionList,CString("Production"));
	prodWiz.DoModal();
}


void CMachineDoc::OnLearn()
{
	CLearnDialog lDlg;
	
	lDlg.m_Learn=(BOOL)current_agent(sysparams)[LEARNING_ON_SYSPARAM];
	lDlg.m_BottomUp= ! (BOOL)current_agent(sysparams)[LEARNING_ALL_GOALS_SYSPARAM];
	lDlg.m_ChunkNames=(BOOL)current_agent(sysparams)[TRACE_CHUNK_NAMES_SYSPARAM];
	lDlg.m_ChunkBody=(BOOL)current_agent(sysparams)[TRACE_CHUNKS_SYSPARAM];
	lDlg.m_Firings=(BOOL)current_agent(sysparams)[TRACE_FIRINGS_OF_CHUNKS_SYSPARAM];
	lDlg.m_Backtrace=(BOOL)current_agent(sysparams)[TRACE_BACKTRACING_SYSPARAM];
	if (lDlg.DoModal()!=IDOK)
	  return;
	current_agent(sysparams)[LEARNING_ON_SYSPARAM]=lDlg.m_Learn;
	current_agent(sysparams)[LEARNING_ALL_GOALS_SYSPARAM]=!lDlg.m_BottomUp;
	current_agent(sysparams)[TRACE_CHUNK_NAMES_SYSPARAM]=lDlg.m_ChunkNames;
	current_agent(sysparams)[TRACE_CHUNKS_SYSPARAM]=lDlg.m_ChunkBody;
	current_agent(sysparams)[TRACE_FIRINGS_OF_CHUNKS_SYSPARAM]=lDlg.m_Firings;
	current_agent(sysparams)[TRACE_BACKTRACING_SYSPARAM]=lDlg.m_Backtrace;
	
}


void CMachineDoc::OnWatches()
{
	CWatchDialog wDlg;

	wDlg.m_Backtraces=
			(BOOL)current_agent(sysparams)[TRACE_BACKTRACING_SYSPARAM];
	wDlg.m_ChunkBody=
			(BOOL)current_agent(sysparams)[TRACE_CHUNKS_SYSPARAM];
	wDlg.m_ChunkName=
			(BOOL)current_agent(sysparams)[TRACE_CHUNK_NAMES_SYSPARAM];
	wDlg.m_Context=
			(BOOL)current_agent(sysparams)[TRACE_CONTEXT_DECISIONS_SYSPARAM];
	wDlg.m_Firings=
			(BOOL)current_agent(sysparams)[TRACE_FIRINGS_OF_CHUNKS_SYSPARAM];
	wDlg.m_JustificationBody=
			(BOOL)current_agent(sysparams)[TRACE_JUSTIFICATIONS_SYSPARAM];
	wDlg.m_JustificationName=
			(BOOL)current_agent(sysparams)[TRACE_JUSTIFICATION_NAMES_SYSPARAM];
	wDlg.m_Phases=
			(BOOL)current_agent(sysparams)[TRACE_PHASES_SYSPARAM];
	wDlg.m_WMEs=
			(BOOL)current_agent(sysparams)[TRACE_WM_CHANGES_SYSPARAM];
	wDlg.m_FireChunks=
			(BOOL)current_agent(sysparams)[TRACE_FIRINGS_OF_CHUNKS_SYSPARAM];
	wDlg.m_FireDefault=
			(BOOL)current_agent(sysparams)[TRACE_FIRINGS_OF_DEFAULT_PRODS_SYSPARAM];
	wDlg.m_FireJustifications=
			(BOOL)current_agent(sysparams)[TRACE_FIRINGS_OF_JUSTIFICATIONS_SYSPARAM];
	wDlg.m_FireUser=
			(BOOL)current_agent(sysparams)[TRACE_FIRINGS_OF_USER_PRODS_SYSPARAM];
	wDlg.m_FirePref=
			(BOOL)current_agent(sysparams)[TRACE_FIRINGS_PREFERENCES_SYSPARAM];
	wDlg.m_FireWme=
			(BOOL)current_agent(sysparams)[TRACE_FIRINGS_WME_TRACE_TYPE_SYSPARAM];
	
	if (wDlg.DoModal()!=IDOK)
	  return;

	current_agent(sysparams)[TRACE_BACKTRACING_SYSPARAM]=wDlg.m_Backtraces;
	current_agent(sysparams)[TRACE_CHUNKS_SYSPARAM]=wDlg.m_ChunkBody;
	current_agent(sysparams)[TRACE_CHUNK_NAMES_SYSPARAM]=wDlg.m_ChunkName;
	current_agent(sysparams)[TRACE_CONTEXT_DECISIONS_SYSPARAM]=wDlg.m_Context;
	current_agent(sysparams)[TRACE_FIRINGS_OF_CHUNKS_SYSPARAM]=wDlg.m_Firings;
	current_agent(sysparams)[TRACE_JUSTIFICATIONS_SYSPARAM]=wDlg.m_JustificationBody;
	current_agent(sysparams)[TRACE_JUSTIFICATION_NAMES_SYSPARAM]=wDlg.m_JustificationName;
	current_agent(sysparams)[TRACE_PHASES_SYSPARAM]=wDlg.m_Phases;
	current_agent(sysparams)[TRACE_WM_CHANGES_SYSPARAM]=wDlg.m_WMEs;
	current_agent(sysparams)[TRACE_FIRINGS_OF_CHUNKS_SYSPARAM]=wDlg.m_FireChunks;
	current_agent(sysparams)[TRACE_FIRINGS_OF_DEFAULT_PRODS_SYSPARAM]=wDlg.m_FireDefault;
	current_agent(sysparams)[TRACE_FIRINGS_OF_JUSTIFICATIONS_SYSPARAM]=wDlg.m_FireJustifications;
	current_agent(sysparams)[TRACE_FIRINGS_OF_USER_PRODS_SYSPARAM]=wDlg.m_FireUser;
	current_agent(sysparams)[TRACE_FIRINGS_PREFERENCES_SYSPARAM]=wDlg.m_FirePref;
	current_agent(sysparams)[TRACE_FIRINGS_WME_TRACE_TYPE_SYSPARAM]=wDlg.m_FireWme;
                                                                    
}
