;;;; -*- Mode: emacs-lisp -*-
;;;; 
;;;; $Source: /n/manic/u/hucka/Projects/Soar/Interface/Src/RCS/sde-x-mouse.el,v $
;;;; $Id: sde-x-mouse.el,v 0.6 1993/06/10 07:36:01 hucka Exp hucka $
;;;; 
;;;; Description       : Support for X window mouse with SDE.
;;;; Original author(s): Michael Hucka <hucka@eecs.umich.edu>
;;;; Organization      : University of Michigan AI Lab
;;;;
;;;; Copyright (C) 1993 Michael Hucka.
;;;;
;;;; This program (SDE) is free software; you can redistribute it and/or
;;;; modify it under the terms of the GNU General Public License as published
;;;; by the Free Software Foundation; either version 1 of the License, or (at
;;;; your option) any later version.
;;;; 
;;;; SDE is distributed in the hope that it will be useful, but WITHOUT ANY
;;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;; for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with this program; see the file COPYING.  If not, write to the Free
;;;; Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;;; Portions of SDE were derived from copyrighted code that permits copying
;;;; as long as the copyrights are preserved.  Here are the copyrights from
;;;; the relevant packages:
;;;;
;;;; GNU Emacs 18.58: Copyright (C) 1985-1991 Free Software Foundation, Inc.
;;;; Soar-mode 5.0    Copyright (C) 1990-1991 Frank Ritter, frank.ritter@cmu.edu
;;;; Ilisp 4.12:      Copyright (C) 1990-1992 Chris McConnell, ccm@cs.cmu.edu
;;;; BBDB 1.46:       Copyright (C) 1991-1992 Jamie Zawinski, jwz@lucid.com
;;;; Ange-ftp 4.25    Copyright (C) 1989-1992 Andy Norman, ange@hplb.hpl.hp.com
;;;; Comint 2.03:     Copyright (C) 1988 Olin Shivers, shivers@cs.cmu.edu

(defconst sde-x-mouse-el-version "$Revision: 0.6 $"
  "The revision number of sde-x-mouse.el.  The complete RCS id is:
      $Id: sde-x-mouse.el,v 0.6 1993/06/10 07:36:01 hucka Exp hucka $")

;;;; -----------------
;;;; Table of contents
;;;; -----------------
;;;; 0.  Documentation.
;;;; 1.  Require, provide, and miscellaneous setup.
;;;; 2.  Global parameters and configuration variables.
;;;; 3.  Main code.
;;;; 4. Closing statements.
;;;;
;;;; Suggestion for navigating this file: use the page movement commands in
;;;; Emacs (`C-x [' and `C-x ]') to move from section to section.  Also, get
;;;; the "page-menu" Emacs package from archive.cis.ohio-state.edu
;;;; (File /pub/gnu/emacs/elisp-archive/as-is/page-menu.el.Z).


;;;; ----------------
;;;; 0. Documentation
;;;; ----------------
;;;;


;;;-----------------------------------------------------------------------------
;;; 1.  Require, provide, and miscellaneous setup.
;;;     Do not modify these.
;;;-----------------------------------------------------------------------------

;; Requirements

(require 'sde)

(cond (sde-running-epoch)		; Epoch
      (sde-running-lemacs)		; Lucid Emacs 19
      (t				; Regular Emacs
       (require 'x-mouse)))


;;;-----------------------------------------------------------------------------
;;; 2.  Global parameters and configuration variables
;;;
;;; Users may wish to customize the values of these symbols, by resetting their
;;; values via setq in their .emacs files.
;;;-----------------------------------------------------------------------------


;;;-----------------------------------------------------------------------------
;;; 3.  General internal constants and variables
;;;-----------------------------------------------------------------------------


;;;-----------------------------------------------------------------------------
;;; 4.  Main code.
;;;-----------------------------------------------------------------------------


(defun sde-x-mouse-in-sde-buffer (arg)
  ;; Return non-nil if the mouse is over an SDE buffer of some sort.
  (let* ((first-window (selected-window))
	 (window (next-window first-window))
	 found buffer)
    (while (not (or (setq found (coordinates-in-window-p arg window))
		    (eq window first-window)))
      (setq window (next-window window)))
    (if found
	(save-excursion
	  (set-buffer (window-buffer window))
	  (memq major-mode '(sde-mode sde-soar-mode))))))


(defun sde-x-print-soar (arg)
  "Execute Soar \"print\" on the item under the cursor."
  (if (sde-x-mouse-in-sde-buffer arg)
      (progn
	(require 'sde-soar-mode)
	(x-mouse-set-point arg)
	(sde-check-soar)
	(print-soar (sde-agent) (sde-symbol-near-point) (car sde-print-hist)))))


(defun sde-x-matches (arg)
  "Execute Soar \"matches\" on the item under the cursor."
  (if (sde-x-mouse-in-sde-buffer arg)
      (progn
	(require 'sde-soar-mode)
	(x-mouse-set-point arg)
	(sde-check-soar)
	(matches (sde-agent) (sde-symbol-near-point) (car sde-matches-hist)))))


(defun sde-x-find-production (arg)
  "Execute `sde-find-production' on the production name under the cursor."
  (if (sde-x-mouse-in-sde-buffer arg)
      (progn
	(require 'sde-soar-mode)
	(x-mouse-set-point arg)
	(sde-check-soar)
	(sde-find-production (sde-sp-name-near-point)))))


(defun sde-x-eval-production (arg)
  "Evaluate (send to Soar) the production under the cursor."
  (if (sde-x-mouse-in-sde-buffer arg)
      (progn
	(require 'sde-soar-mode)
	(x-mouse-set-point arg)
	(sde-check-soar)
	(sde-eval-production))))


(defun sde-x-ptrace-production (arg)
  "Execute Soar \"ptrace\" on the production under the cursor."
  (if (sde-x-mouse-in-sde-buffer arg)
      (progn
	(require 'sde-soar-mode)
	(x-mouse-set-point arg)
	(sde-check-soar)
	(ptrace (sde-agent) (sde-sp-name-near-point)))))


(defun sde-x-pbreak-production (arg)
  "Execute SDE's \"pbreak\" on the production under the cursor."
  (if (sde-x-mouse-in-sde-buffer arg)
      (progn
	(require 'sde-soar-mode)
	(x-mouse-set-point arg)
	(sde-check-soar)
	(pbreak (sde-agent) (sde-sp-name-near-point)))))



;;;-----------------------------------------------------------------------------
;;; 5. Closing statements.
;;;-----------------------------------------------------------------------------

;; We use the up events.  Need erase down map events, otherwise may get
;; interference with existing bindings, and may get the problem that a button
;; press's `up' event will cause the minibuffer output to disappear.

(define-key mouse-map x-button-s-left 'x-mouse-ignore)
(define-key mouse-map x-button-s-middle 'x-mouse-ignore)
(define-key mouse-map x-button-s-right 'x-mouse-ignore)

(define-key mouse-map x-button-c-m-left 'x-mouse-ignore)
(define-key mouse-map x-button-c-m-middle 'x-mouse-ignore)
(define-key mouse-map x-button-c-m-right 'x-mouse-ignore)

;; Bind buttons:

(define-key mouse-map x-button-s-left-up   'sde-x-print-soar)
(define-key mouse-map x-button-s-middle-up 'sde-x-matches)
(define-key mouse-map x-button-s-right-up  'sde-x-find-production)

(define-key mouse-map x-button-c-m-left-up   'sde-x-eval-production)
(define-key mouse-map x-button-c-m-middle-up 'sde-x-ptrace-production)
(define-key mouse-map x-button-c-m-right-up  'sde-x-pbreak-production)
