/* 
 * $Id: rete.c,v 1.1 1993/06/17 20:47:51 jtraub Exp $
 * $Log: rete.c,v $
 * Revision 1.1  1993/06/17  20:47:51  jtraub
 * Released
 *
 * Revision 0.1  1993/06/17  20:23:59  jtraub
 * 6.1_checkin
 *
 * Revision 9.3  1993/06/14  20:07:02  jtraub
 * added MS printing enhancement.
 *
 * Revision 9.2  1993/05/10  18:45:25  jtraub
 * added RCS header information
 *
 */

/* ======================================================================

		      Rete Net Routines for Soar 6

====================================================================== */

#include "soar.h"

/* Uncomment the following line to get instantiation printouts */
/* #define DEBUG_INSTANTIATIONS */

/* Uncomment the following line to get pnode printouts */
/* #define DEBUG_RETE_PNODES */

/* Comment out the following line to avoid right mem unlinking */
#define DO_RIGHT_UNLINKING

/* Comment out the following line to avoid the overhead of keeping statistics
   on token changes */
/* #define TOKEN_STATS */


/* ----------------------------------------------------------------------

		 Rete Net Structures and Declarations

---------------------------------------------------------------------- */

/* --- dll of all wmes currently in the rete:  this is needed to
       initialize newly created alpha memories --- */



/* --- hash tables in which all the alpha memories are stored --- */


/* --- types of tests found at beta nodes --- */
#define CONSTANT_RELATIONAL_RETE_TEST 0x00
#define VARIABLE_RELATIONAL_RETE_TEST 0x10
#define DISJUNCTION_RETE_TEST         0x20
#define ID_IS_GOAL_RETE_TEST          0x30
#define ID_IS_IMPASSE_RETE_TEST       0x31
#define test_is_constant_relational_test(x) (((x) & 0xF0)==0x00)
#define test_is_variable_relational_test(x) (((x) & 0xF0)==0x10)

/* --- for the last two (i.e., the relational tests), we add in one of
       the following, to specifiy the kind of relation --- */
#define RELATIONAL_EQUAL_RETE_TEST            0x00
#define RELATIONAL_NOT_EQUAL_RETE_TEST        0x01
#define RELATIONAL_LESS_RETE_TEST             0x02
#define RELATIONAL_GREATER_RETE_TEST          0x03
#define RELATIONAL_LESS_OR_EQUAL_RETE_TEST    0x04
#define RELATIONAL_GREATER_OR_EQUAL_RETE_TEST 0x05
#define RELATIONAL_SAME_TYPE_RETE_TEST        0x06
#define kind_of_relational_test(x) ((x) & 0x0F)
#define test_is_not_equal_test(x) (((x)==0x01) || ((x)==0x11))

/* define an equality predicate for var_location structures */
#define var_locations_equal(v1,v2) \
  ( ((v1).levels_up==(v2).levels_up) && ((v1).field_num==(v2).field_num) )

/* --- extract field (id/attr/value) from wme --- */
/* WARNING: this relies on the id/attr/value fields being consecutive in
   the wme structure (defined in soar.h) */
#define field_from_wme(wme,field_num) \
  ( (&((wme)->id))[(field_num)] )
				    
/* --- types and structure of beta nodes --- */

#define DUMMY_TOP_BNODE 0
#define POSITIVE_BNODE 1
#define UNHASHED_POSITIVE_BNODE 2
#define NEGATIVE_BNODE 3
#define UNHASHED_NEGATIVE_BNODE 4
#define CN_BNODE 5
#define CN_PARTNER_BNODE 6
#define P_BNODE 7
#define DUMMY_MATCHES_BNODE 8

#define NUM_BNODE_TYPES 9
#define bnode_is_positive(x) (((x)>=1)&&((x)<=2))
#define bnode_is_negative(x) (((x)>=3)&&((x)<=4))
#define bnode_is_normal(x)   (((x)>=1)&&((x)<=4))
#define bnode_is_hashed(x)   (((x)==1)||((x)==3))


/* --- macros for unlinking beta nodes from their right memories --- */
#define DONT_RIGHT_UNLINK 1
#define RIGHT_LINKED 2
#define RIGHT_UNLINKED 3

#define relink_to_right_mem(node) { \
  insert_at_head_of_dll ((node)->d.norm.alpha_mem->beta_nodes, (node), \
			 d.norm.next_from_alpha_mem, \
			 d.norm.prev_from_alpha_mem); \
  (node)->right_mem_link_status = RIGHT_LINKED; }

#define unlink_from_right_mem(node) { \
  remove_from_dll ((node)->d.norm.alpha_mem->beta_nodes, (node), \
		   d.norm.next_from_alpha_mem, \
		   d.norm.prev_from_alpha_mem); \
  (node)->right_mem_link_status = RIGHT_UNLINKED; }

#define address_of_bucket_header_cell(t,hv) \
  ( (t)->buckets + ((hv)&masks_for_n_low_order_bits[(t)->log2size]) )

#define contents_of_bucket_header_cell(t,hv) \
  (* (address_of_bucket_header_cell((t),(hv))))

#define insert_into_hash_table(t,item,hv) { \
  void **header_zy37; \
  header_zy37 = address_of_bucket_header_cell((t),(hv)); \
  (item)->next_in_bucket = *header_zy37; \
  (t)->count++; \
  *header_zy37 = (item); }

void init_token_hash_table (token_hash_table *ht, short minimum_log2size) {
  ht->count = 0;
  ht->size = (((unsigned long)1) << minimum_log2size);
  ht->log2size = minimum_log2size;
  ht->minimum_log2size = minimum_log2size;
  ht->buckets = allocate_memory_and_zerofill (sizeof(char *) * ht->size,
					      HASH_TABLE_MEM_USAGE);
}



/* --- beta node routines for left/right token/wme changes --- */
void (*(left_addition_routines[NUM_BNODE_TYPES])) (rete_node *node,
						   token *tok,
						   wme *w);
void (*(left_removal_routines[NUM_BNODE_TYPES])) (rete_node *node,
						  token *t,
						  wme *w);
void (*(right_addition_routines[NUM_BNODE_TYPES])) (rete_node *node, wme *w);
void (*(right_removal_routines[NUM_BNODE_TYPES])) (rete_node *node, wme *w);


#ifdef TOKEN_STATS
#define token_added() { current_agent(token_additions)++; }
#define token_deleted() { current_agent(token_deletions)++; }
#else
#define token_added() {}
#define token_deleted() {}
#endif

/* ----------------------------------------------------------------------

			   Match Set Changes

---------------------------------------------------------------------- */

bool any_assertions_or_retractions_ready (void) {
  return (current_agent(ms_assertions) || current_agent(ms_retractions));
}

bool get_next_assertion (production **prod,
			 struct token_struct **tok,
			 wme **w) {
  ms_change *msc;

  if (! current_agent(ms_assertions)) return FALSE;
  msc = current_agent(ms_assertions);
  remove_from_dll (current_agent(ms_assertions), msc, next, prev);
  remove_from_dll (msc->p_node->d.p.tentative_assertions, msc,
		   next_of_node, prev_of_node);
  *prod = msc->p_node->d.p.prod;
  *tok = msc->tok;
  *w = msc->w;
  free_with_pool (&current_agent(ms_change_pool), msc);
  return TRUE;
}

bool get_next_retraction (instantiation **inst) {
  ms_change *msc;

  if (! current_agent(ms_retractions)) return FALSE;
  msc = current_agent(ms_retractions);
  remove_from_dll (current_agent(ms_retractions), msc, next, prev);
  if (msc->p_node)
    remove_from_dll (msc->p_node->d.p.tentative_retractions, msc,
		     next_of_node, prev_of_node);
  *inst = msc->inst;
  free_with_pool (&current_agent(ms_change_pool), msc);
  return TRUE;
}

/* ----------------------------------------------------------------------
		    Alpha Portion of the Rete Net

The alpha (top) part of the rete net consists of the alpha memories.
Each of these memories is stored in one of 16 hash tables, depending
on which fields it tests:

      bit 0 (value 1) indicates it tests the id slot
      bit 1 (value 2) indicates it tests the attr slot
      bit 2 (value 4) indicates it tests the value slot
      bit 3 (value 8) indicates it tests for an acceptable preference

The hash tables are dynamically resized hash tables.
---------------------------------------------------------------------- */

#define wme_matches_alpha_mem(w,am) ( \
  (((am)->id==NIL) || ((am)->id==(w)->id)) && \
  (((am)->attr==NIL) || ((am)->attr==(w)->attr)) && \
  (((am)->value==NIL) || ((am)->value==(w)->value)) && \
  ((am)->acceptable==(w)->acceptable))

#define alpha_hash_value(i,a,v,num_bits) \
 ( ( ((i) ? ((Symbol *)(i))->common.hash_id : 0) ^ \
     ((a) ? ((Symbol *)(a))->common.hash_id : 0) ^ \
     ((v) ? ((Symbol *)(v))->common.hash_id : 0) ) & \
   masks_for_n_low_order_bits[(num_bits)] )

/* --- rehash funciton for resizable hash table routines --- */
unsigned long hash_alpha_mem (void *item, short num_bits) {
  alpha_mem *am;

  am = item;
  return alpha_hash_value (am->id, am->attr, am->value, num_bits);
}

#define table_for_tests(id,attr,value,acceptable) \
  current_agent(alpha_hash_tables) [ ((id) ? 1 : 0) + ((attr) ? 2 : 0) + ((value) ? 4 : 0) + \
		      ((acceptable) ? 8 : 0) ]

#define get_next_alpha_mem_id() (current_agent(alpha_mem_id_counter)++)

void init_new_alpha_mem (alpha_mem *am, Symbol *id, Symbol *attr,
			 Symbol *value, bool acceptable) {
  am->next_in_hash_table = NIL;
  am->right_mems = NIL;
  am->beta_nodes = NIL;
  am->reference_count = 1;
  am->id = id;
  am->attr = attr;
  am->value = value;
  am->acceptable = acceptable;
  am->am_id = get_next_alpha_mem_id();
}

void add_wme_to_alpha_mem (wme *w, alpha_mem *am) {
  right_mem *rm;
  unsigned long hv;

  allocate_with_pool (&current_agent(right_mem_pool), &rm);
  rm->rmi.am = am;
  rm->rmi.w = w;
  hv = am->am_id ^ w->id->common.hash_id;
  insert_into_hash_table (&current_agent(right_ht), &(rm->rmi), hv);
  insert_at_head_of_dll (am->right_mems, rm, next, prev);
}

void remove_wme_from_alpha_mem (wme *w, alpha_mem *am) {
  right_mem_item *rmi, **prev_rmi_pointer;
  right_mem *rm;
  int offset_of_rmi_in_rm;
  unsigned long hv;

  rm = NIL;     /* Added to placate the native HP cc */
  
  hv = am->am_id ^ w->id->common.hash_id;
  prev_rmi_pointer =
    (right_mem_item **) address_of_bucket_header_cell (&current_agent(right_ht), hv);
  while (TRUE) {
    rmi = *prev_rmi_pointer;
    if ((rmi->am == am) && (rmi->w == w)) break;
    prev_rmi_pointer = &(rmi->next_in_bucket);
  }

  *prev_rmi_pointer = rmi->next_in_bucket;

  offset_of_rmi_in_rm = (char *)(&(rm->rmi)) - (char *)(rm);
  rm = (right_mem *) ( ((char *)rmi) - offset_of_rmi_in_rm );
  remove_from_dll (am->right_mems, rm, next, prev);
  free_with_pool (&current_agent(right_mem_pool), rm);
}

alpha_mem *find_alpha_mem (Symbol *id, Symbol *attr,
			   Symbol *value, bool acceptable) {
  hash_table *ht;
  alpha_mem *am;
  unsigned long hash_value;

  ht = table_for_tests (id, attr, value, acceptable);
  hash_value = alpha_hash_value (id, attr, value, ht->log2size);

  for (am = (alpha_mem *) (*(ht->buckets+hash_value)); am!=NIL;
       am=am->next_in_hash_table)
    if ((am->id==id) && (am->attr==attr) &&
	(am->value==value) && (am->acceptable==acceptable))
      return am;
  return NIL;
}

alpha_mem *find_or_make_alpha_mem (Symbol *id, Symbol *attr,
				   Symbol *value, bool acceptable) {
  hash_table *ht;
  alpha_mem *am, *more_general_am;
  wme *w;
  right_mem *rm;

  /* --- look for an existing alpha mem --- */
  am = find_alpha_mem (id, attr, value, acceptable);
  if (am) {
    am->reference_count++;
    return am;
  }
  
  /* --- no existing alpha_mem found, so create a new one --- */
  allocate_with_pool (&current_agent(alpha_mem_pool), &am);
  init_new_alpha_mem (am, id, attr, value, acceptable);
  if (id) symbol_add_ref (id);
  if (attr) symbol_add_ref (attr);
  if (value) symbol_add_ref (value);
  ht = table_for_tests (id, attr, value, acceptable);
  add_to_hash_table (ht, am);
  
  /* --- fill new mem with any existing matching WME's --- */
  more_general_am = NIL;
  if (id)
    more_general_am = find_alpha_mem (NIL, attr, value, acceptable);
  if (!more_general_am && value)
    more_general_am = find_alpha_mem (NIL, attr, NIL, acceptable);
  if (more_general_am) {
    /* --- fill new mem using the existing more general one --- */
    for (rm=more_general_am->right_mems; rm!=NIL; rm=rm->next)
      if (wme_matches_alpha_mem (rm->rmi.w, am))
	add_wme_to_alpha_mem (rm->rmi.w, am);
  } else {
    /* --- couldn't find such an existing mem, so do it the hard way --- */
    for (w=current_agent(all_wmes_in_rete); w!=NIL; w=w->rete_next)
      if (wme_matches_alpha_mem (w,am)) add_wme_to_alpha_mem (w, am);
  }
  
  return am;
}

void remove_ref_to_alpha_mem (alpha_mem *am) {
  hash_table *ht;
 
  am->reference_count--;
  if (am->reference_count!=0) return;
  /* --- remove from hash table, and deallocate the alpha_mem --- */
  ht = table_for_tests (am->id, am->attr, am->value, am->ac