;;
;; $Id: default.soar6,v 1.1 1993/06/17 20:46:52 jtraub Exp $
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Soar -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 
;; File            : default.soar
;; Author          : John Laird
;; Created on      : Mon Feb 27 16:15:34 1989  
;; Last Modified By: Bob Doorenbos
;; Last Modified On: Tue Aug 25
;; 
;; Contents:     Default productions for Soar 5.2
;;               These are already loaded in released versions.
;;
;;               Converted to Soar 6.0 by Bob Doorenbos
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;
;;;		i.	Table of Contents
;;;
;;;	i.	Table of Contents
;;;	ii.	Change Log
;;;	iv.	Possible Problems
;;;	0.	Start-default
;;;	7.1	Default knowledge for the top context
;;;		A	default*top-goal*elaborate*goal*name*top-goal
;;;		B.	default*top-goal*propose*space*top-ps
;;;		C.	default*top-ps*propose*state*top-state
;;;		D.	default*top-ps*propose*operator*wait
;;;		E.	default*terminate*operator*wait
;;;		F.	default*top-goal*halt*goal*no-change
;;;		G.	default*top-goal*halt*space*constraint-failure
;;;	7.2	Default knowledge for impasses
;;;     7.2.1   Multi-choice impasses
;;;		A.	default*select*attribute*indifferent-and-worst*tied 
;;;		B.	default*select*attribute*reject-and-reconsider*conflict
;;;     7.2.2   Operator no-change impasses
;;;		
;;;     7.2.3   Other no-change impasses
;;;	        A.      default*select*attribute*reject-and-reconsider*choices-none
;;;		
;;;     7.2.4   Constraint-failure impasses
;;;		A.	default*select*attribute*reject-and-reconsider*constraint-failure
;;;		B.	default*select*space*reject-and-reconsider*state-constraint-failure
;;;		C.	default*select*state*reject-and-reconsider*operator-constraint-failure
;;;
;;;	7.3	The selection space for multi-choice impasses
;;;		A.	default*selection*propose*space*selection
;;;		B.	default*selection*propose*initial-state
;;;		C.	default*selection*elaborate*goal*with-found-value-true
;;;		D.	default*selection*elaborate*goal*with-wait-true-not-all-objects-evaluated
;;;
;;;     7.3.1	The evaluate-object operator
;;;		A.	default*selection*propose*operator*evaluate-object
;;;		B.	default*selection*select*operator*evaluate-object*indifferent
;;;		C.	default*selection*elaborate*operator*evaluate-object*type-evaluation
;;;		D.	default*implement*evaluation-operator*augment-operator-with-evaluation
;;;		E.	default*implement*evaluation-operator*augment-operator-with-desired
;;;		F.	default*implement*evaluation-operator*augment-operator-with-superproblem-space
;;;		G.	default*implement*evaluation-operator*augment-operator-with-superstate
;;;		H.	default*implement*evaluation-operator*augment-operator-with-attribute
;;;		I.	default*selection*implement*evaluation-operator*augment-operator-with-evaluation-type-final-all-objects-novalue
;;;
;;;     7.3.1.1 Evaluation Objects
;;;		A.	default*generic*elaborate*state*evaluation-numeric-or-symbolic-value-to-value-t
;;;		B.	default*generic*elaborate*state*evaluation-gets-supergoals-desired
;;;		C.	default*implement*evaluation-operator*augment-evaluation-with-object
;;;		D.	default*implement*evauate-object*augment-evaluation-with-type-of-operator-name
;;;
;;;     7.3.1.2 Applying the evaluate-object operator
;;;		A.	default*terminate*evaluate-object
;;;
;;;     7.3.2   The evaluation subgoal
;;;		A.	default*implement*evaluation-operator*augment-goal-with-desired
;;;		B.	default*elaborate*goal*implement-evaluate-object*with-name-implement-evaluate-object
;;;		C.	default*generic*propose*space*generic*on-no-change-for-evaluation-operator
;;;		D.	default*generic*propose*state*evaluation-operator-no-duplicate-state
;;;		E.	default*generic*propose*state*evaluation-operator-duplicate-state
;;;		F.	default*generic*propose*state*evaluation-operator-no-duplicate-operator
;;;		G.	default*generic*propose*operator*evaluation-operator-look-ahead--operator-duplicate
;;;		H.	default*generic*elaborate*goal*evaluation-goal*look-ahead-operator
;;;		I.	default*generic*propose*operator*look-ahead
;;;		J.	default*generic*implement*operator*duplicate-look-ahead-tried-tied-operator
;;;		K.	default*generic*implement*operator*no-duplicate-look-ahead-tried-tied-operator
;;;		L.	default*generic*implement*evaluation-operator*evaluation-failure-if-no-operators-for-state
;;;		M.	default*generic*implement*evaluation-operator*evaluation-failure-if-prohibit-state
;;;		N.	default*generic*implement*evaluation-operator*state-to-symbolic-evaluation
;;;		O.	default*generic*implement*evaluation-operator*state-to-symbolic-evaluation*duplicate-desired
;;;
;;;     7.3.2.1 State copying
;;;		A.	default*generic*elaborate*operator*type-evaluation*default-for-default-state-copy-is-yes
;;;		B.	default*generic*elaborate*operator*type-evaluation*default-state-copy-from-problem-space
;;;		C.	default*generic*elaborate*goal*default-state-copy-from-type-evaluation-operator
;;;		D.	default*generic*elaborate*goal*default-copy-is-all-attributes-at-level-one
;;;		E.	default*generic*elaborate*goal*copy-all-attributes-at-level-one-from-problem-space
;;;		F.	default*generic*propose*state*initial*require-duplicate-state 
;;;		G.	default*generic*elaborate*goal*create-duplicates-table
;;;		H.	default*generic*elaborate*state*add-one-level-attributes
;;;		I.	default*generic*elaborate*state*add-all-attributes-at-level-one
;;;		J.	default*generic*elaborate*state*change-one-level-attribute-to-duplicate
;;;		K.	default*generic*elaborate*state*change-all-attributes-at-level-one-to-duplicate
;;;		L.	default*generic*elaborate*goal*duplicate-id-for-attribute
;;;		M.	default*generic*elaborate*goal*duplicate-id-for-all-attributes
;;;		N.	default*generic*elaborate*add-attribute-to-duplicate
;;;		O.	default*generic*elaborate*add-duplicated-attribute-to-duplicate
;;;		P.	default*generic*elaborate*state*add-duplicate-to-state
;;;		Q.	default*generic*elaborate*state*add-duplicates-for-all-attributes
;;;		R.	default*elaborate*goal*eval*desired
;;;		S.	default*state-to-symbolic-evaluation*duplicate-desired
;;;		T.	default*duplicate-desired*copy-old-value
;;;		U.	default*duplicate-desired*replace-old-value
;;;
;;;     7.3.2.3 Operator copying
;;;		B.	default*generic*elaborate*operator*type-evaluation*default-for-default-operator-copy-is-yes
;;;		C.	default*generic*elaborate*operator*type-evaluation*copy-default-operator-copy-from-problem-space
;;;		D.	default*generic*elaborate*goal*copy-default-operator-copy-from-type-evaluation-operator
;;;		A.	default*generic*elaborate*goal*create-duplicates-table-for-operator-only
;;;		E.	default*generic*elaborate*operator*add-attribute-to-duplicate-operator
;;;		F.	default*generic*elaborate*operator*add-duplicated-attribute-to-duplicate-operator
;;;
;;;     7.3.3   Computing evaluations
;;;     7.3.3.1 Computing numeric evaluations
;;;     7.3.3.2 Comparing numeric Evaluations
;;;		A.	default*selection*compare*equal-evaluation-indifferent
;;;		B.	default*selection*compare*higher-evaluation-better
;;;		C.	default*selection*compare*prefer-lower-evaluation
;;;		
;;;     7.3.3.3 Computing symbolic evaluations
;;;		A.	default*selection*compare*same-symbolic-evaluations-are-indifferent
;;;		B.	default*selection*compare*success-evaluation-better-than-partial-success
;;;		C.	default*selection*compare*partial-failure-evaluation-better-than-failure
;;;		D.	default*selection*select*required-success-evaluation-becomes-required-preference
;;;		E.	default*selection*select*success-evaluation-becomes-best-preference
;;;		F.	default*selection*select*indifferent-evaluation-becomes-indifferent-preference
;;;		G.	default*selection*select*partial-failure-evaluation-becomes-worst-preference
;;;		H.	default*selection*select*failure-evaluation-becomes-reject-preference
;;;		I.	default*selection*select*prohibit-failure-evaluation-becomes-prohibit-preference
;;;
;;;     7.3.3.4 Default evaluations
;;;		A.	default*pass-back-success
;;;             B.      default*failure-if-no-operators-for-state 
;;;             C.      default*failure-if-prohibit-state 
;;;
;;;     7.3.3.5 Novalue evaluations
;;;		A.	default*selection*compare*novalue-evaluation-always-worse
;;;
;;;     7.3.4   Halting Soar with success or failure
;;;		A.	default*top-goal*halt*state*success
;;;		B.	default*top-goal*halt*state*failure
;;;
;;;     7.4     Operator subgoaling
;;;		A.	default*generic*opsub*propose*space*generic
;;;		B.	default*generic*opsub*elaborate*goal*name*operator-subgoal
;;;		C.	default*generic*opsub*elaborate*goal*desired
;;;		D.	default*generic*opsub*state*initial-state*require
;;;		E.	default*generic*opsub*goal*elaborate*all-desireds
;;;		F.	default*generic*select*operator*reject-desired
;;;		G.	default*generic*opsub*detect*state*success
;;;
;;;     7.5     Execution monitoring
;;;		A.	default*monitor*goal*success
;;;		B.	default*monitor*goal*failure
;;;		C.	default*monitor*operator*evaluation
;;;		D.	default*monitor*attribute-impasses
;;;
;;;	16.	Stop-default

;;;
;;;		ii.	 Change Log
;;;

;; Change log for Soar 5.2.
;; 65. Removed default*generic*implement*evaluation-operator*evaluation-partial-success-if-partial-success-look-ahead-state-found
;;      (formerly in section 7.3.2.N), as it was identical to
;;      default*pass-back-success. -- TFMcG 20-Jun-91
;; 66. At the advice of JEL, replaced tests for implement-evaluate-object with
;;      superproblem-space tests in default*generic*elaborate*state*add-one-level-attributes, and
;;      default*generic*elaborate*state*add-all-attributes-at-level-one;
;;      added the superproblem-space test to default*generic*propose*operator*evaluation-operator-look-ahead--operator-duplicate, and
;;      default*generic*elaborate*goal*evaluation-goal*look-ahead-operator
;;      -- TFMcG 24-Jun-91
;; 67. Added default*generic*implement*evaluation-operator*state-to-symbolic-evaluation*duplicate-desired,
;;      7.3.2.O to provide correct support for duplicate desireds
;;      -- TFMcG 24-Jun-91
;; 68. At JEL's advise, made the new versions of default*generic*elaborate*state*add-one-level-attributes
;;      and default*generic*elaborate*state*add-all-attributes-at-level-one
;;      -- TFMcG 26-Jun-91
;; 69. Changed evaluate-rejected to evaluate-dominated in
;;      default*selection*elaborate*operator*evaluate-object*type-evaluation
;;      -- TFMcG 26-Jun-91
;; 70. Added test for selection space to default*selection*implement*evaluation-operator*augment-operator-with-evaluation-type-final-all-objects-novalue
;;      in response to bug #249 -- TFMcG 10-Jul91
;; 71. Changed default*generic*propose*operator*evaluation-operator-look-ahead--operator-duplicate
;;      to test that the problem-space and superproblem-space have the same
;;      ^name, thought they might have different IDs -- TFMcG 22-Aug-91
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;
;;;		iv.	Possible Problems
;;;
;;;	The default knowledge has a mind set that all evaluate-object operators
;;; will either be directly implemented, or will be implemented in a subspace
;;; that is performing look ahead style evaluation.  This should be checked to
;;; see if it causes errors.
;;;
;;;	There is still one opp-app declaration, due to a bug in support classification.
;;;
;;;	Evaluate-rejected and evaluate-primary are still in this knowledge as
;;; operator names, but are not proposed by this knowledge.
;;;
;;;	Operator subgoaling has known outstanding problems.
;;;

;;;
;;;		0.	Start Default 
;;; Declare that all of the productions between this call and a call to
;;; stop-default are the default productions.


;;;
;;;		7.1	Default knowledge for the top context
;;;

;;;			A.	default*top-goal*elaborate*goal*name*top-goal
;; Elaborate the top goal with name top-goal.  
;; Make it worst so it will be overridden by all other names.

(sp default*top-goal*elaborate*goal*name*top-goal
    "Propose top-goal as name of top goal. Make it worst."
    :default
    (goal <g> ^object nil)
    -->
    (<g> ^name top-goal + <))

;;;			B.	default*top-goal*propose*space*top-ps
;; Propose the top problem space, top-ps.
;; Make it worst so it will only be selected if there are no others.
;; Augment goal with a desired.  Necessary for look-ahead.
;; Other productions can elaborate the desired later.

(sp default*top-goal*propose*space*top-ps
   "Propose top-ps as problem space for goal top-goal."
   :default
   (goal <g> ^object nil ^name top-goal )
    -->
   (<g> ^problem-space <p> + <, ^desired <d> + <)
   (<p> ^name top-ps))

;;;			C.	default*top-ps*propose*state*top-state
;; Propose an initial top-level state only if in top-ps.
;; Elaborate state with io-state pointer.

(sp default*top-ps*propose*state*top-state
  "Propose and elaborate the initial state in the top problem space."
   :default
  (goal <g> ^problem-space <p> ^name top-goal)
  (<p> ^name top-ps)
  -->
  (<g> ^state <s> <s> <)
  (<s> ^io-state <s> ^name top-state))

;;;			D.	default*top-ps*propose*operator*wait 
;;; Make wait always acceptable in the top-ps problem space.

(sp default*top-ps*propose*operator*wait
  "Propose operator wait whenever in problem space top-ps."
  :default
  (goal <g> ^problem-space <p> ^state <s>)
  (<p> ^name top-ps)
  -->
  (<g> ^operator <o> <o> <)
  (<o> ^name wait))

;;;			E.	default*terminate*operator*wait
;;; Terminate wait as soon as it is selected so that another
;;; operator can be selected if situation changes.

(sp default*terminate*operator*wait 
  "Terminate wait as soon as it is selected."
  :default
  (goal <g> ^state <s> ^operator <o>)
  (<o> ^name wait)
  -->
  (<g> ^operator <o> @))

;;;			F.	default*top-goal*halt*goal*no-change
;;; If no problem spaces are available for the top goal -
;;; terminate the problem solving session with halt.

(sp default*top-goal*halt*goal*no-change
    "Halt if no problem space can be selected for the top goal."
    :default
    (goal <g2> ^object nil)
    (goal <g3> ^attribute goal ^choices none ^object <g2>)
    -->
    (write (crlf)  | | |No problem space can be selected for top goal.| | | )
    (write (crlf)  | | |Soar must halt.| | | )
    (halt))

;;;			G.	default*top-goal*halt*space*constraint-failure

(sp default*top-goal*halt*space*constraint-failure
    "Halt if no problem space can be selected for top goal."
    :default
    (goal <g2> ^object nil)
    (goal <g3> ^attribute problem-space ^impasse constraint-failure ^object <g2>)
    -->
    (write (crlf)  | | |No problem space can be selected for top goal.| | | )
    (write (crlf)  | | |Soar must halt.| | | )
    (halt))


;;;
;;;		7.2	Default knowledge for impasses
;;;


;;;
;;;		7.2.1	Multi-choice impasses 
;;;

;;;			A.	default*select*attribute*indifferent-and-worst*tied
;;; If the problem space for handling the subgoal fails, signified by the 
;;; choices none impasse below it, make an indifferent and worst-preference 
;;; for each tied object.

(sp default*select*attribute*indifferent-and-worst*tied
    "Indifferent an object if it leads to a tie that can be solved."
    :default
    (goal <g3> ^attribute goal ^choices none ^object <g2> ^quiescence t)
    (goal <g2> ^attribute <att> ^object <g1>
	  ^item <obj> ^quiescence t ^impasse tie)
    (goal <g1> ^ <att> <obj> +)
     -->
    (<g1> ^ <att> <obj> =, < ))


;;;			B.	default*select*attribute*reject-and-reconsider*conflict
;;; If the problem space for handling the subgoal fails, signified by 
;;; the choices none impasse below it, make a reject-preference for each 
;;; conflicted object.

(sp default*select*attribute*reject-and-reconsider*conflict
   "Reject an object if it leads to a conflict that can be solved."
    :default
 (goal <g3> ^attribute goal ^choices none ^object <g2> ^quiescence t)
 (goal <g2> ^attribute <att> ^object <g1>
   ^item <obj> ^quiescence t ^impasse conflict)
 (goal <g1> ^ <att> <obj> +)
-->
 (<g1> ^<att> <obj> - @ ))


;;;
;;;	     7.2.2   Operator no-change impasses
;;;
;;; See operator subgoaling, as this is the default action here.

;;;		
;;;     	7.2.3   Other no-change impasses
;;;

;;;			A.	default*select*attribute*reject-and-reconsider*choices-none
;;; If no objects are available for a slot, and there is no problem space to 
;;; find more, reject next higher object.

(sp default*select*attribute*reject-and-reconsider*choices-none
    "Reject an object if it leads to a no-change that cannot be solved."
    :default
    (goal <g3> ^attribute goal ^choices none ^object <g2> ^quiescence t)
    (goal <g2> ^attribute <att> ^choices none ^object <g1> ^quiescence t)
    (goal <g1> ^<att> <obj>)
    -->
    (<g1> ^<att> <obj> - @))


;;;		
;;;     	7.2.4   Constraint-failure impasses
;;;

;;;			A.	default*select*attribute*reject-and-reconsider*constraint-failure
;;; If there is a constraint-failure for a problem space, below an object, 
;;; reject that object.

(sp default*select*attribute*reject-and-reconsider*constraint-failure
    :default
    (goal <g2> ^attribute problem-space ^impasse constraint-failure
	^object <g1> ^quiescence t)
    (goal <g1> ^object <g0> ^attribute <att> ^choices none)
    (goal <g0> ^<att> <p0>)
    -->
    (<g0> ^<att> <p0> - @))

;;;			B.	default*select*space*reject-and-reconsider*state-constraint-failure
;;; If there is a constraint-failure for a state, reject its problem space.

(sp default*select*space*reject-and-reconsider*state-constraint-failure
    :default
    (goal <g2> ^attribute state ^impasse constraint-failure ^object <g1> 
               ^quiescence t)
    (goal <g1> ^problem-space <p>)
    -->
    (<g1> ^problem-space <p> - @))

;;;			C.	default*select*state*reject-and-reconsider*operator-constraint-failure

(sp default*select*state*reject-and-reconsider*operator-constraint-failure
    :default
    (goal <g2> ^attribute operator ^impasse constraint-failure ^object <g1> 
               ^quiescence t)
    (goal <g1> ^state <s>)
     -->
    (<g1> ^state <s> - @ ))


;;;
;;;		7.3	The selection space for multi-choice impasses
;;;


;;;			A.	default*selection*propose*space*selection
;;; Use the selection problem space for all choice multiple, impasses 
;;; - make it worst so that any other will dominate.

(sp default*selection*propose*space*selection
    :default
    (goal <g> ^choices multiple)
    -->
    (<g> ^problem-space <p> + <p> < )
    (<p> ^name selection))

;;;			B.	default*selection*propose*initial-state
;;; The state of the selection problem space will contain evaluations.

(sp default*selection*propose*initial-state
    :default
   (goal <g> ^problem-space <p>) 
   (<p> ^name selection)
   -->
   (<g> ^state <s> + ))

;;;			C.	default*selection*elaborate*goal*with-found-value-true
;;; Signal that a value other than novalue has been assigned.

(sp default*selection*elaborate*goal*with-found-value-true
    :default
 (goal <g> ^problem-space <p> ^state <s> ^choices multiple)
 (<p> ^name selection)
 (<s> ^evaluation <e>)
 (<e> ^ << numeric-value symbolic-value >> <> novalue)
-->
 (<g> ^found-value true))


;;;			D.	default*selection*elaborate*goal*with-wait-true-not-all-objects-evaluated
;;; Signal that there are still objects to evaluate.

(sp default*selection*elaborate*goal*with-wait-true-not-all-objects-evaluated
    :default
	(goal <g> ^problem-space <p> ^state <s> ^operator <o> +
		^choices multiple)
	- {(<o> ^type evaluation ^evaluation <e>)
	   (<e> ^ << numeric-value symbolic-value >> )}
	(<p> ^name selection)
	-->
	(<g> ^wait true))

;;;
;;;		7.3.1	The evaluate-object operator
;;;

;;;			A.	default*selection*propose*operator*evaluate-object
;;; Create evaluate operator in selection problem space.

(sp default*selection*propose*operator*evaluate-object
    :default
   (goal <g> ^problem-space <p> ^state <s> ^item <x>)
   (<p> ^name selection) 
 -{(<s> ^evaluation <e>)
   (<e> ^object <x> ^value t)}
   -->
   (<o> ^state <s> ^name evaluate-object ^object <x>)
   (<g> ^operator <o> +))


;;;			B.	default*selection*select*operator*evaluate-object*indifferent
;;; Make them indifferent if not ^operator-selection not-indifferent.

(sp default*selection*select*operator*evaluate-object*indifferent
    :default
   (goal <g> ^problem-space <p> ^operator <o> +)
   (<p> ^name selection - ^operator-selection not-indifferent)
   (<o> ^name evaluate-object)
   -->
   (<g> ^operator <o> =))

;;;			C.	default*selection*elaborate*operator*evaluate-object*type-evaluation
;;; Label all evaluation operators with ^type evaluation.
;;; Changed evaluate-rejected to evaluate-dominated -- JEL/tfm 26-Jun-91

(sp default*selection*elaborate*operator*evaluate-object*type-evaluation 
    :default
   (goal <g> ^state <s> ^operator <o>)
   (<o> ^name << evaluate-object evaluate-dominated evaluate-primary >> )
   -->
   (<o> ^type evaluation))    

;;;			D.	default*implement*evaluation-operator*augment-operator-with-evaluation
;;; Create evaluation once the eval operator is selected.
 
(sp default*implement*evaluation-operator*augment-operator-with-evaluation
    :default
   (goal <g> ^state <s> ^operator <o>)
   (<o> ^type evaluation)
   -->
   (<s> ^evaluation <e> + &) 
   (<e> ^state <s> ^operator <o>)
   (<o> ^evaluation <e>))

;;;			E.	default*implement*evaluation-operator*augment-operator-with-desired 

(sp default*implement*evaluation-operator*augment-operator-with-desired
    :default
   (goal <g> ^operator <o> ^object <g2>)
   (goal <g2> ^desired <d>)
   (<o> ^evaluation <e> ^type evaluation)
   -->
   (<o> ^desired <d> + &))

;;;			F.	default*implement*evaluation-operator*augment-operator-with-superproblem-space

(sp default*implement*evaluation-operator*augment-operator-with-superproblem-space
    :default
   (goal <g> ^problem-space <p> ^operator <o> ^object <g2>)
   (<p> ^name selection)      
   (goal <g2> ^problem-space <p2>)
   (<o> ^type evaluation)
    -->
   (<o> ^superproblem-space <p2>))

;;;			G.	default*implement*evaluation-operator*augment-operator-with-superstate

(sp default*implement*evaluation-operator*augment-operator-with-superstate
    :default
   (goal <g> ^problem-space <p> ^operator <o> ^object <g2>)
   (<p> ^name selection)
   (goal <g2> ^state <s2>)
   (<o> ^type evaluation)
   -->
   (<o> ^superstate <s2>))

;;;			H.	default*implement*evaluation-operator*augment-operator-with-attribute

(sp default*implement*evaluation-operator*augment-operator-with-attribute
    :default
   (goal <g> ^problem-space <p> ^operator <o> ^attribute <attribute>)
   (<p> ^name selection)
   (<o> ^type evaluation)
   -->
   (<o> ^attribute <attribute>))  

;;;			I.	default*selection*implement*evaluation-operator*augment-operator-with-evaluation-type-final-all-objects-novalue
;;; If all objects have been evaluated, and all have value novalue, and
;;; there is a object being evaluated in a higher context, assign that
;;; object novalue.

(sp default*selection*implement*evaluation-operator*augment-operator-with-evaluation-type-final-all-objects-novalue
    :default
	(goal <g> ^object <sg> ^state <s> ^operator <o>
		- ^wait - ^found-value ^quiescence t ^choices multiple)
	(goal <sg> ^object <ssg>)
	(goal <ssg> ^problem-space <ssp> ^operator <sso>)
	(<sso> ^type evaluation)
	(<ssp> ^name selection)
	-->
	(<sso> ^numeric-value novalue ^evaluation-type final))


;;;
;;;		7.3.1.1 Evaluation Objects
;;;
;;;			A.	default*generic*elaborate*state*evaluation-numeric-or-symbolic-value-to-value-t
;;; label all evaluations with value t

(sp default*generic*elaborate*state*evaluation-numeric-or-symbolic-value-to-value-t
    :default
   (goal <g> ^problem-space <p> ^state <s>)
   (<s> ^evaluation <e>)
   (<e> ^ << numeric-value symbolic-value >>)
   -->
   (<e> ^value t))

;;;			B.	default*generic*elaborate*state*evaluation-gets-supergoals-desired 

(sp default*generic*elaborate*state*evaluation-gets-supergoals-desired
    :default
   (goal <g> ^state <s> ^object <g2>)
   (<s> ^evaluation <e>)
   (goal <g2> ^desired <d>)
   -->
   (<e> ^desired <d> <d> &))

;;;			C.	default*implement*evaluation-operator*augment-evaluation-with-object 

(sp default*implement*evaluation-operator*augment-evaluation-with-object
    :default
   (goal <g> ^state <s> ^operator <o>)
   (<s> ^evaluation <e>)
   (<o> ^object <x> ^evaluation <e> ^type evaluation)
   -->
   (<e> ^object <x>))

;;;			D.	default*implement*evauate-object*augment-evaluation-with-type-of-operator-name
;;; This is a new production that augments an evaluation with a type.

(sp default*implement*evauate-object*augment-evaluation-with-type-of-operator-name
    :default
   (goal <g> ^state <s> ^operator <o>)
   (<s> ^evaluation <e>)
   (<o> ^name <name> ^evaluation <e> ^type evaluation)
   -->
   (<e> ^type <name>))


;;;
;;;		7.3.1.2 Applying the evaluate-object operator
;;;
;;;	Domain specific code may directly implement an evaluation, or an operator no-change may occur
;;; to do the job, see the next section.

;;;			A.	default*terminate*evaluate-object
;;; Reconsider evaluation operator after it finished in selection space.
                                      
(sp default*terminate*evaluate-object
    :default
   (goal <g> ^state <s> ^operator <o>)
   (<s> ^evaluation <e>)
   (<o> ^object <x>)
   (<e> ^object <x> ^value t)
   -->
   (<g> ^operator <o> @))


;;;
;;;		7.3.2   The evaluation subgoal
;;;

;;;
;;; These productions which fire once an evaluation subgoal has been created
;;; have also been generalized.

;;;			A.	default*implement*evaluation-operator*augment-goal-with-desired

(sp default*implement*evaluation-operator*augment-goal-with-desired
    :default
   (goal <g> ^impasse no-change ^attribute operator ^object <sg>)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^desired <d>)
   -->
   (<g> ^desired <d> + &))

;;;			B.	default*elaborate*goal*implement-evaluate-object*with-name-implement-evaluate-object

(sp default*elaborate*goal*implement-evaluate-object*with-name-implement-evaluate-object
    :default
   (goal <g>  ^impasse no-change ^attribute operator ^object <sg>)
   (goal <sg> ^operator <so>)
   (<so> ^name evaluate-object)
   -->
   (<g> ^name implement-evaluate-object))

;;;			C.	default*generic*propose*space*generic*on-no-change-for-evaluation-operator
;;; Create the appropriate context - given the attribute of the object being evaluated.
 
(sp default*generic*propose*space*generic*on-no-change-for-evaluation-operator
    :default
   (goal <g> ^impasse no-change ^attribute operator ^object <sg>)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation 
	 ^attribute << state operator >> ^superproblem-space <p>)
   -->
   (<g> ^problem-space <p> +))


;;;			D.	default*generic*propose*state*evaluation-operator-no-duplicate-state
;;; Set up lookahead context when no ^default-state-copy

(sp default*generic*propose*state*evaluation-operator-no-duplicate-state
    :default
   (goal <g> ^problem-space <p> ^object <sg> ^default-state-copy no)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^attribute state ^object <s>
	^superproblem-space <p>)
   -->
   (<g> ^state <s> + <))

;;;			E.	default*generic*propose*state*evaluation-operator-duplicate-state
;; install a copy of the state, when ^default-state-copying and there
;; is an operator tie.

(sp default*generic*propose*state*evaluation-operator-duplicate-state
    :default
   (goal <g> ^problem-space <p> ^object <sg> ^default-state-copy yes)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^attribute operator
	^superproblem-space <p> ^superstate <s>) 
   -->
   (<g> ^state <dup-state> ! +)
   (<dup-state> ^duplicate-of* <s>))

;;;			F.	default*generic*propose*state*evaluation-operator-no-duplicate-operator
;;; Set up lookahead context when no ^default-state-copy
;;; This could be generalized with rule D above. -BGM 6-Sep-90

(sp default*generic*propose*state*evaluation-operator-no-duplicate-operator
    :default
   (goal <g> ^problem-space <p> ^object <sg> ^default-state-copy no)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^attribute operator
	^superproblem-space <p> ^superstate <s>) 
   -->
   (<g> ^state <s> + <))

;;;			G.	default*generic*propose*operator*evaluation-operator-look-ahead--operator-duplicate

;;; Added test for superproblem-space.  This restricts these productions
;;; to only fire in a lookahead.  Previously, these productions made it
;;; impossible to use evaluation problem spaces other than lookahead.
;;; JEL 6/21/91

(sp default*generic*propose*operator*evaluation-operator-look-ahead--operator-duplicate
    :default
  (goal <sg> ^operator <so>)
  (<so> ^type evaluation ^attribute operator
	    ^default-operator-copy yes ^object <o> ^superproblem-space <sps>)
  (goal <g> ^problem-space <p> ^object <sg>)
  (<sps> ^name <n>)
  (<p> ^name <n>)
  -->
  (<g> ^look-ahead-operator <copy-o>)
  (<copy-o> ^duplicate-of* <o>))   


;;;			H.	default*generic*elaborate*goal*evaluation-goal*look-ahead-operator
;; Create pointer for uniform access even in no copy

;;; Added test for superproblem-space.  This restricts these productions
;;; to only fire in a lookahead.  Previously, these productions made it
;;; impossible to use evaluation problem spaces other than lookahead.
;;; JEL 6/21/91

(sp default*generic*elaborate*goal*evaluation-goal*look-ahead-operator
    :default
  (goal <sg> ^operator <so>)
  (<so> ^type evaluation ^attribute operator
	    ^default-operator-copy no ^object <o> ^superproblem-space <p>)
  (goal <g> ^problem-space <p> ^object <sg>)
  -->
  (<g> ^look-ahead-operator <o>))   


;;;			I.	default*generic*propose*operator*look-ahead
;;; install copy of operator in lookahead context.
;;; Why the acceptable preference here ?
;;; <p> / <ssp> checks to correct bug from TJ

(sp default*generic*propose*operator*look-ahead
    :default
  (goal <g> ^problem-space <p> ^state <s>
	^look-ahead-operator <o> ^object <sg>)
  (goal <sg> ^object <ssg>)
  (goal <ssg> ^problem-space <ssp>)
  (<p> ^name <n>)
  (<ssp> ^name <n>)
 - (<s> ^tried-tied-operator <o>)
   -->
   (<g> ^operator <o> ! +))   

;;;			J.	default*generic*implement*operator*duplicate-look-ahead-tried-tied-operator
;;; Detect that the operator has been tried when a duplicate is being used.

(sp default*generic*implement*operator*duplicate-look-ahead-tried-tied-operator
    :default
  (goal <g> ^problem-space <p> ^state <s> ^operator <o-copy> 
	^object <sg> ^default-operator-copy yes)
  (goal <sg> ^operator <so>)
  (<so> ^type evaluation ^attribute operator
	    ^superproblem-space <p> ^object <o>)
  (<o-copy> ^duplicate-of* <o>)
  -->
  (<s> ^tried-tied-operator <o-copy> + &))

;;;			K.	default*generic*implement*operator*no-duplicate-look-ahead-tried-tied-operator
;; Detect that the operator has been tried when a duplicate is not being used.
;     

(sp default*generic*implement*operator*no-duplicate-look-ahead-tried-tied-operator
  :o-support
    :default
  (goal <g> ^problem-space <p> ^state <s> ^operator <o>
	^object <sg> ^default-operator-copy no)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^attribute operator
                  ^superproblem-space <p> ^object <o>)
 -->
   (<s> ^tried-tied-operator <o> + &))

;;;			L.	default*generic*implement*evaluation-operator*evaluation-failure-if-no-operators-for-state 
;;; Give symbol-value failure when a state in the evaluation subgoal gets 
;;; prohibited or rejected).

(sp default*generic*implement*evaluation-operator*evaluation-failure-if-no-operators-for-state
    :default
  (goal <select-g> ^state <s> ^operator <o2>)
  (<s> ^evaluation <e2>)
  (<o2> ^type evaluation ^evaluation <e2>)
  (goal <eval-g> ^object <select-g> ^quiescence t)
  (goal <state-nc> ^object <eval-g> ^attribute state ^impasse no-change
	^quiescence t)
  (goal <goal-nc> ^object <state-nc> ^attribute goal ^impasse no-change ^quiescence t)
  -->
  (<e2> ^symbolic-value failure))

;;;			M.	default*generic*implement*evaluation-operator*evaluation-failure-if-prohibit-state 

(sp default*generic*implement*evaluation-operator*evaluation-failure-if-prohibit-state
    :default
  (goal <select-g> ^state <s> ^operator <o2>)
  (<s> ^evaluation <e2>)
  (<o2> ^type evaluation ^evaluation <e2>)
  (goal <eval-g> ^object <select-g>)
  (goal <rej-state-imp> ^object <eval-g> ^attribute state
	^impasse constraint-failure)
  -->
  (<e2> ^symbolic-value failure))

;;;			N.	default*generic*implement*evaluation-operator*state-to-symbolic-evaluation

(sp default*generic*implement*evaluation-operator*state-to-symbolic-evaluation
    :default
    (goal <g> ^state <s> ^object <sg>)    ; why is this here ? jel 10/10/89
    (goal <sg> ^state <ss> ^operator <so>) ;made <ssg> into <sg> jel 10/10/89
      (<ss> ^evaluation <e>)
      (<so> ^type evaluation; ^superstate <> <s> 
        ^evaluation <e> ^desired <eb>)
    (<s> ^ { << required-success success partial-success 
                      indifferent partial-failure failure prohibit-failure
                       draw lose win >> <svalue> } <eb> )
    -->
    (<e> ^symbolic-value <svalue>))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;			O.	default*generic*implement*evaluation-operator*state-to-symbolic-evaluation*duplicate-desired
;;                                Added to handle duplicated desireds
(sp default*generic*implement*evaluation-operator*state-to-symbolic-evaluation*duplicate-desired
    :default
  (goal <g> ^state <s> ^object <sg>)   
  (goal <sg> ^state <ss> ^operator <so>)
  (<ss> ^evaluation <e>)
  (<so> ^type evaluation ^evaluation <e> ^desired <eb>)
  (<s> ^ { << required-success success partial-success 
		    indifferent partial-failure failure prohibit-failure
		    draw lose win >> <svalue> } <deb> )
  (<deb> ^duplicate-of* <eb>)
  -->
  (<e> ^symbolic-value <svalue>))


;;;
;;;		7.3.2.1.	State Copying
;;;

;;;			A.	default*generic*elaborate*operator*type-evaluation*default-for-default-state-copy-is-yes
;; If no signals on problem space, the default is to copy both state and operator

(sp default*generic*elaborate*operator*type-evaluation*default-for-default-state-copy-is-yes 
    :default
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation 
	 ^attribute << state operator >> ^superproblem-space <p>)
  -(<p> ^default-state-copy no)
    -->
   (<so> ^default-state-copy yes))

;;;			B.	default*generic*elaborate*operator*type-evaluation*default-state-copy-from-problem-space

(sp default*generic*elaborate*operator*type-evaluation*default-state-copy-from-problem-space 
    :default
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation 
	 ^attribute << state operator >> ^superproblem-space <p>)
   (<p> ^default-state-copy <yes-or-no>)
    -->
   (<so> ^default-state-copy <yes-or-no>))

;;;			C.	default*generic*elaborate*goal*default-state-copy-from-type-evaluation-operator
;;; Default is that all-attributes-at-level are copied

(sp default*generic*elaborate*goal*default-state-copy-from-type-evaluation-operator 
    :default
   (goal <g> ^impasse no-change ^attribute operator ^object <sg>)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^default-state-copy <yes-no>)
    -->
    (<g> ^default-state-copy <yes-no>))

;;;			D.	default*generic*elaborate*goal*default-copy-is-all-attributes-at-level-one

(sp default*generic*elaborate*goal*default-copy-is-all-attributes-at-level-one 
    :default
   (goal <g> ^impasse no-change ^attribute operator ^object <sg>)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation 
	 ^attribute << state operator >> ^superproblem-space <p>)
   (<p>
         - ^all-attributes-at-level two
	 - ^one-level-attributes
	 - ^two-level-attributes
         - ^dont-copy
	 - ^dont-copy-anything)
    -->
    (<g> ^all-attributes-at-level one))

;;;			E.	default*generic*elaborate*goal*copy-all-attributes-at-level-one-from-problem-space
;;; We want ^all-attributes-at-level one to be on the goal, but if someone
;;; puts it on the space along with the other copying flags, we should allow
;;; that.  So, copy it from the space to the goal.

(sp default*generic*elaborate*goal*copy-all-attributes-at-level-one-from-problem-space 
    :default
   (goal <g> ^problem-space <p> ^default-state-copy yes)
   (<p> ^all-attributes-at-level one)
  -->
   (<g> ^all-attributes-at-level one))

;;;			F.	default*generic*propose*state*initial*require-duplicate-state 
;;; Install a copy of the state, when ^default-state-copying and there is a state tie.

(sp default*generic*propose*state*initial*require-duplicate-state 
    :default
   (goal <g> ^problem-space <p> ^object <sg> ^default-state-copy yes)
   (goal <sg> ^operator <so>)                          
   (<so> ^type evaluation ^attribute state ^object <s>
	^superproblem-space <p>)
   -->
   (<g> ^state <dup-state> ! +)
   (<dup-state> ^duplicate-of* <s>))

;;;			G.	default*generic*elaborate*goal*create-duplicates-table
;;; Set up identifier mapping table for state duplication. 

(sp default*generic*elaborate*goal*create-duplicates-table 
    :default
   (goal <g> ^impasse no-change ^attribute operator ^object <sg>)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^attribute << state operator >> 
	     ^default-state-copy yes)
    -->
   (<g> ^duplicates* <d> +))

;;;			H.	default*generic*elaborate*state*add-one-level-attributes
;;; Copy one-level-attributes.

;;; Replaced test for implement-evaluate-object with test for superproblem-
;;; space. Makes the productions more general and is consistent with other
;;; default productions for lookahead search.  JEL 6/21/91 

(sp default*generic*elaborate*state*add-one-level-attributes 
    :default
  (goal <sg> ^operator <so>)
  (<so> ^superproblem-space <p>)
  (goal <g> ^problem-space <p> ^state <dup-state> + ^object <sg>
	^default-state-copy yes)  
  (<p> ^one-level-attributes <att>)
  (<dup-state> ^duplicate-of* <s>)
  (<s> ^<att> <val>)
  -->
  (<dup-state> ^<att> <val> + &))

;;;			I.	default*generic*elaborate*state*add-all-attributes-at-level-one
;; Copy all attributes, when ^all-attributes-at-level one.

;;; Replaced test for implement-evaluate-object with test for superproblem-
;;; space. Makes the productions more general and is consistent with other
;;; default productions for lookahead search.  JEL 6/21/91 

(sp default*generic*elaborate*state*add-all-attributes-at-level-one 
    :default
  (goal <sg> ^operator <so>)
  (<so> ^superproblem-space <p>)
  (goal <g> ^problem-space <p> ^state <dup-state> + ^object <sg>
	^default-state-copy yes ^all-attributes-at-level one)
  (<p> - ^dont-copy-anything - ^dont-copy <att>
		     - ^two-level-attributes <att>)
  (<dup-state> ^duplicate-of* <s>)
  (<s> ^{ <> duplicate-of* <> tried-tied-operator <att> } <val>)
  -->
  (<dup-state> ^<att> <val> + &))

;;;			J.	default*generic*elaborate*state*change-one-level-attribute-to-duplicate
;;; If we copied a one-level-attribute, and it later turned
;;; out that its value happened to be something that was pointed to by a
;;; two-level-attribute, change its value to be the copied object.

(sp default*generic*elaborate*state*change-one-level-attribute-to-duplicate 
    :default
  (goal <g> ^problem-space <p> ^state <dup-state> + 
	^duplicates* <d> ^default-state-copy yes)
  (<p> ^one-level-attributes <att>)
  (<dup-state> ^duplicate-of* <s>)
  (<s> ^<att> <id>)
  (<d> ^<id> <new-id>)
  -->
  (<dup-state> ^<att> <id> - <new-id> + &))

;;;			K.	default*generic*elaborate*state*change-all-attributes-at-level-one-to-duplicate
;;; Fixes, when all-attributess-at-level one.
;;; Patched with PS condition per EMA's suggestion 13-Mar-91

(sp default*generic*elaborate*state*change-all-attributes-at-level-one-to-duplicate 
    :default
  (goal <g> ^problem-space <p> ^state <dup-state> + ^duplicates* <d>
	^default-state-copy yes ^all-attributes-at-level one)
   (<p> - ^dont-copy <att>)
   (<dup-state> ^duplicate-of* <s>)
   (<s> ^{ <> tried-tied-operator <att> } <id>)
   (<d> ^<id> <new-id>)
   -->
   (<dup-state> ^<att> <id> - <new-id> + &))

;;;			L.	default*generic*elaborate*goal*duplicate-id-for-attribute
;;; Create new ids for two-level-attributes.

(sp default*generic*elaborate*goal*duplicate-id-for-attribute 
    :default
  (goal <g> ^problem-space <p> ^state <dup-state> + 
	^duplicates* <d> ^default-state-copy yes)
  (<p> ^two-level-attributes <att>)
  (<dup-state> ^duplicate-of* <s>)
  (<s> ^<att> <id>)
  -->
  (<d> ^<id> <new-id> + =))

;;;			M.	default*generic*elaborate*goal*duplicate-id-for-all-attributes
;;; Create new ids for all attributes, when ^all-attributes-at-level two.

(sp default*generic*elaborate*goal*duplicate-id-for-all-attributes 
    :default
  (goal <g> ^problem-space <p> ^state <dup-state> + 
	^duplicates* <d> ^default-state-copy yes)
  (<p> - ^dont-copy-anything - ^dont-copy <att>
		 ^all-attributes-at-level two - ^one-level-attributes <att>)
  (<dup-state> ^duplicate-of* <s>)
  (<s> ^{ <> duplicate-of* <> tried-tied-operator <att> } <id>)
  -->
  (<d> ^<id> <new-id> + =))

;;;			N.	default*generic*elaborate*add-attribute-to-duplicate
;;; Create a copy of the old object on the new link.  First copy
;;; augmentations that don't point to objects that have been
;;; duplicated. 

(warnings off)
(sp default*generic*elaborate*add-attribute-to-duplicate 
    :default
  (goal <g> ^state <dup-state> + ^duplicates* <d> 
	^default-state-copy yes)
   (<d> ^<id> <new-id>)
   (<id> ^ { <> tried-tied-operator <sub-att> } <sub-val>)
   (<d> - ^<sub-val>)
   -->
   (<new-id> ^<sub-att> <sub-val> + &))
(warnings on)

;;;			O.	default*generic*elaborate*add-duplicated-attribute-to-duplicate
;;; Next copy augmentations that point to duplicated objects:

(warnings off)
(sp default*generic*elaborate*add-duplicated-attribute-to-duplicate 
    :default
  (goal <g> ^state <dup-state> + 
	^duplicates* <d> ^default-state-copy yes)
  (<d> ^<id> <new-id>)
  (<id> ^ { <> tried-tied-operator <sub-att> } <sub-val>)
  (<d> ^<sub-val> <new-val>)
  -->
  (<new-id> ^<sub-att> <new-val> + &))
(warnings on)

;;;			P.	default*generic*elaborate*state*add-duplicate-to-state
;;; Added ^two-level-attributes <att>.  Previously, it
;;; would copy any attribute that happened to point to the same value as
;;; one of the two-level-attributes.

(sp default*generic*elaborate*state*add-duplicate-to-state 
    :default
  (goal <g> ^problem-space <p> ^state <dup-state> + 
	^duplicates* <d> ^default-state-copy yes)
  (<p> ^two-level-attributes <att>)
  (<dup-state> ^duplicate-of* <s>)
  (<s> ^<att> <id>)
  (<d> ^<id> <new-id>)
  -->
  (<dup-state> ^<att> <new-id> + &))


;;;			Q.	default*generic*elaborate*state*add-duplicates-for-all-attributes
;;; moves the new links to the state when ^all-atts two.

(sp default*generic*elaborate*state*add-duplicates-for-all-attributes 
    :default
   (goal <g> ^problem-space <p> ^state <dup-state> + 
	^duplicates* <d> ^default-state-copy yes)
   (<p> ^all-attributes-at-level two
	   - ^dont-copy-anything - ^dont-copy <att>
	   - ^one-level-attributes <att>)
   (<dup-state> ^duplicate-of* <s>)
   (<s> ^{ <> tried-tied-operator <att> } <id>)
   (<d> ^<id> <new-id>)
   -->
   (<dup-state> ^<att> <new-id> + &))

;;;			R.	default*elaborate*goal*eval*desired
;; -------------------------------
;; Desired copying:
;; -------------------------------

;; Copy attributes to the duplicate desired state.  We
;; do this after the state is installed so that the duplicates table
;; will already have been filled in.  We just copy all attributes over
;; from the original operator, except that attributes that pointed to 
;; objects that have been duplicated (on the state) are modified to point
;; to the duplicate objects.

(sp default*elaborate*goal*eval*desired 
    :default
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^desired <d> ^default-desired-copy yes )
   (goal <g> ^object <sg>)
   -->
   (<g> ^desired <d-copy>)
   (<d-copy> ^duplicate-of* <d>))   

;;;			S.	default*state-to-symbolic-evaluation*duplicate-desired

#|

RBD 8/25/92 removed because it's a duplicate of default*generic*implement*evaluation-operator*state-to-symbolic-evaluation*duplicate-desired

(sp default*state-to-symbolic-evaluation*duplicate-desired
    :default
    (goal <g> ^state <s> ^object <sg>)    ; why is this here? jel 10/10/89
    (goal <sg> ^state <ss> ^operator <so>) ;made <ssg> into <sg> jel 10/10/89
      (<ss> ^evaluation <e>)
      (<so> ^type evaluation; ^superstate <> <s> 
        ^evaluation <e> ^desired <eb1>)
    (<s> ^ { << required-success success partial-success 
                      indifferent partial-failure failure prohibit-failure
                       draw lose win >> <svalue> } <eb> )
    (<eb> ^duplicate-of* <eb1>)
    -->
    (<e> ^symbolic-value <svalue>))
|#

;;;			T.	default*duplicate-desired*copy-old-value
;; Copy attributes whose values haven't been duplicated.

(sp default*duplicate-desired*copy-old-value
    :default
  (goal <g> ^problem-space <p> ^state <s> ^object <sg>
	^duplicates* <d> ^desired <o-copy>)
  (<o-copy> ^duplicate-of* <o>)
  (<o> ^ { <> duplicate-of* <att> } <val>
	     - ^ dont-copy <att>)
  (<d> - ^<val>)
  -->
  (<o-copy> ^<att> <val>))

;;;			U.	default*duplicate-desired*replace-old-value
;; Copy attributes whose values have been duplicated.

(sp default*duplicate-desired*replace-old-value
    :default
   (goal <g> ^problem-space <p> ^state <s>
	     ^duplicates* <d> ^desired <o-copy>)
   (<o-copy> ^duplicate-of* <o>)
   (<o> ^ { <> duplicate-of* <att> } <id>
	   - ^dont-copy <att>)
   (<d> ^<id> <copy-id>)
  -->
   (<o-copy> ^<att> <copy-id>))



;;;		7.3.2.3 Operator copying	
;;;
;;; Copy attributes to the duplicate operator.  We
;;; do this after the state is installed so that the duplicates table
;;; will already have been filled in.  We just copy all attributes over
;;; from the original operator, except that attributes that pointed to 
;;; objects that have been duplicated (on the state) are modified to point
;;; to the duplicate objects.

;;;			A.	default*generic*elaborate*operator*type-evaluation*default-for-default-operator-copy-is-yes

(sp default*generic*elaborate*operator*type-evaluation*default-for-default-operator-copy-is-yes 
    :default
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation 
	 ^attribute << state operator >> ^superproblem-space <p>)
  -(<p> ^default-operator-copy no)
    -->
   (<so> ^default-operator-copy yes))

;;;			B.	default*generic*elaborate*operator*type-evaluation*copy-default-operator-copy-from-problem-space

(sp default*generic*elaborate*operator*type-evaluation*copy-default-operator-copy-from-problem-space 
    :default
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation 
	 ^attribute << state operator >> ^superproblem-space <p>)
   (<p> ^default-operator-copy <yes-or-no>)
    -->
   (<so> ^default-operator-copy <yes-or-no>))

;;;			C.	default*generic*elaborate*goal*copy-default-operator-copy-from-type-evaluation-operator

(sp default*generic*elaborate*goal*copy-default-operator-copy-from-type-evaluation-operator 
    :default
   (goal <g> ^impasse no-change ^attribute operator ^object <sg>)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^default-operator-copy <yes-no>)
   -->
   (<g> ^default-operator-copy <yes-no>))

;;;			D.	default*generic*elaborate*goal*create-duplicates-table-for-operator-only
;;; Set up identifier mapping table for operator

(sp default*generic*elaborate*goal*create-duplicates-table-for-operator-only 
    :default
   (goal <g> ^impasse no-change ^attribute operator ^object <sg>)
   (goal <sg> ^operator <so>)
   (<so> ^type evaluation ^attribute << state operator >> 
	     ^default-operator-copy yes 
	     - ^default-state-copy yes)
    -->
   (<g> ^duplicates* <d> +))

;;;			E.	default*generic*elaborate*operator*add-attribute-to-duplicate-operator
;;; Copy attributes whose values haven't been duplicated.
;;;

(sp default*generic*elaborate*operator*add-attribute-to-duplicate-operator 
    :default
  (goal <g> ^problem-space <p> ^state <s> ^object <sg>
	^duplicates* <d> ^look-ahead-operator <o-copy>)
  (<o-copy> ^duplicate-of* <o>)
  (<o> ^ { <> duplicate-of* <att> } <val>
	     - ^ dont-copy <att>)
  (<d> - ^<val>)
  -->
  (<o-copy> ^<att> <val>))

;;;			F.	default*generic*elaborate*operator*add-duplicated-attribute-to-duplicate-operator
;;; Copy attributes whose values have been duplicated.

(sp default*generic*elaborate*operator*add-duplicated-attribute-to-duplicate-operator 
    :default
   (goal <g> ^problem-space <p> ^state <s>
	     ^duplicates* <d> ^look-ahead-operator <o-copy>)
   (<o-copy> ^duplicate-of* <o>)
   (<o> ^ { <> duplicate-of* <att> } <id>
	   - ^dont-copy <att>)
   (<d> ^<id> <copy-id>)
  -->
   (<o-copy> ^<att> <copy-id>))


;;;
;;;     7.3.3   Computing evaluations
;;;


;;;
;;;     7.3.3.1 Computing numeric evaluations
;;;
;;; This is domain specific, so there are no default productions for this.

;;;
;;;     7.3.3.2 Comparing numeric evaluations
;;;

;;;			A.	default*selection*compare*equal-evaluation-indifferent
;;;
;;; If two objects have equal evaluations they are indifferent.

(sp default*selection*compare*equal-evaluation-indifferent ; default*generic*elaborate*
    :default
   (goal <g> ^problem-space <p> ^state <s> ^attribute <role> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>  { <> <e1> <e2> })
   (goal <g2> ^problem-space <p2> ^state <s2> ^desired <d>)
   (<e1> ^object <x> ^numeric-value <v> ^desired <d> 
	       ^type evaluate-object)
   (<e2> ^object <y> ^numeric-value <v> ^desired <d> 
	       ^type evaluate-object)
 - (<d> ^equal not-indifferent)
   -->
   (<g2> ^<role> <x> = <y>))


;;;			B.	default*selection*compare*higher-evaluation-better
;;;
;;; Generate operator preferences based on their evaluations and info 
;;; as to whether higher or lower evaluations are better.

(sp default*selection*compare*higher-evaluation-better ; default*generic*elaborate*
    :default
   (goal <g> ^problem-space <p> ^state <s> ^attribute <role> ^object <g2>)
   (<p> ^name selection)
   (goal <g2> ^problem-space <p2> ^state <s2> ^desired <d>)
   (<s> ^evaluation <e1> ^evaluation { <> <e1> <e2> })
   (<d> ^better higher)
   (<e1> ^object <o1> ^numeric-value <v> ^desired <d>
                    ^type evaluate-object)
   (<e2> ^object <o2> ^numeric-value < <v> ^desired <d> 
                    ^type evaluate-object)
   -->
   (<g2> ^<role> <o2> < <o1>))

;;;			C.	default*selection*compare*prefer-lower-evaluation

(sp default*selection*compare*prefer-lower-evaluation ; default*generic*elaborate*
    :default
   (goal <g> ^problem-space <p> ^state <s> ^attribute <role> ^object <g2>)
   (<p> ^name selection)
   (goal <g2> ^problem-space <p2> ^state <s2> ^desired <d>)
   (<s> ^evaluation <e1> ^evaluation { <> <e1> <e2> })
   (<d> ^better lower)
   (<e1> ^object <o1> ^numeric-value <v> ^desired <d> 
                    ^type evaluate-object)
   (<e2> ^object <o2> ^numeric-value > <v> ^desired <d> 
                    ^type evaluate-object)
   -->
   (<g2> ^<role> <o2> < <o1>))


;;;
;;;		7.3.3.3 Computing symbolic evaluations
;;;


;;;			A.	default*selection*compare*same-symbolic-evaluations-are-indifferent

(sp default*selection*compare*same-symbolic-evaluations-are-indifferent
    :default
  (goal <g> ^problem-space <p> ^state <s> ^attribute <role> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>  { <> <e1> <e2> })
   (goal <g2> ^problem-space <p2> ^state <s2> ^desired <d>)
   (<e1> ^object <x> ^symbolic-value <v> ^desired <d> 
	       ^type evaluate-object)
   (<e2> ^object <y> ^symbolic-value <v> ^desired <d> 
	       ^type evaluate-object)
   -->
   (<g2> ^<role> <x> = <y>))

;;;			B.	default*selection*compare*success-evaluation-better-than-partial-success

(sp default*selection*compare*success-evaluation-better-than-partial-success
    :default
  (goal <g> ^problem-space <p> ^state <s> ^attribute <role> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>  { <> <e1> <e2> })
   (goal <g2> ^problem-space <p2> ^state <s2> ^desired <d>)
   (<e1> ^object <x> ^symbolic-value success ^desired <d> 
	       ^type evaluate-object)
   (<e2> ^object { <> <x> <y> } ^symbolic-value partial-success 
	       ^desired <d> ^type evaluate-object)
   -->
   (<g2> ^<role> <x> > <y>))

;;;			C.	default*selection*compare*partial-failure-evaluation-better-than-failure

(sp default*selection*compare*partial-failure-evaluation-better-than-failure
    :default
  (goal <g> ^problem-space <p> ^state <s> ^attribute <role> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>  { <> <e1> <e2> })
   (goal <g2> ^problem-space <p2> ^state <s2> ^desired <d>)
   (<e1> ^object <x> ^symbolic-value partial-failure ^desired <d> 
	       ^type evaluate-object)
   (<e2> ^object { <> <x> <y> } ^symbolic-value failure ^desired <d>
	       ^type evaluate-object)
   -->
   (<g2> ^<role> <x> > <y>))

;;;			D.	default*selection*select*required-success-evaluation-becomes-required-preference

(sp default*selection*select*required-success-evaluation-becomes-required-preference
    :default
   (goal <g> ^problem-space <p> ^state <s> ^operator <o> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>)
   (goal <g2> ^desired <eb> ^operator <o1> +)
   (<o> ^name evaluate-object ^evaluation <e1> 
	 ^desired <eb> ^object <o1> ^attribute <attribute>)
   (<e1> ^symbolic-value required-success)
   -->
   (<g2> ^<attribute> <o1> ! ))

;;;			E.	default*selection*select*success-evaluation-becomes-best-preference

(sp default*selection*select*success-evaluation-becomes-best-preference
    :default
   (goal <g> ^problem-space <p> ^state <s> ^operator <o> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>)
   (goal <g2> ^desired <eb> ^operator <o1> +)
   (<o> ^name evaluate-object ^evaluation <e1> 
	 ^desired <eb> ^object <o1> ^attribute <attribute>)
   (<e1> ^symbolic-value << partial-success success >> )
   -->
   (<g2> ^<attribute> <o1> > ))

;;;			F.	default*selection*select*indifferent-evaluation-becomes-indifferent-preference


(sp default*selection*select*indifferent-evaluation-becomes-indifferent-preference
    :default
    (goal <g2> ^desired <eb> ^operator <o1> +)
    (goal <g> ^problem-space <p> ^state <s> ^operator <o> ^object <g2>)
      (<p> ^name selection)
      (<s> ^evaluation <e1>)
      (<o> ^name evaluate-object ^evaluation <e1> 
         ^attribute <attribute> ^desired <eb> ^object <o1>)
       (<e1> ^symbolic-value indifferent)
    -->
    (<g2> ^<attribute> <o1> =))

;;;			G.	default*selection*select*partial-failure-evaluation-becomes-worst-preference

(sp default*selection*select*partial-failure-evaluation-becomes-worst-preference
    :default
   (goal <g> ^problem-space <p> ^state <s> ^operator <o> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>)
   (goal <g2> ^desired <e> ^operator <o1> +)
   (<o> ^name evaluate-object ^evaluation <e1> ^desired <e>
	^attribute <attribute> ^object <o1>)
   (<e1> ^symbolic-value partial-failure)
   -->
   (<g2> ^<attribute> <o1> < ))

;;;			H.	default*selection*select*failure-evaluation-becomes-reject-preference

(sp default*selection*select*failure-evaluation-becomes-reject-preference
    :default
   (goal <g> ^problem-space <p> ^state <s> ^operator <o> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>)
   (goal <g2> ^desired <e> ^operator <o1> +)
   (<o> ^name evaluate-object ^evaluation <e1> ^desired <e>
	^attribute <attribute> ^object <o1>)
   (<e1> ^symbolic-value << lose failure >> )
   -->
   (<g2> ^<attribute> <o1> - ))

;;;			I.	default*selection*select*prohibit-failure-evaluation-becomes-prohibit-preference

(sp default*selection*select*prohibit-failure-evaluation-becomes-prohibit-preference
    :default
   (goal <g> ^problem-space <p> ^state <s> ^operator <o> ^object <g2>)
   (<p> ^name selection)
   (<s> ^evaluation <e1>)
   (goal <g2> ^desired <e> ^operator <o1> +)
   (<o> ^name evaluate-object ^evaluation <e1> ^desired <e>
	^attribute <attribute> ^object <o1>)
   (<e1> ^symbolic-value prohibit-failure)
   -->
   (<g2> ^<attribute> <o1> ~ ))



;;;
;;;		7.3.3.4 Default evaluations
;;;

;;;			A.	default*pass-back-success
;; if an operator leads to success and it is being
;; tried out in a subgoal to evaluate another operator -
;; give that second operator a success evaluation also

(sp default*pass-back-success 	
    :default
   (goal <g> ^state <s> ^operator <o> ^object <sg>)
   (<s> ^evaluation <e1>)
   (<o> ^name evaluate-object ^evaluation <e1> ^desired <eb>)
   (<e1> ^symbolic-value << required-success success 
                                              partial-success >> )
   (goal <sg> ^object <ssg>)
   (goal <ssg> ^state <sss> ^operator <sso>)
   (<sss> ^evaluation <e2>)
   (<sso> ^name evaluate-object ^evaluation <e2> ^desired <eb>)
   -->
   (<e2> ^symbolic-value partial-success ))

;;;                     B.      default*failure-if-no-operators-for-state
;; give symbol-value failure when a state in the evaluation
;; subgoal gets prohibited or rejected)

#|
RBD 8/25/92 Removed because it is a duplicate of default*generic*implement*evaluation-operator*evaluation-failure-if-no-operators-for-state

(sp default*failure-if-no-operators-for-state 
    :default
  (goal <select-g> ^state <s> ^operator <o2>)
  (<s> ^evaluation <e2>)
  (<o2> ^type evaluation ^evaluation <e2>)
  (goal <eval-g> ^object <select-g> ^quiescence t)
  (goal <state-nc> ^object <eval-g> ^attribute state ^impasse no-change
	^quiescence t)
  (goal <goal-nc> ^object <state-nc> ^attribute goal ^impasse no-change ^quiescence t)
  -->
  (<e2> ^symbolic-value failure))
|#

;;;                     C.      default*failure-if-prohibit-state 

#|
RBD 8/25/92 Removed because it is a duplicate of default*generic*implement*evaluation-operator*evaluation-failure-if-prohibit-state

(sp default*failure-if-prohibit-state 
    :default
  (goal <select-g> ^state <s> ^operator <o2>)
  (<s> ^evaluation <e2>)
  (<o2> ^type evaluation ^evaluation <e2>)
  (goal <eval-g> ^object <select-g>)
  (goal <rej-state-imp> ^object <eval-g> ^attribute state
	^impasse constraint-failure)
  -->
  (<e2> ^symbolic-value failure))
|#


;;;
;;;		7.3.3.5 Novalue evaluations
;;;

;;;			A.	default*selection*compare*novalue-evaluation-always-worse
;;; Make novalue worse than any other value.

(sp default*selection*compare*novalue-evaluation-always-worse
    :default
   (goal <g> ^problem-space <p> ^state <s> ^attribute <role> ^object <g2>)
   (<p> ^name selection)
   (goal <g2> ^problem-space <p2> ^state <s2> ^desired <d>)
   (<s> ^evaluation <e1> ^evaluation { <> <e1> <e2> })
   (<e1> ^object <o1> ^numeric-value novalue ^desired <d>
                    ^type evaluate-object)
   (<e2> ^object <o2> ^numeric-value <> novalue ^desired <d>
                    ^type evaluate-object)
   -->
   (<g2> ^<role> <o2> > <o1>))


;;;
;;;	     7.3.4   Halting Soar with success or failure
;;;

;;;			A.	default*top-goal*halt*state*success
;;; Handle state augmentations dealing with goal termination for the top-level goal.

(sp default*top-goal*halt*state*success
    :default
  (goal <g> ^state <s> ^name <name> ^desired <eb> ^object nil) 
  (<s> ^<< required-success success >> <eb>)
  -->
  (write (crlf)  | | goal  | | <name>  | | achieved | | )
  (halt))

;;;			B.	default*top-goal*halt*state*failure

(sp default*top-goal*halt*state*failure
    :default
  (goal <g> ^problem-space <p> ^state <s> ^object nil ^desired <eb> ^name <name>) 
  (<s> ^ << prohibit-failure failure >> <eb>)
  -->
  (write (crlf)  | | goal  | | <name>  | | failed | | )
  (halt))


;;;
;;;		7.3.4	Operator Subgoaling
;;;          operator subgoaling 
;;;         there are two ways to do operator subgoal
;;;         just pass down most recent operator - or pass down all of them
;;;         this implementation passes down just the super operator as the
;;;         desired - uncomment default*generic*opsub*goal*elaborate*all-desireds if you want all supergoals
;;;         to be included)

;;;			A.	default*generic*opsub*propose*space*generic
;;; make the super-problem space the default
;;;         when there is a no-change for the operator
;;;   make is worst so operator implementation will win out

(sp default*generic*opsub*propose*space*generic
    :default
  (goal <g> ^impasse no-change ^attribute operator 
	^object <g2>)
  (goal <g2> ^problem-space <p2>)
  -->
  (<g> ^problem-space <p2> + < ))

;;;			B.	default*generic*opsub*elaborate*goal*name*operator-subgoal
;;;if the superproblem-space is selected as the
;;;         current problem space then operator subgoaling
;;;         is being used so select the superstate -
;;;         the super-operator becomes the desired)

(sp default*generic*opsub*elaborate*goal*name*operator-subgoal
    :default
  (goal <g> ^problem-space <p> 
	^impasse no-change ^attribute operator ^object <g2>)
  (goal <g2> ^problem-space <p>)
  -->
  (<g> ^name operator-subgoal + <))

;;;			C.	default*generic*opsub*elaborate*goal*desired

(sp default*generic*opsub*elaborate*goal*desired
    :default
  (goal <g> ^problem-space <p> ^name operator-subgoal ^object <g2>)
  (goal <g2> ^operator <o>)
  -->
  (<g> ^desired <o>))

;;;			D.	default*generic*opsub*state*initial-state*require
;;;NOTE: Unlike the selection problem-space, when operator subgoaling
;;;     the state is not duplicated.  Thus any destructive changes made to 
;;;     get the operator to apply are done directly to the state of interest.

(sp default*generic*opsub*state*initial-state*require
    :default
  (goal <g> ^name operator-subgoal ^problem-space <p> ^object <g2>)
  (goal <g2> ^state <s>)
  -->
  (<g> ^state <s> ! +))

;;;			E.	default*generic*opsub*goal*elaborate*all-desireds
;;; The following is commented out; it would provide for keeping track
;;;  of all levels of operator subgoaling, not just the most recent. 
;;; Pass down all super operator subgoals as well.
#|
(sp default*generic*opsub*goal*elaborate*all-desireds
    :default
  (goal <g> ^problem-space <p> 
	^impasse no-change ^attribute operator ^object <g2>)
  (goal <g2> ^problem-space <p> ^state <s> ^desired <o>)
  -->
  (goal <g> ^desired <o>))

|#
;;;			F.	default*generic*select*operator*reject-desired
;;;don't select the operator for the operator that we are 
;;;        subgoaling on.  

(sp default*generic*select*operator*reject-desired
    :default
  (goal <g> ^name operator-subgoal ^problem-space <p> ^state <s> ^desired <o>)
  -->
  (<g> ^operator <o> - ))

;;;			G.	default*generic*opsub*detect*state*success
;;if there is an evaluation subgoal within
;;;         an operator subgoal and the operator being
;;;         subgoaled on is applied - success

;; BUGBUG:  This doesn't work any more, because there is no ^applied flag
;; in Soar 6.  --RBD 8/25/92
(sp default*generic*opsub*detect*state*success
    :default
  (goal <g-eval> ^problem-space <p> ^state <s> ^desired <o> ^applied <o>)
  -->
  (<s> ^success <o>))

;;; added in response to JEL -- 2-Oct-90

(sp opsub*select-operator*subgoaling 
    :default
  (goal <g1> ^name implement-evaluate-object ^problem-space <p> ^state <s>
              ^operator ^desired <o>
   	-^operator <o>)
  (<o> ^name)
  -->
  (<g1> ^operator <o> <o> !))

;;;
;;;		7.5     Execution monitoring
;;;

;;;			A.	default*monitor*goal*success
;;; If the state is marked with ^success <d>, the goal succeeds.

(sp default*monitor*goal*success
    :default
	(goal <top> ^object nil - ^verbose false)
	(goal <g> ^name <gname> ^state <s> ^desired <d>)
	(<s> ^<< partial-success required-success success >> <d>)
	-->
	(write (crlf) |  Goal | <gname> | succeeded. |))

;;;			B.	default*monitor*goal*failure
;;; If the state is marked with ^failure <d>, the goal fails.

(sp default*monitor*goal*failure
    :default
	(goal <top> ^object nil - ^verbose false)
	(goal <g> ^name <gname> ^state <s> ^desired <d>)
	(<s> ^<< partial-failure failure prohibit-failure >> <d>)
	-->
	(write (crlf) |  Goal | <gname> | failed. |))

;;;			C.	default*monitor*operator*evaluation
;;; Print the evaluation of any object that has a name (which doesn't
;;; get states).

(sp default*monitor*operator*evaluation
    :default
	(goal <top> ^object nil -^verbose false)
	(goal <g> ^operator <o>)
	(<o> ^type evaluation ^object <obj> ^evaluation <e>)
	(<e> ^ << numeric-value symbolic-value >> <n>)
	(<obj> ^name <name>)
	-->
	(write (crlf) |  Evaluation of | <obj> | (|
		<name> |) is | <n>))

;;;			D.	default*monitor*attribute-impasses

(sp default*monitor*attribute-impasses 
    :default
	(goal <top> ^object nil -^verbose false)
	(impasse <i> ^object <obj> ^attribute <att> ^impasse <impasse>)
	-->
	(write (crlf) |  Impasse for | <obj> | ^|
		<att> | type: | <impasse>))



;;;
;;;		16.	Stop-default
;;; Declare that this is the end of the default productions.

